/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.domain.address;

import com.jgoodies.app.domain.CodeName;
import com.jgoodies.app.domain.CodeNameEntity;
import com.jgoodies.common.base.Strings;
import java.util.Locale;

public interface Country
extends CodeName {
    public static final Locale SWITZERLAND = new Locale("de", "CH");

    default public boolean isDefault() {
        return false;
    }

    default public boolean isEmpty() {
        return Strings.isBlank(this.getName());
    }

    public static class BaseCountry
    extends CodeNameEntity
    implements Country {
        public BaseCountry() {
            super("", "");
        }

        public BaseCountry(String code, String name) {
            super(code, name);
        }

        @Override
        public boolean isDefault() {
            return this.isGermany() && "Deutschland".equals(this.getName()) || this.isSwitzerland() && "Schweiz".equals(this.getName());
        }

        protected boolean isGermany() {
            return Locale.getDefault().equals(Locale.GERMANY);
        }

        protected boolean isSwitzerland() {
            return Locale.getDefault().equals(SWITZERLAND);
        }
    }

    public static final class Builder {
        final BaseCountry target = new BaseCountry();

        public Builder name(String value) {
            this.target.setName(value);
            return this;
        }

        public BaseCountry build() {
            return this.target;
        }
    }
}

