/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.content.preferences;

import com.jgoodies.app.gui.basics.AppResources;
import com.jgoodies.application.Application;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.jsdl.action.I18nActionBuilder;
import com.jgoodies.dialogs.basics.BasicVerification;
import com.jgoodies.dialogs.core.pane.property.AbstractPropertyPaneModel;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneModel;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.framework.setup.BasicApplicationPreferences;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.Action;

public final class AppPreferencesModel
extends PresentationModel<BasicApplicationPreferences> {
    private static final String ACTION_RESET_VERIFICATIONS = "jgoodies.app.preferences.ResetVerifications";
    private final AbstractPropertyPaneModel propertyPaneModel = new PrefsPropertyPanelModel();
    private final BasicApplicationPreferences original;
    private Action resetVerificationsAction;

    private AppPreferencesModel(BasicApplicationPreferences original, BasicApplicationPreferences work) {
        super(work);
        this.original = original;
    }

    public static AppPreferencesModel direct(BasicApplicationPreferences original) {
        AppPreferencesModel model = new AppPreferencesModel(original, original);
        model.addBeanPropertyChangeListener(evt -> model.store());
        return model;
    }

    public static AppPreferencesModel copied(BasicApplicationPreferences original) {
        return new AppPreferencesModel(original, Objects.deepCopy(original));
    }

    PropertyPaneModel getPropertyPaneModel() {
        return this.propertyPaneModel;
    }

    Action getResetVerificationsAction() {
        if (this.resetVerificationsAction == null) {
            this.resetVerificationsAction = new I18nActionBuilder().handler(this::onResetVerificationsPerformed).resources(AppResources.getResourceMap()).id(ACTION_RESET_VERIFICATIONS).build();
        }
        return this.resetVerificationsAction;
    }

    private void onResetVerificationsPerformed(ActionEvent evt) {
        BasicVerification.resetAll();
        this.propertyPaneModel.setAllChangesAbandonable(false);
    }

    private Preferences store() {
        Preferences prefs = Application.getInstance().getContext().getUserPreferences();
        ((BasicApplicationPreferences)this.getBean()).storeIn(prefs);
        return prefs;
    }

    private final class PrefsPropertyPanelModel
    extends AbstractPropertyPaneModel {
        private PrefsPropertyPanelModel() {
        }

        @Override
        public void onOKPerformed(ActionEvent evt) {
            AppPreferencesModel.this.original.readFrom(AppPreferencesModel.this.store());
            JSDLUtils.closePaneFor(evt);
            AppPreferencesModel.this.release();
        }

        @Override
        public void onCancelPerformed(ActionEvent evt) {
            JSDLUtils.closePaneFor(evt);
            AppPreferencesModel.this.release();
        }

        @Override
        public void onApplyPerformed(ActionEvent evt) {
        }
    }
}

