/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractChart;
import com.jgoodies.chart.ChartUtils;
import com.jgoodies.common.swing.internal.RenderingUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.Format;
import javax.swing.Icon;
import javax.swing.UIManager;

public final class BarChart<T>
extends AbstractChart<T> {
    public static final String PROPERTY_LEFT_ALIGN_TEXT = "leftAlignText";
    private static final int MINIMUM_TEXT_ICON_WIDTH = 40;
    private static final int MINIMUM_BAR_WIDTH = 60;
    private static final int ICON_TEXT_PAD = 4;
    private static final int TEXT_BAR_PAD = 8;
    private static final int SIZE_LABEL_PAD = 2;
    private static final int SHADOW_WIDTH = 3;
    private static final float LINE_TO_BAR_HEIGHT = 0.85f;
    private boolean leftAlignText;
    private long maxSize;
    private int maxIconWidth;
    private int[] barY;
    private int[] barWidths;
    private int textWidth;
    private int lineHeight;
    private int barHeight;

    public BarChart(Format format) {
        this(format, true);
    }

    public BarChart(Format format, boolean leftAlignText) {
        super(format);
        this.leftAlignText = leftAlignText;
    }

    public boolean getLeftAlignText() {
        return this.leftAlignText;
    }

    public void setLeftAlignText(boolean newValue) {
        boolean oldValue = this.getLeftAlignText();
        this.leftAlignText = newValue;
        this.firePropertyChange(PROPERTY_LEFT_ALIGN_TEXT, oldValue, newValue);
        this.invalidateCache();
        this.repaint();
    }

    @Override
    protected int getIndexAt(Point position) {
        if (this.hasEmptyModel() || !this.cacheIsValid()) {
            return -1;
        }
        int line = (int)position.getY() / this.lineHeight;
        return line < this.getModel().getItemCount() ? line : -1;
    }

    @Override
    protected void render(Graphics2D g2) {
        FontMetrics fm = g2.getFontMetrics();
        this.lineHeight = fm.getHeight() + 4;
        this.textWidth = this.computeTextWidth(fm);
        int xStart = this.textWidth + 8;
        int xEnd = this.getWidth() - 1;
        int yStart = 1;
        this.computeTextAndBarWidths(xStart, xEnd, yStart);
        this.renderAllLines(g2, xStart, xEnd, fm);
    }

    @Override
    protected void validateCache() {
        this.maxSize = 0L;
        int itemCount = this.model.getItemCount();
        for (int index = 0; index < itemCount; ++index) {
            long dataSize = this.model.getSize(index);
            if (dataSize <= this.maxSize) continue;
            this.maxSize = dataSize;
        }
        this.maxIconWidth = this.computeMaxIconWidth();
    }

    private int computeMaxIconWidth() {
        int maxWidth = 0;
        int itemCount = this.model.getItemCount();
        for (int index = 0; index < itemCount; ++index) {
            int width;
            Icon icon = this.model.getIcon(index);
            if (icon == null || (width = icon.getIconWidth()) <= maxWidth) continue;
            maxWidth = width;
        }
        return 0 == maxWidth ? maxWidth : maxWidth + 4;
    }

    private int computeMaxTextWidth(FontMetrics fm) {
        int maxWidth = 0;
        int itemCount = this.model.getItemCount();
        for (int index = 0; index < itemCount; ++index) {
            int width = fm.stringWidth(this.model.getText(index));
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private void computeTextAndBarWidths(int xStart, int xEnd, int yStart) {
        int paneWidth = xEnd - xStart;
        int maxBarWidth = paneWidth - 3;
        this.barHeight = Math.round((float)this.lineHeight * 0.85f);
        int barYOffset = yStart;
        int itemCount = this.model.getItemCount();
        this.barWidths = new int[itemCount];
        this.barY = new int[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            this.barY[i] = barYOffset + i * this.lineHeight;
            int plainWidth = 0L == this.maxSize ? 0 : Math.round((float)maxBarWidth * (float)this.model.getSize(i) / (float)this.maxSize);
            this.barWidths[i] = Math.max(1, plainWidth);
        }
    }

    private int computeTextWidth(FontMetrics fm) {
        int freeWidth = this.getWidth() - 60 - 8;
        int maxTextWidth = this.computeMaxTextWidth(fm);
        return Math.max(40, Math.min(this.maxIconWidth + maxTextWidth, freeWidth));
    }

    private void renderAllLines(Graphics2D g2, int xStart, int xEnd, FontMetrics fm) {
        int textOffset = (this.barHeight + fm.getAscent()) / 2 - 1;
        Color foreground = UIManager.getColor("controlText");
        int itemCount = this.model.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            int y = this.barY[i];
            int labelY = y + textOffset;
            int barWidth = this.barWidths[i];
            this.renderIcon(g2, this.model.getIcon(i), 0, y - 1);
            this.renderLabel(g2, fm, foreground, this.model.getText(i), xStart, labelY);
            BarChart.renderBar(g2, this.model.getColor(i), xStart, y, barWidth, this.barHeight);
            if (!this.getShowSize()) continue;
            this.renderSize(g2, fm, foreground, this.model.getSize(i), xStart, labelY, barWidth, xEnd - xStart);
        }
    }

    private void renderIcon(Graphics2D g2, Icon icon, int x, int y) {
        if (icon != null) {
            icon.paintIcon(this, g2, x, y + (this.lineHeight - icon.getIconHeight()) / 2);
        }
    }

    private void renderLabel(Graphics2D g2, FontMetrics fm, Color foreground, String text, int x, int y) {
        int textEnd = x - 8;
        String clippedText = ChartUtils.clipText(text, fm, textEnd - this.maxIconWidth);
        g2.setColor(foreground);
        int labelX = this.leftAlignText ? this.maxIconWidth : textEnd - fm.stringWidth(clippedText);
        RenderingUtils.drawString(this, g2, clippedText, labelX, y);
    }

    private static void renderBar(Graphics2D g2, Color background, int x, int y, int width, int height) {
        g2.setColor(background);
        g2.fillRect(x, y, width, height);
        g2.setColor(Color.DARK_GRAY);
        g2.drawRect(x, y, width, height);
    }

    private void renderSize(Graphics2D g2, FontMetrics fm, Color foreground, long size, int x, int y, int barWidth, int width) {
        String formattedSize = this.formatSize(size);
        int sizeWidth = fm.stringWidth(formattedSize);
        int widthAndPad = sizeWidth + 4;
        int widthBehindBar = width - barWidth;
        if (barWidth > widthAndPad) {
            int sizeX = (barWidth - sizeWidth) / 2;
            g2.setColor(Color.BLACK);
            RenderingUtils.drawString(this, g2, formattedSize, x + sizeX, y);
        } else if (widthBehindBar > widthAndPad) {
            int sizeX = barWidth + 4;
            g2.setColor(foreground);
            RenderingUtils.drawString(this, g2, formattedSize, x + sizeX, y);
        }
    }
}

