/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.util;

import com.jgoodies.binding.adapter.Bindings;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.im.InputContext;
import java.text.ParseException;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.text.JTextComponent;

public final class TextComponentUtils {
    private TextComponentUtils() {
    }

    public static void commitImmediately() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = focusManager.getPermanentFocusOwner();
        if (!(c instanceof JTextComponent)) {
            return;
        }
        JTextComponent tc = (JTextComponent)c;
        if (!tc.isEditable()) {
            return;
        }
        if (tc instanceof JFormattedTextField) {
            TextComponentUtils.commitImmediately((JFormattedTextField)c);
        } else {
            TextComponentUtils.commitImmediately(tc);
        }
    }

    private static void commitImmediately(JFormattedTextField field) {
        Optional<Boolean> isEdited = TextComponentUtils.isEdited(field);
        if (isEdited.isPresent() && isEdited.get() == Boolean.FALSE) {
            return;
        }
        InputContext ic = field.getInputContext();
        if (ic != null) {
            ic.endComposition();
        }
        int fb = field.getFocusLostBehavior();
        switch (fb) {
            case 0: 
            case 1: {
                try {
                    field.commitEdit();
                    field.setValue(field.getValue());
                }
                catch (ParseException pe) {
                    if (fb != 1) break;
                    field.setValue(field.getValue());
                }
                break;
            }
            case 2: {
                field.setValue(field.getValue());
                break;
            }
        }
    }

    private static void commitImmediately(JTextComponent textComponent) {
        Bindings.commitImmediately();
    }

    private static Optional<Boolean> isEdited(JFormattedTextField field) {
        for (Action action : field.getActions()) {
            String name = (String)action.getValue("Name");
            if (!"reset-field-edit".equals(name)) continue;
            return Optional.of(action.isEnabled());
        }
        return Optional.empty();
    }
}

