/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.MicroLayouts;
import javax.swing.UIDefaults;

public final class MicroLayoutPolicies {
    private MicroLayoutPolicies() {
    }

    public static MicroLayoutPolicy getDefaultPlasticPolicy() {
        return new DefaultPlasticPolicy();
    }

    public static MicroLayoutPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    private static final class DefaultPlasticPolicy
    implements MicroLayoutPolicy {
        private DefaultPlasticPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean is125;
            ScreenScaling.ScaleFactor scaleFactor = ScreenScaling.getScaleFactor();
            boolean is100 = scaleFactor == ScreenScaling.ScaleFactor.F100;
            boolean bl = is125 = scaleFactor == ScreenScaling.ScaleFactor.F125;
            if ("JGoodies Plastic".equals(lafName)) {
                if (is100) {
                    return MicroLayouts.createPlasticMicroLayout100();
                }
                if (is125) {
                    return MicroLayouts.createPlasticMicroLayout125();
                }
                return MicroLayouts.createPlasticModernMicroLayoutHigh(scaleFactor.intValue());
            }
            if (is100) {
                return MicroLayouts.createPlasticModernMicroLayout100();
            }
            if (is125) {
                return MicroLayouts.createPlasticModernMicroLayout125();
            }
            return MicroLayouts.createPlasticModernMicroLayoutHigh(scaleFactor.intValue());
        }
    }

    private static final class DefaultWindowsPolicy
    implements MicroLayoutPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isClassic;
            ScreenScaling.ScaleFactor scaleFactor = ScreenScaling.getScaleFactor();
            boolean is100 = scaleFactor == ScreenScaling.ScaleFactor.F100;
            boolean is125 = scaleFactor == ScreenScaling.ScaleFactor.F125;
            boolean bl = isClassic = !SystemUtils.IS_LAF_WINDOWS_XP_ENABLED;
            if (isClassic) {
                if (is100) {
                    return MicroLayouts.createWindowsClassicMicroLayout100();
                }
                if (is125) {
                    return MicroLayouts.createWindowsClassicMicroLayout125();
                }
                return MicroLayouts.createWindowsModernMicroLayoutHigh(scaleFactor.intValue());
            }
            if (is100) {
                return MicroLayouts.createWindowsModernMicroLayout100();
            }
            if (is125) {
                return MicroLayouts.createWindowsModernMicroLayout125();
            }
            return MicroLayouts.createWindowsModernMicroLayoutHigh(scaleFactor.intValue());
        }
    }
}

