/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.dispatcher.impl;

import java.util.LinkedList;
import java.util.Queue;
import org.netbeans.installer.downloader.dispatcher.impl.Worker;

public class WorkersPool {
    private final int capacity;
    private int inUse;
    private Queue<Worker> freeWorkers = new LinkedList<Worker>();

    public WorkersPool(int poolCapacity) {
        this.capacity = poolCapacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public synchronized int remaining() {
        return this.capacity - this.inUse;
    }

    public synchronized Worker tryAcquire() {
        if (this.inUse == this.capacity) {
            return null;
        }
        ++this.inUse;
        Worker worker = this.freeWorkers.poll();
        return worker != null && worker.isAlive() ? worker : new Worker();
    }

    public synchronized Worker acquire() throws InterruptedException {
        Worker worker;
        while ((worker = this.tryAcquire()) == null) {
            this.wait();
        }
        return worker;
    }

    public synchronized void release(Worker worker) {
        --this.inUse;
        if (worker.isAlive()) {
            this.freeWorkers.offer(worker);
        } else if (Thread.State.NEW == worker.getState()) {
            this.freeWorkers.offer(worker);
        }
        this.notify();
    }

    public synchronized void stopWaitingWorkers() {
    }
}

