/*
	AppHack - An Application Bundle Editor and Application Theme Tool for Mac OS X

    Copyright (C) 2004-2006 	Sveinbjorn Thordarson <sveinbjornt@simnet.is>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#import "DocType.h"
#import "STUtil.h"

@implementation DocType

- init
{
    self = [super init];
    return self;
}

/*- dealloc
{
	if (icon != NULL)
		[icon release];
	[super dealloc];
}*/

- initWithDictionary:(NSMutableDictionary*)theDict forBundle: (NSBundle *)theBundle
{
	self = [self init];
	if ([theDict objectForKey: @"CFBundleTypeIconFile"] != NULL)
	{
		NSString	*iconPath = [theBundle pathForResource: [STUtil cutSuffix: [theDict objectForKey: @"CFBundleTypeIconFile"]]  ofType: @"icns"];
		icon = [[NSImage alloc] initWithContentsOfFile: iconPath];
		//icon = [[NSImage alloc] initByReferencingFile: iconPath];// this speeds up loading time but makes interface sluggier
	}
	dict = theDict;
	return self;
}

+ (DocType *)docTypeWithDictionary: (NSMutableDictionary *)theDict forBundle: (NSBundle *)theBundle
{
	return [[[DocType alloc] initWithDictionary: theDict forBundle: theBundle] autorelease];
}


- (NSMutableDictionary *)dict
{
	return dict;
}

- (void)setDict: (NSMutableDictionary *)theDict
{
	if (dict != NULL)
		[dict release];
	dict = theDict;
}

- (NSImage *)getIcon
{
	//if this document type entry doesn't specify any icon, we just provide the generic document icon
	if (([dict objectForKey: @"CFBundleTypeIconFile"] == NULL && icon == NULL) || (icon == NULL))
	{
		//return [[NSWorkspace sharedWorkspace] iconForFileType: NSFileTypeForHFSTypeCode(kGenericDocumentIcon)];
		return [NSImage imageNamed: @"noicon"];
	}
	else
		return icon;
}
- (void)setIcon: (NSImage *)image
{
	icon = [image retain];
}

- (NSString *)getDocTypeName
{
	if ([dict objectForKey: @"CFBundleTypeName"] == NULL)
		return @"Unnamed File Type";
	else
		return [dict objectForKey: @"CFBundleTypeName"];
}

- (void)setDocTypeName: (NSString *)name
{
	if ([name length] > 0)
		[dict setObject: name forKey: @"CFBundleTypeName"];
}

- (NSString *)getIconName
{
	if ([dict objectForKey: @"CFBundleTypeIconFile"] == NULL)
		return @"<Not Set>";
	else
		return [dict objectForKey: @"CFBundleTypeIconFile"];
}

- (void)setIconName: (NSString *)iconName
{
	[dict setObject: iconName forKey: @"CFBundleTypeIconFile"];
}


- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	if ([[aTableView autosaveName] isEqualToString: @"Suffixes"])
		return([[dict objectForKey: @"CFBundleTypeExtensions"] count]);
	else if ([[aTableView autosaveName] isEqualToString: @"FileTypes"])
		return([[dict objectForKey: @"CFBundleTypeOSTypes"] count]);
	else
		return 0;
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if ([[aTableView autosaveName] isEqualToString: @"Suffixes"])
	{
		NSArray	*suffixList = [dict objectForKey: @"CFBundleTypeExtensions"];
		return([suffixList objectAtIndex: rowIndex]);
	}
	else if ([[aTableView autosaveName] isEqualToString: @"FileTypes"])
	{
		NSArray	*fileTypeList = [dict objectForKey: @"CFBundleTypeOSTypes"];
		return([fileTypeList objectAtIndex: rowIndex]);
	}
	return 0;
}

- (void)tableView:(NSTableView *)aTableView setObjectValue: anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if ([[aTableView autosaveName] isEqualToString: @"Suffixes"])
	{
		NSMutableArray	*suffixList = [dict objectForKey: @"CFBundleTypeExtensions"];
		//make sure index is valid
		if (rowIndex < 0 || rowIndex > [suffixList count]-1)
			return;
		//make sure that the text being put in is valid
		if (![(NSString *)anObject isEqualToString: @""])
			[suffixList replaceObjectAtIndex: rowIndex withObject: anObject];
	}
	else if ([[aTableView autosaveName] isEqualToString: @"FileTypes"])
	{
		NSMutableArray	*fileTypeList = [dict objectForKey: @"CFBundleTypeOSTypes"];
		//make sure index is valid
		if (rowIndex < 0 || rowIndex > [fileTypeList count]-1)
			return;
		//make sure that the text being put in is valid
		if (![(NSString *)anObject isEqualToString: @""] && [(NSString *)anObject length] == 4)
			[fileTypeList replaceObjectAtIndex: rowIndex withObject: anObject];
	}
}

@end
