/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.io.ChangesetCellRenderer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;

public class CloseChangesetDialog
extends JDialog {
    private JList<Changeset> lstOpenChangesets;
    private boolean canceled;
    private DefaultListModel<Changeset> model;
    private SideButton btnCloseChangesets;

    protected JPanel buildTopPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel(I18n.tr("<html>Please select the changesets you want to close</html>", new Object[0])), "Center");
        return pnl;
    }

    protected JPanel buildCenterPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.model = new DefaultListModel();
        this.lstOpenChangesets = new JList<Changeset>(this.model);
        pnl.add((Component)new JScrollPane(this.lstOpenChangesets), "Center");
        this.lstOpenChangesets.setCellRenderer(new ChangesetCellRenderer());
        return pnl;
    }

    protected JPanel buildSouthPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        CloseAction closeAction = new CloseAction();
        this.lstOpenChangesets.addListSelectionListener(closeAction);
        this.btnCloseChangesets = new SideButton(closeAction);
        pnl.add(this.btnCloseChangesets);
        InputMapUtils.enableEnter(this.btnCloseChangesets);
        SideButton btn = new SideButton(new CancelAction());
        pnl.add(btn);
        btn.setFocusable(true);
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Open changesets", new Object[0]));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildTopPanel(), "North");
        this.getContentPane().add((Component)this.buildCenterPanel(), "Center");
        this.getContentPane().add((Component)this.buildSouthPanel(), "South");
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        this.addWindowListener(new WindowEventHandler());
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(300, 300))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public CloseChangesetDialog() {
        super((Window)GuiHelper.getFrameForComponent(MainApplication.getMainFrame()), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setChangesets(Collection<Changeset> changesets) {
        if (changesets == null) {
            changesets = new ArrayList<Changeset>();
        }
        this.model.removeAllElements();
        for (Changeset cs : changesets) {
            this.model.addElement(cs);
        }
        if (!changesets.isEmpty()) {
            this.lstOpenChangesets.getSelectionModel().setSelectionInterval(0, changesets.size() - 1);
        }
    }

    public Collection<Changeset> getSelectedChangesets() {
        return this.lstOpenChangesets.getSelectedValuesList();
    }

    class CloseAction
    extends AbstractAction
    implements ListSelectionListener {
        CloseAction() {
            this.putValue("Name", I18n.tr("Close changesets", new Object[0]));
            new ImageProvider("closechangeset").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Close the selected open changesets", new Object[0]));
            this.refreshEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CloseChangesetDialog.this.setCanceled(false);
            CloseChangesetDialog.this.setVisible(false);
        }

        protected void refreshEnabledState() {
            List list = CloseChangesetDialog.this.lstOpenChangesets.getSelectedValuesList();
            this.setEnabled(list != null && !list.isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.refreshEnabledState();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Cancel closing of changesets", new Object[0]));
        }

        public void cancel() {
            CloseChangesetDialog.this.setCanceled(true);
            CloseChangesetDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
            CloseChangesetDialog.this.btnCloseChangesets.requestFocusInWindow();
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }
}

