/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Logging;
import org.w3c.dom.Element;

public class GeoImageSessionExporter
extends AbstractSessionExporter<GeoImageLayer> {
    public GeoImageSessionExporter(GeoImageLayer layer) {
        super(layer);
    }

    @Override
    public Collection<Layer> getDependencies() {
        if (((GeoImageLayer)this.layer).getGpxLayer() != null) {
            return Collections.singleton(((GeoImageLayer)this.layer).getGpxLayer());
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel lbl = new JLabel(((GeoImageLayer)this.layer).getName(), ((GeoImageLayer)this.layer).getIcon(), 10);
        lbl.setToolTipText(((GeoImageLayer)this.layer).getToolTipText());
        lbl.setLabelFor(this.export);
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        return p;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerElem = support.createElement("layer");
        layerElem.setAttribute("type", "geoimage");
        layerElem.setAttribute("version", "0.1");
        GeoImageSessionExporter.addAttr("show-thumbnails", Boolean.toString(((GeoImageLayer)this.layer).isUseThumbs()), layerElem, support);
        for (ImageEntry entry : ((GeoImageLayer)this.layer).getImages()) {
            Element posElem;
            Element imgElem = support.createElement("geoimage");
            if (entry.getFile() == null) {
                Logging.warn("No file attribute for image - skipping entry");
                break;
            }
            GeoImageSessionExporter.addAttr("file", entry.getFile().getPath(), imgElem, support);
            GeoImageSessionExporter.addAttr("thumbnail", Boolean.toString(entry.hasThumbnail()), imgElem, support);
            if (entry.getPos() != null) {
                posElem = support.createElement("position");
                posElem.setAttribute("lat", Double.toString(entry.getPos().lat()));
                posElem.setAttribute("lon", Double.toString(entry.getPos().lon()));
                imgElem.appendChild(posElem);
            }
            if (entry.getSpeed() != null) {
                GeoImageSessionExporter.addAttr("speed", entry.getSpeed().toString(), imgElem, support);
            }
            if (entry.getElevation() != null) {
                GeoImageSessionExporter.addAttr("elevation", entry.getElevation().toString(), imgElem, support);
            }
            if (entry.hasGpsTime()) {
                GeoImageSessionExporter.addAttr("gps-time", Long.toString(entry.getGpsInstant().toEpochMilli()), imgElem, support);
            }
            if (entry.getExifOrientation() != null) {
                GeoImageSessionExporter.addAttr("exif-orientation", Integer.toString(entry.getExifOrientation()), imgElem, support);
            }
            if (entry.hasExifTime()) {
                GeoImageSessionExporter.addAttr("exif-time", Long.toString(entry.getExifInstant().toEpochMilli()), imgElem, support);
            }
            if (entry.hasExifGpsTime()) {
                GeoImageSessionExporter.addAttr("exif-gps-time", Long.toString(entry.getExifGpsInstant().toEpochMilli()), imgElem, support);
            }
            if (entry.getExifCoor() != null) {
                posElem = support.createElement("exif-coordinates");
                posElem.setAttribute("lat", Double.toString(entry.getExifCoor().lat()));
                posElem.setAttribute("lon", Double.toString(entry.getExifCoor().lon()));
                imgElem.appendChild(posElem);
            }
            if (entry.getExifImgDir() != null) {
                GeoImageSessionExporter.addAttr("exif-image-direction", entry.getExifImgDir().toString(), imgElem, support);
            }
            if (entry.hasNewGpsData()) {
                GeoImageSessionExporter.addAttr("is-new-gps-data", Boolean.toString(entry.hasNewGpsData()), imgElem, support);
            }
            layerElem.appendChild(imgElem);
        }
        return layerElem;
    }

    private static void addAttr(String name, String value, Element element, SessionWriter.ExportSupport support) {
        Element attrElem = support.createElement(name);
        attrElem.appendChild(support.createTextNode(value));
        element.appendChild(attrElem);
    }
}

