/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public abstract class OsmPrimitive
extends AbstractPrimitive
implements TemplateEngineDataProvider {
    private static final String SPECIAL_VALUE_ID = "id";
    private static final String SPECIAL_VALUE_LOCAL_NAME = "localname";
    static volatile SearchCompiler.Match directionKeys;
    private static final SearchCompiler.Match reversedDirectionKeys;
    private StyleCache mappaintStyle;
    private DataSet dataSet;
    private Object referrers;

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> primitives) {
        return (primitives != null ? primitives.stream() : Stream.empty()).flatMap(p -> p.referrers(OsmPrimitive.class)).collect(Collectors.toSet());
    }

    protected OsmPrimitive(long id, boolean allowNegativeId) {
        if (allowNegativeId) {
            this.id = id;
        } else {
            if (id < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", id));
            }
            this.id = id == 0L ? this.getIdGenerator().generateUniqueId() : id;
        }
        this.version = 0;
        this.setIncomplete(id > 0L);
    }

    protected OsmPrimitive(long id, int version, boolean allowNegativeId) {
        this(id, allowNegativeId);
        this.version = id > 0L ? version : 0;
        this.setIncomplete(id > 0L && version == 0);
    }

    @Override
    public final StyleCache getCachedStyle() {
        return this.mappaintStyle;
    }

    @Override
    public final void setCachedStyle(StyleCache mappaintStyle) {
        this.mappaintStyle = mappaintStyle;
    }

    @Override
    public final boolean isCachedStyleUpToDate() {
        return this.mappaintStyle != null && this.mappaintCacheIdx == this.dataSet.getMappaintCacheIndex();
    }

    @Override
    public final void declareCachedStyleUpToDate() {
        this.mappaintCacheIdx = this.dataSet.getMappaintCacheIndex();
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive must be part of the dataset: " + this.toString());
        }
    }

    protected final void checkDatasetNotReadOnly() {
        if (this.dataSet != null && this.dataSet.isLocked()) {
            throw new DataIntegrityProblemException("Primitive cannot be modified in read-only dataset: " + this.toString());
        }
    }

    protected boolean writeLock() {
        if (this.dataSet != null) {
            this.dataSet.beginUpdate();
            return true;
        }
        return false;
    }

    protected void writeUnlock(boolean locked) {
        if (locked && this.dataSet != null) {
            this.dataSet.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOsmId(long id, int version) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            if (id <= 0L) {
                throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
            }
            if (version <= 0) {
                throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
            }
            if (this.dataSet != null && id != this.id) {
                DataSet datasetCopy = this.dataSet;
                datasetCopy.removePrimitive(this);
                this.id = id;
                datasetCopy.addPrimitive(this);
            }
            super.setOsmId(id, version);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void clearOsmMetadata() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        super.clearOsmMetadata();
    }

    @Override
    public void setUser(User user) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setUser(user);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangesetId(int changesetId) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            int old = this.changesetId;
            super.setChangesetId(changesetId);
            if (this.dataSet != null) {
                this.dataSet.fireChangesetIdChanged(this, old, changesetId);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    @Deprecated
    public void setTimestamp(Date timestamp) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setTimestamp(timestamp);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    private void updateFlagsNoLock(short flag, boolean value) {
        super.updateFlags(flag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateFlags(short flag, boolean value) {
        boolean locked = this.writeLock();
        try {
            this.updateFlagsNoLock(flag, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDisabledState(boolean hidden) {
        boolean locked = this.writeLock();
        try {
            boolean bl = super.setDisabledState(hidden);
            return bl;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public boolean unsetDisabledState() {
        boolean locked = this.writeLock();
        try {
            boolean bl = super.unsetDisabledState();
            return bl;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public void setPreserved(boolean isPreserved) {
        this.updateFlags((short)8192, isPreserved);
    }

    @Override
    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isDisabledAndHidden() {
        return (this.flags & 0x10) != 0 && (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isPreserved() {
        return (this.flags & 0x2000) != 0;
    }

    @Override
    public boolean isSelectable() {
        return !this.isDisabled() && this.isDrawable() && !this.isDisabled();
    }

    @Override
    public boolean isDrawable() {
        return (this.flags & 0x2C) == 0;
    }

    @Override
    public void setModified(boolean modified) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setModified(modified);
            if (this.dataSet != null) {
                this.dataSet.firePrimitiveFlagsChanged(this);
            }
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setVisible(visible);
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setDeleted(deleted);
            if (this.dataSet != null) {
                if (deleted) {
                    this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
                }
            }
            this.clearCachedStyle();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    protected final void setIncomplete(boolean incomplete) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            if (this.dataSet != null && incomplete != this.isIncomplete()) {
                if (incomplete) {
                    this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
                }
            }
            super.setIncomplete(incomplete);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    @Override
    public boolean isMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.referrers instanceof Relation && ((OsmPrimitive)this.referrers).isSelected();
        }
        return Arrays.stream((OsmPrimitive[])this.referrers).anyMatch(ref -> ref instanceof Relation && ref.isSelected());
    }

    @Override
    public boolean isOuterMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.isOuterMemberOfMultipolygon((OsmPrimitive)this.referrers);
        }
        return Arrays.stream((OsmPrimitive[])this.referrers).anyMatch(this::isOuterMemberOfMultipolygon);
    }

    private boolean isOuterMemberOfMultipolygon(OsmPrimitive ref) {
        return ref instanceof Relation && ref.isSelected() && ((Relation)ref).isMultipolygon() && ((Relation)ref).getMembersFor(Collections.singleton(this)).stream().anyMatch(rm -> "outer".equals(rm.getRole()));
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        if (this.isHighlighted() != highlighted) {
            this.updateFlags((short)2048, highlighted);
            if (this.dataSet != null) {
                this.dataSet.fireHighlightingChanged();
            }
        }
    }

    @Override
    public boolean isHighlighted() {
        return (this.flags & 0x800) != 0;
    }

    private static SearchCompiler.Match compileDirectionKeys(String prefName, String defaultValue) throws AssertionError {
        try {
            return SearchCompiler.compile(Config.getPref().get(prefName, defaultValue));
        }
        catch (SearchParseError e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to compile pattern for " + prefName + ", trying default pattern:", e);
            try {
                return SearchCompiler.compile(defaultValue);
            }
            catch (SearchParseError e2) {
                throw new AssertionError("Unable to compile default pattern for direction keys: " + e2.getMessage(), e2);
            }
        }
    }

    private void updateTagged() {
        this.updateFlagsNoLock((short)512, this.hasKeys() && this.keys().anyMatch(key -> !OsmPrimitive.isUninterestingKey(key) && !"area".equals(key)));
    }

    private void updateAnnotated() {
        this.updateFlagsNoLock((short)4096, this.hasKeys() && OsmPrimitive.getWorkInProgressKeys().stream().anyMatch(this::hasKey));
    }

    @Override
    public boolean isTagged() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isAnnotated() {
        return (this.flags & 0x1000) != 0;
    }

    protected void updateDirectionFlags() {
        boolean hasDirections = false;
        boolean directionReversed = false;
        if (reversedDirectionKeys.match(this)) {
            hasDirections = true;
            directionReversed = true;
        }
        if (directionKeys.match(this)) {
            hasDirections = true;
        }
        this.updateFlagsNoLock((short)1024, directionReversed);
        this.updateFlagsNoLock((short)256, hasDirections);
    }

    @Override
    public boolean hasDirectionKeys() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public boolean reversedDirection() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public final void setKeys(TagMap keys) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setKeys(keys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final void setKeys(Map<String, String> keys) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.setKeys(keys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String key, String value) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.put(key, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final void remove(String key) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.remove(key);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final void removeAll() {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            super.removeAll();
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    protected void keysChangedImpl(Map<String, String> originalKeys) {
        this.clearCachedStyle();
        if (this.dataSet != null) {
            for (OsmPrimitive ref : this.getReferrers()) {
                ref.clearCachedStyle();
            }
        }
        this.updateDirectionFlags();
        this.updateTagged();
        this.updateAnnotated();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, originalKeys);
        }
    }

    protected void addReferrer(OsmPrimitive referrer) {
        this.checkDatasetNotReadOnly();
        if (this.referrers == null) {
            this.referrers = referrer;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != referrer) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, referrer};
            }
        } else {
            for (OsmPrimitive primitive : (OsmPrimitive[])this.referrers) {
                if (primitive != referrer) continue;
                return;
            }
            this.referrers = Utils.addInArrayCopy((OsmPrimitive[])this.referrers, referrer);
        }
    }

    protected void removeReferrer(OsmPrimitive referrer) {
        this.checkDatasetNotReadOnly();
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == referrer) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] orig = (OsmPrimitive[])this.referrers;
            int idx = IntStream.range(0, orig.length).filter(i -> orig[i] == referrer).findFirst().orElse(-1);
            if (idx == -1) {
                return;
            }
            if (orig.length == 2) {
                this.referrers = orig[1 - idx];
            } else {
                OsmPrimitive[] smaller = new OsmPrimitive[orig.length - 1];
                System.arraycopy(orig, 0, smaller, 0, idx);
                System.arraycopy(orig, idx + 1, smaller, idx, smaller.length - idx);
                this.referrers = smaller;
            }
        }
    }

    private <T extends OsmPrimitive> Stream<T> referrers(boolean allowWithoutDataset, Class<T> filter) {
        if (this.dataSet == null && allowWithoutDataset) {
            return Stream.empty();
        }
        this.checkDataset();
        if (this.referrers == null) {
            return Stream.empty();
        }
        Stream<OsmPrimitive> stream = this.referrers instanceof OsmPrimitive ? Stream.of((OsmPrimitive)this.referrers) : Arrays.stream((OsmPrimitive[])this.referrers);
        return stream.filter(p -> p.dataSet == this.dataSet).filter(filter::isInstance).map(filter::cast);
    }

    public final <T extends OsmPrimitive> Stream<T> referrers(Class<T> filter) {
        return this.referrers(false, filter);
    }

    public final List<OsmPrimitive> getReferrers(boolean allowWithoutDataset) {
        return this.referrers(allowWithoutDataset, OsmPrimitive.class).collect(Collectors.toList());
    }

    public final List<OsmPrimitive> getReferrers() {
        return this.getReferrers(false);
    }

    public void visitReferrers(OsmPrimitiveVisitor visitor) {
        if (visitor != null) {
            this.doVisitReferrers(o -> o.accept(visitor));
        }
    }

    @Override
    public void visitReferrers(PrimitiveVisitor visitor) {
        if (visitor != null) {
            this.doVisitReferrers(o -> o.accept(visitor));
        }
    }

    private void doVisitReferrers(Consumer<OsmPrimitive> visitor) {
        if (this.referrers == null) {
            return;
        }
        if (this.referrers instanceof OsmPrimitive) {
            OsmPrimitive ref = (OsmPrimitive)this.referrers;
            if (ref.dataSet == this.dataSet) {
                visitor.accept(ref);
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] refs;
            for (OsmPrimitive ref : refs = (OsmPrimitive[])this.referrers) {
                if (ref.dataSet != this.dataSet) continue;
                visitor.accept(ref);
            }
        }
    }

    protected final boolean isNodeReferredByWays(int n) {
        if (this.referrers == null) {
            return false;
        }
        this.checkDataset();
        if (this.referrers instanceof OsmPrimitive) {
            return n <= 1 && this.referrers instanceof Way && ((OsmPrimitive)this.referrers).dataSet == this.dataSet;
        }
        int counter = 0;
        for (OsmPrimitive o : (OsmPrimitive[])this.referrers) {
            if (this.dataSet != o.dataSet || !(o instanceof Way) || ++counter < n) continue;
            return true;
        }
        return false;
    }

    public abstract void accept(OsmPrimitiveVisitor var1);

    public final void cloneFrom(OsmPrimitive other) {
        this.cloneFrom(other, true);
    }

    protected void cloneFrom(OsmPrimitive other, boolean copyChildren) {
        if (this.id != other.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        super.cloneFrom(other);
        this.clearCachedStyle();
    }

    public void mergeFrom(OsmPrimitive other) {
        this.checkDatasetNotReadOnly();
        boolean locked = this.writeLock();
        try {
            CheckParameterUtil.ensureParameterNotNull(other, "other");
            if (other.isNew() ^ this.isNew()) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not", new Object[0]));
            }
            if (!other.isNew() && other.getId() != this.id) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, other.getId()));
            }
            this.setKeys(other.hasKeys() ? other.getKeys() : null);
            this.timestamp = other.timestamp;
            this.version = other.version;
            this.setIncomplete(other.isIncomplete());
            this.flags = other.flags;
            this.user = other.user;
            this.changesetId = other.changesetId;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public final boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        return this.hasEqualSemanticAttributes(other, false);
    }

    boolean hasEqualSemanticFlags(OsmPrimitive other) {
        if (!this.isNew() && this.id != other.id) {
            return false;
        }
        return !(this.isIncomplete() ^ other.isIncomplete());
    }

    boolean hasEqualSemanticAttributes(OsmPrimitive other, boolean testInterestingTagsOnly) {
        return this.hasEqualSemanticFlags(other) && (testInterestingTagsOnly ? this.hasSameInterestingTags(other) : this.getKeys().equals(other.getKeys()));
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive other) {
        return other != null && this.timestamp == other.timestamp && this.version == other.version && this.changesetId == other.changesetId && this.isDeleted() == other.isDeleted() && this.isModified() == other.isModified() && this.isVisible() == other.isVisible() && Objects.equals(this.user, other.user);
    }

    public void load(PrimitiveData data) {
        this.checkDatasetNotReadOnly();
        this.setKeys(data.hasKeys() ? data.getKeys() : null);
        this.setRawTimestamp(data.getRawTimestamp());
        this.user = data.getUser();
        this.setChangesetId(data.getChangesetId());
        this.setDeleted(data.isDeleted());
        this.setModified(data.isModified());
        this.setVisible(data.isVisible());
        this.setIncomplete(data.isIncomplete());
        this.version = data.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData data) {
        data.setId(this.id);
        data.setKeys(this.hasKeys() ? this.getKeys() : null);
        data.setRawTimestamp(this.getRawTimestamp());
        data.setUser(this.user);
        data.setDeleted(this.isDeleted());
        data.setModified(this.isModified());
        data.setVisible(this.isVisible());
        data.setIncomplete(this.isIncomplete());
        data.setChangesetId(this.changesetId);
        data.setVersion(this.version);
    }

    public abstract void updatePosition();

    @Override
    protected String getFlagsAsString() {
        StringBuilder builder = new StringBuilder(super.getFlagsAsString());
        if (this.isDisabled()) {
            if (this.isDisabledAndHidden()) {
                builder.append('h');
            } else {
                builder.append('d');
            }
        }
        if (this.isTagged()) {
            builder.append('T');
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                builder.append('<');
            } else {
                builder.append('>');
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OsmPrimitive that = (OsmPrimitive)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Override
    public Collection<String> getTemplateKeys() {
        return Stream.concat(Stream.of(SPECIAL_VALUE_ID, SPECIAL_VALUE_LOCAL_NAME), this.keys()).collect(Collectors.toList());
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (special) {
            String lc = name.toLowerCase(Locale.ENGLISH);
            if (SPECIAL_VALUE_ID.equals(lc)) {
                return this.getId();
            }
            if (SPECIAL_VALUE_LOCAL_NAME.equals(lc)) {
                return this.getLocalName();
            }
            return null;
        }
        return this.getIgnoreCase(name);
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        return condition.match(this);
    }

    public static Set<Relation> getParentRelations(Collection<? extends OsmPrimitive> primitives) {
        return primitives.stream().flatMap(p -> p.referrers(Relation.class)).collect(Collectors.toSet());
    }

    public final boolean hasAreaTags() {
        return this.hasKey("building", "landuse", "amenity", "shop", "building:part", "boundary", "historic", "place", "area:highway") || this.hasTag("area", "yes") || this.hasTag("waterway", "riverbank") || this.hasTag("highway", "rest_area", "services", "platform") || this.hasTag("railway", "platform") || this.hasTagDifferent("leisure", "picnic_table", "slipway", "firepit") || this.hasTag("natural", "water", "wood", "scrub", "wetland", "grassland", "heath", "rock", "bare_rock", "sand", "beach", "scree", "bay", "glacier", "shingle", "fell", "reef", "stone", "mud", "landslide", "sinkhole", "crevasse", "desert") || this.hasTag("aeroway", "aerodrome");
    }

    public abstract boolean concernsArea();

    public abstract boolean isOutsideDownloadArea();

    protected abstract void addToBBox(BBox var1, Set<PrimitiveId> var2);

    static {
        String reversedDirectionDefault = "oneway=\"-1\"";
        String directionDefault = "oneway? | (aerialway=chair_lift & -oneway=no) | (aerialway=rope_tow & -oneway=no) | (aerialway=magic_carpet & -oneway=no) | (aerialway=zip_line & -oneway=no) | (aerialway=drag_lift & -oneway=no) | (aerialway=t-bar & -oneway=no) | (aerialway=j-bar & -oneway=no) | (aerialway=platter & -oneway=no) | waterway=stream | waterway=river | waterway=ditch | waterway=drain | waterway=tidal_channel | (\"piste:type\"=downhill & -area=yes) | (\"piste:type\"=sled & -area=yes) | (man_made=\"piste:halfpipe\" & -area=yes) | (junction=circular & -oneway=no) | junction=roundabout | (highway=motorway & -oneway=no & -oneway=reversible) | (highway=motorway_link & -oneway=no & -oneway=reversible)";
        reversedDirectionKeys = OsmPrimitive.compileDirectionKeys("tags.reversed_direction", reversedDirectionDefault);
        directionKeys = OsmPrimitive.compileDirectionKeys("tags.direction", directionDefault);
    }
}

