/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.GenericSessionExporter;

public class GpxTracksSessionExporter
extends GenericSessionExporter<GpxLayer> {
    public GpxTracksSessionExporter(GpxLayer layer) {
        this(layer, "tracks");
    }

    protected GpxTracksSessionExporter(GpxLayer layer, String type) {
        super(layer, type, "0.1", "gpx");
        if (layer.data == null) {
            throw new IllegalArgumentException("GPX layer without data: " + layer);
        }
    }

    @Override
    protected void addDataFile(OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        GpxWriter w = new GpxWriter(new PrintWriter(writer));
        w.write(((GpxLayer)this.layer).data);
        w.flush();
    }
}

