/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.text.ParseException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.tools.I18n;

public final class GpxTimezone {
    public static final GpxTimezone ZERO = new GpxTimezone(0.0);
    private final double timezone;

    public GpxTimezone(double hours) {
        this.timezone = hours;
    }

    public double getHours() {
        return this.timezone;
    }

    public String formatTimezone() {
        StringBuilder ret = new StringBuilder();
        double tz = this.timezone;
        if (tz < 0.0) {
            ret.append('-');
            tz = -tz;
        } else {
            ret.append('+');
        }
        ret.append((long)tz).append(':');
        int minutes = (int)(tz % 1.0 * 60.0);
        if (minutes < 10) {
            ret.append('0');
        }
        ret.append(minutes);
        return ret.toString();
    }

    public static GpxTimezone parseTimezone(String timezone) throws ParseException {
        if (timezone.isEmpty()) {
            return ZERO;
        }
        Matcher m = Pattern.compile("^([\\+\\-]?)(\\d{1,2})(?:\\:([0-5]\\d))?$").matcher(timezone);
        ParseException pe = new ParseException(I18n.tr("Error while parsing timezone.\nExpected format: {0}", "\u00b1HH:MM"), 0);
        try {
            if (m.find()) {
                int sign = "-".equals(m.group(1)) ? -1 : 1;
                int hour = Integer.parseInt(m.group(2));
                int min = m.group(3) == null ? 0 : Integer.parseInt(m.group(3));
                return new GpxTimezone((double)sign * ((double)hour + (double)min / 60.0));
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException ex) {
            pe.initCause(ex);
        }
        throw pe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GpxTimezone)) {
            return false;
        }
        GpxTimezone timezone1 = (GpxTimezone)o;
        return Double.compare(timezone1.timezone, this.timezone) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.timezone);
    }
}

