/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class LargeTextTable
extends JTable {
    private int fontHeight;
    private int charWidth;

    public LargeTextTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return this.getFontHeight();
            }
            case 0: {
                return this.getCharWidth();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    private int getFontHeight() {
        if (this.fontHeight == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.fontHeight = fontMetrics.getHeight();
        }
        return this.fontHeight;
    }

    private int getCharWidth() {
        if (this.charWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.charWidth = fontMetrics.charWidth('m');
        }
        return this.charWidth;
    }
}

