/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class VersionHandler
extends RequestHandler {
    public static final String command = "version";

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        this.content = RequestProcessor.PROTOCOLVERSION;
        this.contentType = "application/json";
        if (this.args.containsKey("jsonp")) {
            this.content = (String)this.args.get("jsonp") + " && " + (String)this.args.get("jsonp") + '(' + this.content + ')';
        }
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to report its protocol version. This enables web sites to detect a running JOSM.", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.READ_PROTOCOL_VERSION;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[0];
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"jsonp"};
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
    }

    @Override
    public String getUsage() {
        return "returns the current protocol version of the installed JOSM RemoteControl";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/version", "/version?jsonp=test"};
    }
}

