/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Tag;

public class TagMap
extends AbstractMap<String, String>
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final String[] EMPTY_TAGS = new String[0];
    private volatile String[] tags;

    public TagMap() {
        this((String[])null);
    }

    public TagMap(Map<String, String> tags) {
        this.putAll(tags);
    }

    public TagMap(TagMap tagMap) {
        this(tagMap.tags);
    }

    public TagMap(String ... tags) {
        if (tags == null || tags.length == 0) {
            this.tags = EMPTY_TAGS;
        } else {
            if (tags.length % 2 != 0) {
                throw new IllegalArgumentException("tags array length needs to be multiple of two.");
            }
            this.tags = tags;
        }
    }

    public TagMap(Iterable<Tag> tags) {
        this.tags = EMPTY_TAGS;
        for (Tag tag : tags) {
            this.put(tag.getKey(), tag.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new TagEntrySet(this.tags);
    }

    @Override
    public boolean containsKey(Object key) {
        return TagMap.indexOfKey(this.tags, key) >= 0;
    }

    @Override
    public String get(Object key) {
        int index = TagMap.indexOfKey(this.tags, key);
        return index < 0 ? null : this.tags[index + 1];
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 1; i < this.tags.length; i += 2) {
            if (!value.equals(this.tags[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized String put(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        int index = TagMap.indexOfKey(this.tags, key);
        int newTagArrayLength = this.tags.length;
        if (index < 0) {
            index = newTagArrayLength;
            newTagArrayLength += 2;
        }
        String[] newTags = Arrays.copyOf(this.tags, newTagArrayLength);
        String old = newTags[index + 1];
        newTags[index] = key;
        newTags[index + 1] = value;
        this.tags = newTags;
        return old;
    }

    @Override
    public synchronized String remove(Object key) {
        int index = TagMap.indexOfKey(this.tags, key);
        if (index < 0) {
            return null;
        }
        String old = this.tags[index + 1];
        int newLength = this.tags.length - 2;
        if (newLength == 0) {
            this.tags = EMPTY_TAGS;
        } else {
            String[] newTags = new String[newLength];
            System.arraycopy(this.tags, 0, newTags, 0, index);
            System.arraycopy(this.tags, index + 2, newTags, index, newLength - index);
            this.tags = newTags;
        }
        return old;
    }

    @Override
    public synchronized void clear() {
        this.tags = EMPTY_TAGS;
    }

    @Override
    public int size() {
        return this.tags.length / 2;
    }

    public List<Tag> getTags() {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (int i = 0; i < this.tags.length; i += 2) {
            tagList.add(new Tag(this.tags[i], this.tags[i + 1]));
        }
        return tagList;
    }

    private static int indexOfKey(String[] tags, Object key) {
        for (int i = 0; i < tags.length; i += 2) {
            if (!tags[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TagMap[");
        boolean first = true;
        for (Map.Entry<String, String> e : this.entrySet()) {
            if (!first) {
                stringBuilder.append(',');
            }
            stringBuilder.append(e.getKey());
            stringBuilder.append('=');
            stringBuilder.append(e.getValue());
            first = false;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    String[] getTagsArray() {
        return this.tags;
    }

    private static class TagEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final String[] tags;

        TagEntrySet(String ... tags) {
            this.tags = tags;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new TagEntryIterator(this.tags);
        }

        @Override
        public int size() {
            return this.tags.length / 2;
        }
    }

    private static class TagEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private final String[] tags;
        private int currentIndex;

        TagEntryIterator(String ... tags) {
            this.tags = tags;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.tags.length;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tag tag = new Tag(this.tags[this.currentIndex], this.tags[this.currentIndex + 1]);
            this.currentIndex += 2;
            return tag;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

