/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

class NotificationManager {
    private final Timer hideTimer;
    private final Timer pauseTimer;
    private final Timer unfreezeDelayTimer;
    private boolean running;
    private Notification currentNotification;
    private NotificationPanel currentNotificationPanel;
    private final Deque<Notification> queue = new LinkedList<Notification>();
    private static final IntegerProperty pauseTime = new IntegerProperty("notification-default-pause-time-ms", 300);
    private long displayTimeStart;
    private long elapsedTime;
    private static NotificationManager instance;
    private static final Color PANEL_SEMITRANSPARENT;
    private static final Color PANEL_OPAQUE;

    NotificationManager() {
        this.hideTimer = new Timer(Notification.TIME_DEFAULT, e -> this.stopHideTimer());
        this.hideTimer.setRepeats(false);
        this.pauseTimer = new Timer(pauseTime.get(), new PauseFinishedEvent());
        this.pauseTimer.setRepeats(false);
        this.unfreezeDelayTimer = new Timer(10, new UnfreezeEvent());
        this.unfreezeDelayTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showNotification(Notification note) {
        Deque<Notification> deque = this.queue;
        synchronized (deque) {
            if (Objects.equals(note, this.currentNotification) || Objects.equals(note, this.queue.peekLast())) {
                Logging.debug("Dropping duplicate notification {0}", note);
                return;
            }
            this.queue.add(note);
            this.processQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceExistingNotification(Notification oldNotification, Notification newNotification) {
        Deque<Notification> deque = this.queue;
        synchronized (deque) {
            if (Objects.equals(oldNotification, this.currentNotification)) {
                this.stopHideTimer();
            } else {
                this.queue.remove(oldNotification);
            }
            this.showNotification(newNotification);
            this.processQueue();
        }
    }

    private void processQueue() {
        if (this.running) {
            return;
        }
        this.currentNotification = this.queue.poll();
        if (this.currentNotification == null) {
            return;
        }
        GuiHelper.runInEDTAndWait(() -> {
            this.currentNotificationPanel = new NotificationPanel(this.currentNotification, new FreezeMouseListener(), e -> this.stopHideTimer());
            this.currentNotificationPanel.validate();
            int margin = 5;
            MainFrame parentWindow = MainApplication.getMainFrame();
            Dimension size = this.currentNotificationPanel.getPreferredSize();
            if (parentWindow != null) {
                int y;
                int x;
                MapFrame map = MainApplication.getMap();
                if (MainApplication.isDisplayingMapView() && map.mapView.getHeight() > 0) {
                    MapView mv = map.mapView;
                    Point mapViewPos = SwingUtilities.convertPoint(mv.getParent(), mv.getX(), mv.getY(), MainApplication.getMainFrame());
                    x = mapViewPos.x + margin;
                    y = mapViewPos.y + mv.getHeight() - map.statusLine.getHeight() - size.height - margin;
                } else {
                    x = margin;
                    y = parentWindow.getHeight() - MainApplication.getToolbar().control.getSize().height - size.height - margin;
                }
                parentWindow.getLayeredPane().add(this.currentNotificationPanel, JLayeredPane.POPUP_LAYER, 0);
                this.currentNotificationPanel.setLocation(x, y);
            }
            this.currentNotificationPanel.setSize(size);
            this.currentNotificationPanel.setVisible(true);
        });
        this.running = true;
        this.elapsedTime = 0L;
        this.startHideTimer();
    }

    private void startHideTimer() {
        int remaining = (int)((long)this.currentNotification.getDuration() - this.elapsedTime);
        if (remaining < 300) {
            remaining = 300;
        }
        this.displayTimeStart = System.currentTimeMillis();
        this.hideTimer.setInitialDelay(remaining);
        this.hideTimer.restart();
    }

    private void stopHideTimer() {
        this.hideTimer.stop();
        if (this.currentNotificationPanel != null) {
            this.currentNotificationPanel.setVisible(false);
            MainFrame parent = MainApplication.getMainFrame();
            if (parent != null) {
                parent.getLayeredPane().remove(this.currentNotificationPanel);
            }
            this.currentNotificationPanel = null;
        }
        this.pauseTimer.restart();
    }

    public static synchronized NotificationManager getInstance() {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    static {
        PANEL_SEMITRANSPARENT = new Color(224, 236, 249, 230);
        PANEL_OPAQUE = new Color(224, 236, 249);
    }

    private static class NotificationPanel
    extends JPanel {
        private JPanel innerPanel;

        NotificationPanel(Notification note, MouseListener freeze, ActionListener hideListener) {
            this.setVisible(false);
            this.build(note, freeze, hideListener);
        }

        public void setNotificationBackground(Color c) {
            this.innerPanel.setBackground(c);
        }

        private void build(Notification note, MouseListener freeze, ActionListener hideListener) {
            JButton btnClose = new JButton();
            btnClose.addActionListener(hideListener);
            btnClose.setIcon(ImageProvider.get("misc", "grey_x"));
            btnClose.setPreferredSize(new Dimension(50, 50));
            btnClose.setMargin(new Insets(0, 0, 1, 1));
            btnClose.setContentAreaFilled(false);
            JToolBar tbClose = new JToolBar();
            tbClose.setFloatable(false);
            tbClose.setBorderPainted(false);
            tbClose.setOpaque(false);
            tbClose.add(btnClose);
            JToolBar tbHelp = null;
            if (note.getHelpTopic() != null) {
                JButton btnHelp = new JButton(new ShowNoteHelpAction(note));
                HelpUtil.setHelpContext(btnHelp, note.getHelpTopic());
                btnHelp.setOpaque(false);
                tbHelp = new JToolBar();
                tbHelp.setFloatable(false);
                tbHelp.setBorderPainted(false);
                tbHelp.setOpaque(false);
                tbHelp.add(btnHelp);
            }
            this.setOpaque(false);
            this.innerPanel = new RoundedPanel();
            this.innerPanel.setBackground(PANEL_SEMITRANSPARENT);
            this.innerPanel.setForeground(Color.BLACK);
            GroupLayout layout = new GroupLayout(this.innerPanel);
            this.innerPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            this.innerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(this.innerPanel);
            JLabel icon = null;
            if (note.getIcon() != null) {
                icon = new JLabel(note.getIcon());
            }
            Component content = note.getContent();
            GroupLayout.SequentialGroup hgroup = layout.createSequentialGroup();
            if (icon != null) {
                hgroup.addComponent(icon);
            }
            if (tbHelp != null) {
                hgroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(content).addComponent(tbHelp));
            } else {
                hgroup.addComponent(content);
            }
            hgroup.addComponent(tbClose);
            GroupLayout.ParallelGroup vgroup = layout.createParallelGroup();
            if (icon != null) {
                vgroup.addComponent(icon);
            }
            vgroup.addComponent(content);
            vgroup.addComponent(tbClose);
            layout.setHorizontalGroup(hgroup);
            if (tbHelp != null) {
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(vgroup).addComponent(tbHelp));
            } else {
                layout.setVerticalGroup(vgroup);
            }
            NotificationPanel.addMouseListenerToAllChildComponents(this, freeze);
        }

        private static void addMouseListenerToAllChildComponents(Component comp, MouseListener listener) {
            comp.addMouseListener(listener);
            if (comp instanceof Container) {
                for (Component c : ((Container)comp).getComponents()) {
                    NotificationPanel.addMouseListenerToAllChildComponents(c, listener);
                }
            }
        }

        static final class ShowNoteHelpAction
        extends AbstractAction {
            private final Notification note;

            ShowNoteHelpAction(Notification note) {
                super(I18n.tr("Help", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
                new ImageProvider("help").getResource().attachImageIcon(this, true);
                this.note = note;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> HelpBrowser.setUrlForHelpTopic(this.note.getHelpTopic()));
            }
        }
    }

    private class PauseFinishedEvent
    implements ActionListener {
        private PauseFinishedEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Deque deque = NotificationManager.this.queue;
            synchronized (deque) {
                NotificationManager.this.running = false;
                NotificationManager.this.processQueue();
            }
        }
    }

    private class UnfreezeEvent
    implements ActionListener {
        private UnfreezeEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NotificationManager.this.currentNotificationPanel != null) {
                NotificationManager.this.currentNotificationPanel.setNotificationBackground(PANEL_SEMITRANSPARENT);
                NotificationManager.this.currentNotificationPanel.repaint();
            }
            NotificationManager.this.startHideTimer();
        }
    }

    class FreezeMouseListener
    extends MouseAdapter {
        FreezeMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (NotificationManager.this.unfreezeDelayTimer.isRunning()) {
                NotificationManager.this.unfreezeDelayTimer.stop();
            } else {
                NotificationManager.this.hideTimer.stop();
                NotificationManager.this.elapsedTime += System.currentTimeMillis() - NotificationManager.this.displayTimeStart;
                NotificationManager.this.currentNotificationPanel.setNotificationBackground(PANEL_OPAQUE);
                NotificationManager.this.currentNotificationPanel.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NotificationManager.this.unfreezeDelayTimer.restart();
        }
    }

    public static class RoundedPanel
    extends JPanel {
        RoundedPanel() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getBackground());
            float lineWidth = 1.4f;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double((double)lineWidth / 2.0 + (double)this.getInsets().left, (double)lineWidth / 2.0 + (double)this.getInsets().top, (double)this.getWidth() - (double)lineWidth / 2.0 - (double)this.getInsets().left - (double)this.getInsets().right, (double)this.getHeight() - (double)lineWidth / 2.0 - (double)this.getInsets().top - (double)this.getInsets().bottom, 20.0, 20.0);
            g.fill(rect);
            g.setColor(this.getForeground());
            g.setStroke(new BasicStroke(lineWidth));
            g.draw(rect);
            super.paintComponent(graphics);
        }
    }
}

