/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.StringParser;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private final Map<String, Entry> mapping = new HashMap<String, Entry>();
    private final DefaultHandler parser;
    private final List<Object> queue = new LinkedList<Object>();
    private Iterator<Object> queueIterator;

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    private Iterable<Object> start(Reader in, ContentHandler contentHandler) throws SAXException, IOException {
        try {
            XMLReader reader = XmlUtils.newSafeSAXParser().getXMLReader();
            reader.setContentHandler(contentHandler);
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException e) {
                Logging.log(Logging.LEVEL_ERROR, "Cannot disable 'load-external-dtd' feature:", e);
            }
            reader.parse(new InputSource(in));
            this.queueIterator = this.queue.iterator();
            return this;
        }
        catch (ParserConfigurationException e) {
            throw new JosmRuntimeException(e);
        }
    }

    public Iterable<Object> start(Reader in) throws SAXException {
        try {
            return this.start(in, this.parser);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Iterable<Object> startWithValidation(Reader in, String namespace, String schemaSource) throws SAXException {
        SchemaFactory factory = XmlUtils.newXmlSchemaFactory();
        try (CachedFile cf = new CachedFile(schemaSource);){
            Iterable<Object> iterable;
            block13: {
                InputStream mis = cf.getInputStream();
                try {
                    Schema schema = factory.newSchema(new StreamSource(mis));
                    ValidatorHandler validator = schema.newValidatorHandler();
                    validator.setContentHandler(this.parser);
                    validator.setErrorHandler(this.parser);
                    AddNamespaceFilter filter = new AddNamespaceFilter(namespace);
                    filter.setContentHandler(validator);
                    iterable = this.start(in, filter);
                    if (mis == null) break block13;
                }
                catch (Throwable throwable) {
                    if (mis != null) {
                        try {
                            mis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                mis.close();
            }
            return iterable;
        }
        catch (IOException e) {
            throw new SAXException(I18n.tr("Failed to load XML schema.", new Object[0]), e);
        }
    }

    public void map(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, false));
    }

    public void mapOnStart(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, true, false));
    }

    public void mapBoth(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, true));
    }

    public Object next() {
        return this.queueIterator.next();
    }

    public boolean hasNext() {
        return this.queueIterator.hasNext();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.queue.iterator();
    }

    private class Parser
    extends DefaultHandler {
        private final Stack<Object> current = new Stack();
        private StringBuilder characters = new StringBuilder(64);
        private Locator locator;
        private final StringParser primitiveParsers = ((StringParser)new StringParser(StringParser.DEFAULT).registerParser((Class)Boolean.TYPE, this::parseBoolean)).registerParser(Boolean.class, this::parseBoolean);

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception e) throws XmlParsingException {
            throw new XmlParsingException(e).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String ns, String lname, String qname, Attributes a) throws SAXException {
            Entry entry = (Entry)XmlObjectParser.this.mapping.get(qname);
            if (entry != null) {
                Class klass = entry.klass;
                try {
                    this.current.push(klass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    this.throwException(e);
                }
                for (int i = 0; i < a.getLength(); ++i) {
                    this.setValue(entry, a.getQName(i), a.getValue(i));
                }
                if (entry.onStart) {
                    this.report();
                }
                if (entry.both) {
                    XmlObjectParser.this.queue.add(this.current.peek());
                }
            }
        }

        @Override
        public void endElement(String ns, String lname, String qname) throws SAXException {
            Entry entry = (Entry)XmlObjectParser.this.mapping.get(qname);
            if (entry != null && !entry.onStart) {
                this.report();
            } else if (entry != null && this.characters != null && !this.current.isEmpty()) {
                this.setValue(entry, qname, this.characters.toString().trim());
                this.characters = new StringBuilder(64);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(ch, start, length);
        }

        private void report() {
            XmlObjectParser.this.queue.add(this.current.pop());
            this.characters = new StringBuilder(64);
        }

        private void setValue(Entry entry, String fieldName, String value0) throws SAXException {
            String value = value0 != null ? value0.intern() : null;
            CheckParameterUtil.ensureParameterNotNull(entry, "entry");
            if ("class".equals(fieldName) || "default".equals(fieldName) || "throw".equals(fieldName) || "new".equals(fieldName) || "null".equals(fieldName)) {
                fieldName = fieldName + '_';
            }
            fieldName = fieldName.replace(':', '_');
            try {
                Optional<Object> parsed;
                Object c = this.current.peek();
                Field f = entry.getField(fieldName);
                if (f == null && fieldName.startsWith(lang)) {
                    f = entry.getField("locale_" + fieldName.substring(lang.length()));
                }
                if ((parsed = Optional.ofNullable(f).filter(field -> Modifier.isPublic(field.getModifiers())).flatMap(field -> this.primitiveParsers.tryParse(field.getType(), value))).isPresent()) {
                    f.set(c, parsed.get());
                } else {
                    String setter;
                    if (fieldName.startsWith(lang)) {
                        int l = lang.length();
                        setter = "set" + fieldName.substring(l, l + 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(l + 1);
                    } else {
                        setter = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
                    }
                    Method m = entry.getMethod(setter);
                    if (m != null) {
                        parsed = this.primitiveParsers.tryParse(m.getParameterTypes()[0], value);
                        m.invoke(c, parsed.isPresent() ? parsed.get() : value);
                    }
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                Logging.error(e);
                this.throwException(e);
            }
        }

        private boolean parseBoolean(String s) {
            return s != null && !"0".equals(s) && !s.startsWith("off") && !s.startsWith("false") && !s.startsWith("no");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        AddNamespaceFilter(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("".equals(uri)) {
                super.startElement(this.namespace, localName, qName, atts);
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        }
    }

    private static class Entry {
        private final Class<?> klass;
        private final boolean onStart;
        private final boolean both;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Map<String, Method> methods = new HashMap<String, Method>();
        private Method[] cachedKlassMethods;
        private Field[] cachedKlassFields;

        Entry(Class<?> klass, boolean onStart, boolean both) {
            this.klass = klass;
            this.onStart = onStart;
            this.both = both;
        }

        Field getField(String s) {
            return this.fields.computeIfAbsent(s, this::getUncachedField);
        }

        private Field getUncachedField(String s) {
            if (this.cachedKlassFields == null) {
                this.cachedKlassFields = this.klass.getFields();
            }
            for (Field field : this.cachedKlassFields) {
                if (!field.getName().equals(s)) continue;
                return field;
            }
            return null;
        }

        Method getMethod(String s) {
            return this.methods.computeIfAbsent(s, this::getUncachedMethod);
        }

        private Method getUncachedMethod(String s) {
            if (this.cachedKlassMethods == null) {
                this.cachedKlassMethods = this.klass.getMethods();
            }
            for (Method method : this.cachedKlassMethods) {
                if (method.getParameterCount() != 1 || !method.getName().equals(s)) continue;
                return method;
            }
            return null;
        }
    }
}

