/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.awt.Font;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.spi.preferences.Config;

public final class TableHelper {
    private TableHelper() {
    }

    public static void adaptTo(IEnabledStateUpdating listener, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(e -> listener.updateEnabledState());
    }

    public static void adaptTo(IEnabledStateUpdating listener, AbstractTableModel listModel) {
        listModel.addTableModelListener(e -> listener.updateEnabledState());
    }

    static int getColumnHeaderWidth(JTable tbl, int col) {
        TableColumn tableColumn = tbl.getColumnModel().getColumn(col);
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null && tbl.getTableHeader() != null) {
            renderer = tbl.getTableHeader().getDefaultRenderer();
        }
        if (renderer == null) {
            return 0;
        }
        Component c = renderer.getTableCellRendererComponent(tbl, tableColumn.getHeaderValue(), false, false, -1, col);
        return c.getPreferredSize().width;
    }

    static int getMaxWidth(JTable tbl, int col) {
        int maxwidth = TableHelper.getColumnHeaderWidth(tbl, col);
        for (int row = 0; row < tbl.getRowCount(); ++row) {
            TableCellRenderer tcr = tbl.getCellRenderer(row, col);
            Object val = tbl.getValueAt(row, col);
            Component comp = tcr.getTableCellRendererComponent(tbl, val, false, false, row, col);
            maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
        }
        return maxwidth;
    }

    public static void adjustColumnWidth(JTable tbl, int col, boolean resizable) {
        int maxwidth = TableHelper.getMaxWidth(tbl, col);
        TableColumn column = tbl.getColumnModel().getColumn(col);
        column.setPreferredWidth(maxwidth);
        column.setResizable(resizable);
        if (!resizable) {
            column.setMaxWidth(maxwidth);
        }
    }

    public static void adjustColumnWidth(JTable tbl, int col, int maxColumnWidth) {
        int maxwidth = TableHelper.getMaxWidth(tbl, col);
        tbl.getColumnModel().getColumn(col).setPreferredWidth(Math.min(maxwidth + 10, maxColumnWidth));
    }

    public static void computeColumnsWidth(JTable tbl) {
        for (int column = 0; column < tbl.getColumnCount(); ++column) {
            TableHelper.adjustColumnWidth(tbl, column, Integer.MAX_VALUE);
        }
    }

    @Deprecated(since="19120")
    public static int[] getSelectedIndices(ListSelectionModel selectionModel) {
        return selectionModel.getSelectedIndices();
    }

    public static IntStream selectedIndices(ListSelectionModel selectionModel) {
        if (selectionModel.isSelectionEmpty()) {
            return IntStream.empty();
        }
        return IntStream.rangeClosed(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex()).filter(selectionModel::isSelectedIndex);
    }

    public static void setSelectedIndices(ListSelectionModel selectionModel, IntStream indices) {
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        indices.filter(i -> i >= 0).forEach(i -> selectionModel.addSelectionInterval(i, i));
        selectionModel.setValueIsAdjusting(false);
    }

    public static void setFont(JTable table, Class<? extends Component> parent) {
        double fontFactor = Config.getPref().getDouble("gui.scale.table.font", Config.getPref().getDouble("gui.scale.table." + parent.getSimpleName() + ".font", 1.0));
        if (fontFactor == 1.0) {
            return;
        }
        Font font = table.getFont();
        table.setFont(font.deriveFont((float)((double)font.getSize2D() * fontFactor)));
        table.setRowHeight((int)((double)table.getRowHeight() * fontFactor));
    }
}

