/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Utils;

public class ExtendedSourceEntry
extends SourceEntry
implements Comparable<ExtendedSourceEntry> {
    public String simpleFileName;
    public String version;
    public String author;
    public ImageResource icon;
    public String link;
    public String description;
    public String styleType;
    public Integer minJosmVersion;

    public ExtendedSourceEntry(SourceType type, String simpleFileName, String url) {
        super(type, url, null, null, true);
        this.simpleFileName = simpleFileName;
    }

    public String getDisplayName() {
        return this.title == null ? this.simpleFileName : this.title;
    }

    private static void appendRow(StringBuilder s, String th, String td) {
        s.append("<tr><th>").append(th).append("</th><td>").append(Utils.escapeReservedCharactersHTML(td)).append("</td</tr>");
    }

    public String getTooltip() {
        StringBuilder s = new StringBuilder();
        ExtendedSourceEntry.appendRow(s, I18n.tr("Short Description:", new Object[0]), this.getDisplayName());
        ExtendedSourceEntry.appendRow(s, I18n.tr("URL:", new Object[0]), this.url);
        if (this.author != null) {
            ExtendedSourceEntry.appendRow(s, I18n.tr("Author:", new Object[0]), this.author);
        }
        if (this.link != null) {
            ExtendedSourceEntry.appendRow(s, I18n.tr("Webpage:", new Object[0]), this.link);
        }
        if (this.description != null) {
            ExtendedSourceEntry.appendRow(s, I18n.tr("Description:", new Object[0]), this.description);
        }
        if (this.version != null) {
            ExtendedSourceEntry.appendRow(s, I18n.tr("Version:", new Object[0]), this.version);
        }
        if (this.minJosmVersion != null) {
            ExtendedSourceEntry.appendRow(s, I18n.tr("Minimum JOSM Version:", new Object[0]), Integer.toString(this.minJosmVersion));
        }
        return "<html><style>th{text-align:right}td{width:400px}</style><table>" + String.valueOf(s) + "</table></html>";
    }

    @Override
    public String toString() {
        return "<html><b>" + this.getDisplayName() + "</b>" + (String)(this.author == null ? "" : " <span color=\"gray\">" + I18n.tr("by {0}", this.author) + "</color>") + "</html>";
    }

    @Override
    public int compareTo(ExtendedSourceEntry o) {
        if (this.url.startsWith("resource") && !o.url.startsWith("resource")) {
            return -1;
        }
        if (o.url.startsWith("resource")) {
            return 1;
        }
        return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
    }
}

