/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.SettingVisitor;

public class ListSetting
extends AbstractSetting<List<String>> {
    public ListSetting(List<String> value) {
        super(value);
        this.consistencyTest();
    }

    public static ListSetting create(Collection<String> value) {
        return new ListSetting(value == null ? null : Collections.unmodifiableList(new ArrayList<String>(value)));
    }

    public ListSetting copy() {
        return ListSetting.create((Collection)this.value);
    }

    private void consistencyTest() {
        if (this.value != null && ((List)this.value).contains(null)) {
            throw new IllegalArgumentException("Error: Null as list element in preference setting: " + String.valueOf(this.value));
        }
    }

    @Override
    public void visit(SettingVisitor visitor) {
        visitor.visit(this);
    }

    public ListSetting getNullInstance() {
        return new ListSetting(null);
    }
}

