/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.GeoImageSessionImporter;
import org.openstreetmap.josm.io.session.GpxRoutesSessionImporter;
import org.openstreetmap.josm.io.session.GpxTracksSessionImporter;
import org.openstreetmap.josm.io.session.ImagerySessionImporter;
import org.openstreetmap.josm.io.session.MarkerSessionImporter;
import org.openstreetmap.josm.io.session.NoteSessionImporter;
import org.openstreetmap.josm.io.session.OsmDataSessionImporter;
import org.openstreetmap.josm.io.session.PluginSessionImporter;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader {
    private static final Map<String, Class<? extends SessionLayerImporter>> sessionLayerImporters = new HashMap<String, Class<? extends SessionLayerImporter>>();
    private URI sessionFileURI;
    private boolean zip;
    private boolean pluginData;
    private ZipFile zipFile;
    private List<Layer> layers = new ArrayList<Layer>();
    private int active = -1;
    private final List<Runnable> postLoadTasks = new ArrayList<Runnable>();
    private SessionViewportData viewport;
    private SessionProjectionChoiceData projectionChoice;

    public static void registerSessionLayerImporter(String layerType, Class<? extends SessionLayerImporter> importer) {
        sessionLayerImporters.put(layerType, importer);
    }

    public static SessionLayerImporter getSessionLayerImporter(String layerType) {
        SessionLayerImporter importer;
        Class<? extends SessionLayerImporter> importerClass = sessionLayerImporters.get(layerType);
        if (importerClass == null) {
            return null;
        }
        try {
            importer = importerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new JosmRuntimeException(e);
        }
        return importer;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getActive() {
        return this.active >= 0 && this.active < this.layers.size() ? this.layers.get(this.layers.size() - 1 - this.active) : null;
    }

    public List<Runnable> getPostLoadTasks() {
        return this.postLoadTasks;
    }

    public SessionViewportData getViewport() {
        return this.viewport;
    }

    public SessionProjectionChoiceData getProjectionChoice() {
        return this.projectionChoice;
    }

    public boolean loadedPluginData() {
        return this.pluginData;
    }

    private static void error(String msg) throws IllegalDataException {
        throw new IllegalDataException(msg);
    }

    private void parseJos(Document doc, ProgressMonitor progressMonitor) throws IllegalDataException {
        String version;
        Element root = doc.getDocumentElement();
        if (!"josm-session".equals(root.getTagName())) {
            SessionReader.error(I18n.tr("Unexpected root element ''{0}'' in session file", root.getTagName()));
        }
        if (!"0.1".equals(version = root.getAttribute("version"))) {
            SessionReader.error(I18n.tr("Version ''{0}'' of session file is not supported. Expected: 0.1", version));
        }
        this.viewport = SessionReader.readViewportData(root);
        this.projectionChoice = SessionReader.readProjectionChoiceData(root);
        Element layersEl = SessionReader.getElementByTagName(root, "layers");
        if (layersEl == null) {
            return;
        }
        String activeAtt = layersEl.getAttribute("active");
        try {
            this.active = !activeAtt.isEmpty() ? Integer.parseInt(activeAtt) - 1 : -1;
        }
        catch (NumberFormatException e) {
            Logging.warn("Unsupported value for 'active' layer attribute. Ignoring it. Error was: " + e.getMessage());
            this.active = -1;
        }
        MultiMap<Integer, Integer> deps = new MultiMap<Integer, Integer>();
        HashMap<Integer, Element> elems = new HashMap<Integer, Element>();
        NodeList nodes = layersEl.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !"layer".equals((e = (Element)node).getTagName())) continue;
            if (!e.hasAttribute("index")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''index'' for element ''layer''", new Object[0]));
            }
            Integer idx = null;
            try {
                idx = Integer.valueOf(e.getAttribute("index"));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.warn(numberFormatException);
            }
            if (idx == null) {
                SessionReader.error(I18n.tr("unexpected format of attribute ''index'' for element ''layer''", new Object[0]));
            } else if (elems.containsKey(idx)) {
                SessionReader.error(I18n.tr("attribute ''index'' ({0}) for element ''layer'' must be unique", Integer.toString(idx)));
            }
            elems.put(idx, e);
            deps.putVoid(idx);
            String string = e.getAttribute("depends");
            if (string.isEmpty()) continue;
            for (String sd : string.split(",", -1)) {
                Integer d = null;
                try {
                    d = Integer.valueOf(sd);
                }
                catch (NumberFormatException ex) {
                    Logging.warn(ex);
                }
                if (d == null) continue;
                deps.put(idx, d);
            }
        }
        List sorted = Utils.topologicalSort(deps);
        TreeMap layersMap = new TreeMap(Collections.reverseOrder());
        HashMap<Integer, SessionLayerImporter> importers = new HashMap<Integer, SessionLayerImporter>();
        progressMonitor.setTicksCount(sorted.size());
        Iterator<Object> iterator = sorted.iterator();
        block10: while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Element e = (Element)elems.get(n);
            if (e == null) {
                SessionReader.error(I18n.tr("missing layer with index {0}", n));
                return;
            }
            if (!e.hasAttribute("name")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''name'' for element ''layer''", new Object[0]));
                return;
            }
            String name = e.getAttribute("name");
            if (!e.hasAttribute("type")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''type'' for element ''layer''", new Object[0]));
                return;
            }
            String type = e.getAttribute("type");
            SessionLayerImporter imp = SessionReader.getSessionLayerImporter(type);
            if (imp == null && !GraphicsEnvironment.isHeadless()) {
                CancelOrContinueDialog dialog = new CancelOrContinueDialog();
                dialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer of type ''{0}'' because no suitable importer was found.", type), 2);
                if (!dialog.isCancel()) continue;
                progressMonitor.cancel();
                return;
            }
            if (imp != null) {
                CancelOrContinueDialog dialog;
                importers.put(n, imp);
                ArrayList<LayerDependency> depsImp = new ArrayList<LayerDependency>();
                Iterator ex = deps.get(n).iterator();
                while (ex.hasNext()) {
                    int d = (Integer)ex.next();
                    SessionLayerImporter dImp = (SessionLayerImporter)importers.get(d);
                    if (dImp == null) {
                        dialog = new CancelOrContinueDialog();
                        dialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer {0} because it depends on layer {1} which has been skipped.", n, d), 2);
                        if (!dialog.isCancel()) continue block10;
                        progressMonitor.cancel();
                        return;
                    }
                    depsImp.add(new LayerDependency(d, (Layer)layersMap.get(d), dImp));
                }
                ImportSupport support = new ImportSupport(name, n, depsImp);
                Layer layer = null;
                Exception exception = null;
                try {
                    layer = imp.load(e, support, progressMonitor.createSubTaskMonitor(1, false));
                    if (layer == null) {
                        throw new IllegalStateException("Importer " + String.valueOf(imp) + " returned null for " + String.valueOf(support));
                    }
                }
                catch (IOException | IllegalArgumentException | IllegalStateException | IllegalDataException ex2) {
                    exception = ex2;
                }
                if (exception != null) {
                    Logging.error(exception);
                    if (!GraphicsEnvironment.isHeadless()) {
                        dialog = new CancelOrContinueDialog();
                        dialog.show(I18n.tr("Error loading layer", new Object[0]), I18n.tr("<html>Could not load layer {0} ''{1}''.<br>Error is:<br>{2}</html>", n, Utils.escapeReservedCharactersHTML(name), Utils.escapeReservedCharactersHTML(exception.getMessage())), 0);
                        if (!dialog.isCancel()) continue;
                        progressMonitor.cancel();
                        return;
                    }
                }
                layersMap.put(n, layer);
                SessionReader.setLayerAttributes(layer, e);
                if (support.getSubLayers() != null) {
                    support.getSubLayers().forEach((markerIndex, entry) -> {
                        Layer subLayer = (Layer)entry.getKey();
                        Element subElement = (Element)entry.getValue();
                        layersMap.put(markerIndex, subLayer);
                        SessionReader.setLayerAttributes(subLayer, subElement);
                    });
                }
            }
            if (progressMonitor.isCanceled()) {
                return;
            }
            progressMonitor.worked(1);
        }
        this.layers = new ArrayList<Layer>();
        for (Map.Entry entry2 : layersMap.entrySet()) {
            Layer layer = (Layer)entry2.getValue();
            if (layer == null) continue;
            this.layers.add(layer);
        }
    }

    private static void setLayerAttributes(Layer layer, Element e) {
        if (layer == null) {
            return;
        }
        if (e.hasAttribute("name")) {
            layer.setName(e.getAttribute("name"));
        }
        if (e.hasAttribute("visible")) {
            layer.setVisible(Boolean.parseBoolean(e.getAttribute("visible")));
        }
        if (e.hasAttribute("opacity")) {
            try {
                double opacity = Double.parseDouble(e.getAttribute("opacity"));
                layer.setOpacity(opacity);
            }
            catch (NumberFormatException ex) {
                Logging.warn(ex);
            }
        }
    }

    private static SessionViewportData readViewportData(Element root) {
        Element viewportEl = SessionReader.getElementByTagName(root, "viewport");
        if (viewportEl == null) {
            return null;
        }
        LatLon center = null;
        Element centerEl = SessionReader.getElementByTagName(viewportEl, "center");
        if (centerEl == null || !centerEl.hasAttribute("lat") || !centerEl.hasAttribute("lon")) {
            return null;
        }
        try {
            center = new LatLon(Double.parseDouble(centerEl.getAttribute("lat")), Double.parseDouble(centerEl.getAttribute("lon")));
        }
        catch (NumberFormatException ex) {
            Logging.warn(ex);
        }
        if (center == null) {
            return null;
        }
        Element scaleEl = SessionReader.getElementByTagName(viewportEl, "scale");
        if (scaleEl == null || !scaleEl.hasAttribute("meter-per-pixel")) {
            return null;
        }
        try {
            double scale = Double.parseDouble(scaleEl.getAttribute("meter-per-pixel"));
            return new SessionViewportData(center, scale);
        }
        catch (NumberFormatException ex) {
            Logging.warn(ex);
            return null;
        }
    }

    private static SessionProjectionChoiceData readProjectionChoiceData(Element root) {
        Element projectionEl = SessionReader.getElementByTagName(root, "projection");
        if (projectionEl == null) {
            return null;
        }
        Element projectionChoiceEl = SessionReader.getElementByTagName(projectionEl, "projection-choice");
        if (projectionChoiceEl == null) {
            return null;
        }
        Element idEl = SessionReader.getElementByTagName(projectionChoiceEl, "id");
        if (idEl == null) {
            return null;
        }
        String id = idEl.getTextContent();
        Element parametersEl = SessionReader.getElementByTagName(projectionChoiceEl, "parameters");
        if (parametersEl == null) {
            return null;
        }
        NodeList paramNl = parametersEl.getElementsByTagName("param");
        int length = paramNl.getLength();
        Collection parameters = IntStream.range(0, length).mapToObj(i -> (Element)paramNl.item(i)).map(Node::getTextContent).collect(Collectors.toList());
        return new SessionProjectionChoiceData(id, parameters);
    }

    private void loadPluginData() {
        if (!this.zip) {
            return;
        }
        for (PluginSessionImporter importer : PluginHandler.load(PluginSessionImporter.class)) {
            try {
                this.pluginData |= importer.readZipFile(this.zipFile);
            }
            catch (IOException ioException) {
                GuiHelper.runInEDT(() -> ExceptionDialogUtil.explainException(ioException));
            }
        }
    }

    public void loadSession(File sessionFile, boolean zip, ProgressMonitor progressMonitor) throws IllegalDataException, IOException {
        try (InputStream josIS = this.createInputStream(sessionFile, zip);){
            this.loadSession(josIS, sessionFile.toURI(), zip, progressMonitor);
            this.postLoadTasks.add(this::loadPluginData);
        }
    }

    private InputStream createInputStream(File sessionFile, boolean zip) throws IOException, IllegalDataException {
        if (zip) {
            try {
                this.zipFile = new ZipFile(sessionFile, StandardCharsets.UTF_8);
                return SessionReader.getZipInputStream(this.zipFile);
            }
            catch (ZipException ex) {
                throw new IOException(ex);
            }
        }
        return Files.newInputStream(sessionFile.toPath(), new OpenOption[0]);
    }

    private static InputStream getZipInputStream(ZipFile zipFile) throws IOException, IllegalDataException {
        ZipEntry josEntry = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!Utils.hasExtension(entry.getName(), "jos")) continue;
            josEntry = entry;
            break;
        }
        if (josEntry == null) {
            SessionReader.error(I18n.tr("expected .jos file inside .joz archive", new Object[0]));
        }
        return zipFile.getInputStream(josEntry);
    }

    public void loadSession(InputStream josIS, URI sessionFileURI, boolean zip, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        this.sessionFileURI = sessionFileURI;
        this.zip = zip;
        try {
            this.parseJos(XmlUtils.parseSafeDOM(josIS), progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE);
        }
        catch (SAXException e) {
            throw new IllegalDataException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private static Element getElementByTagName(Element root, String name) {
        NodeList els = root.getElementsByTagName(name);
        return els.getLength() > 0 ? (Element)els.item(0) : null;
    }

    static {
        SessionReader.registerSessionLayerImporter("osm-data", OsmDataSessionImporter.class);
        SessionReader.registerSessionLayerImporter("imagery", ImagerySessionImporter.class);
        SessionReader.registerSessionLayerImporter("tracks", GpxTracksSessionImporter.class);
        SessionReader.registerSessionLayerImporter("routes", GpxRoutesSessionImporter.class);
        SessionReader.registerSessionLayerImporter("geoimage", GeoImageSessionImporter.class);
        SessionReader.registerSessionLayerImporter("markers", MarkerSessionImporter.class);
        SessionReader.registerSessionLayerImporter("osm-notes", NoteSessionImporter.class);
    }

    public static class SessionViewportData {
        private final LatLon center;
        private final double meterPerPixel;

        public SessionViewportData(LatLon center, double meterPerPixel) {
            CheckParameterUtil.ensureParameterNotNull(center);
            this.center = center;
            this.meterPerPixel = meterPerPixel;
        }

        public LatLon getCenter() {
            return this.center;
        }

        public double getScale() {
            return this.meterPerPixel;
        }

        public ViewportData getEastNorthViewport(Projection proj) {
            EastNorth centerEN = proj.latlon2eastNorth(this.center);
            double dist = 0.01 * proj.getDefaultZoomInPPD();
            LatLon ll1 = proj.eastNorth2latlon(new EastNorth(centerEN.east() - dist, centerEN.north()));
            LatLon ll2 = proj.eastNorth2latlon(new EastNorth(centerEN.east() + dist, centerEN.north()));
            double meterPerEasting = ll1.greatCircleDistance(ll2) / dist / 2.0;
            double scale = this.meterPerPixel / meterPerEasting;
            return new ViewportData(centerEN, scale);
        }
    }

    public static class SessionProjectionChoiceData {
        private final String projectionChoiceId;
        private final Collection<String> subPreferences;

        public SessionProjectionChoiceData(String projectionChoiceId, Collection<String> subPreferences) {
            this.projectionChoiceId = projectionChoiceId;
            this.subPreferences = subPreferences;
        }

        public String getProjectionChoiceId() {
            return this.projectionChoiceId;
        }

        public Collection<String> getSubPreferences() {
            return this.subPreferences;
        }
    }

    private static final class CancelOrContinueDialog {
        private boolean cancel;

        private CancelOrContinueDialog() {
        }

        void show(String title, String message, int icon) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    ExtendedDialog dlg = new ExtendedDialog((Component)MainApplication.getMainFrame(), title, I18n.tr("Cancel", new Object[0]), I18n.tr("Skip layer and continue", new Object[0])).setButtonIcons("cancel", "dialogs/next").setIcon(icon).setContent(message);
                    this.cancel = dlg.showDialog().getValue() != 2;
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                throw new JosmRuntimeException(ex);
            }
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    public static class LayerDependency {
        private final Integer index;
        private final Layer layer;
        private final SessionLayerImporter importer;

        public LayerDependency(Integer index, Layer layer, SessionLayerImporter importer) {
            this.index = index;
            this.layer = layer;
            this.importer = importer;
        }

        public SessionLayerImporter getImporter() {
            return this.importer;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Layer getLayer() {
            return this.layer;
        }
    }

    public class ImportSupport {
        private final String layerName;
        private final int layerIndex;
        private final List<LayerDependency> layerDependencies;
        private Map<Integer, Map.Entry<Layer, Element>> subLayers;
        private String inZipPath;

        public ImportSupport(String layerName, int layerIndex, List<LayerDependency> layerDependencies) {
            this.layerName = layerName;
            this.layerIndex = layerIndex;
            this.layerDependencies = layerDependencies;
        }

        public void addPostLayersTask(Runnable task) {
            SessionReader.this.postLoadTasks.add(task);
        }

        public void addSubLayer(int idx, Layer layer, Element el) {
            if (this.subLayers == null) {
                this.subLayers = new HashMap<Integer, Map.Entry<Layer, Element>>();
            }
            this.subLayers.put(idx, new AbstractMap.SimpleEntry<Layer, Element>(layer, el));
        }

        public Map<Integer, Map.Entry<Layer, Element>> getSubLayers() {
            return this.subLayers;
        }

        public InputStream getInputStream(String uriStr) throws IOException {
            ZipEntry entry;
            File file = this.getFile(uriStr);
            if (file != null) {
                try {
                    return new BufferedInputStream(Compression.getUncompressedFileInputStream(file));
                }
                catch (FileNotFoundException e) {
                    throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getPath()), e);
                }
            }
            if (this.inZipPath != null && (entry = SessionReader.this.zipFile.getEntry(this.inZipPath)) != null) {
                return SessionReader.this.zipFile.getInputStream(entry);
            }
            throw new IOException(I18n.tr("Unable to locate file  ''{0}''.", uriStr));
        }

        public File getFile(String uriStr) throws IOException {
            this.inZipPath = null;
            try {
                URI uri = new URI(uriStr);
                if ("file".equals(uri.getScheme())) {
                    return new File(uri);
                }
                if (uri.getScheme() == null) {
                    File file = new File(uriStr);
                    if (file.isAbsolute()) {
                        return file;
                    }
                    if (this.isZip()) {
                        if (uri.getPath().startsWith("../")) {
                            String relPath = uri.getPath().substring(3);
                            return new File(SessionReader.this.sessionFileURI.resolve(relPath));
                        }
                        this.inZipPath = uriStr;
                        return null;
                    }
                    return new File(SessionReader.this.sessionFileURI.resolve(uri));
                }
                throw new IOException(I18n.tr("Unsupported scheme ''{0}'' in URI ''{1}''.", uri.getScheme(), uriStr));
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public boolean isZip() {
            return SessionReader.this.zip;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public List<LayerDependency> getLayerDependencies() {
            return this.layerDependencies;
        }

        public String toString() {
            return "ImportSupport [layerName=" + this.layerName + ", layerIndex=" + this.layerIndex + ", layerDependencies=" + String.valueOf(this.layerDependencies) + ", inZipPath=" + this.inZipPath + "]";
        }
    }
}

