/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.I18n;
import org.jetbrains.annotations.NotNull;

public class YearRange
extends Element {
    public static final int FIRST_VALID_YEAR = 1900;
    public static final int UNDEFINED_YEAR = Integer.MIN_VALUE;
    int startYear = Integer.MIN_VALUE;
    int endYear = Integer.MIN_VALUE;
    int interval = 0;

    public YearRange() {
    }

    public YearRange(@NotNull YearRange yr) {
        this.startYear = yr.startYear;
        this.endYear = yr.endYear;
        this.interval = yr.interval;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(String.format("%04d", this.startYear));
        if (this.endYear != Integer.MIN_VALUE) {
            b.append("-");
            b.append(String.format("%04d", this.endYear));
            if (this.interval > 0) {
                b.append("/");
                b.append(this.interval);
            }
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof YearRange) {
            YearRange o = (YearRange)other;
            if (this.startYear == o.startYear && this.endYear == o.endYear && this.interval == o.interval) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + this.startYear;
        result = 37 * result + this.endYear;
        result = 37 * result + this.interval;
        return result;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setStartYear(int start) {
        if (start != Integer.MIN_VALUE && start < 1900) {
            throw new IllegalArgumentException(I18n.tr("invalid_year_number", Integer.toString(start)));
        }
        this.startYear = start;
    }

    public void setEndYear(int end) {
        if (end != Integer.MIN_VALUE && end < 1900) {
            throw new IllegalArgumentException(I18n.tr("invalid_year_number", Integer.toString(end)));
        }
        this.endYear = end;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public YearRange copy() {
        return new YearRange(this);
    }
}

