/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.discovery.DiscoveredService;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoveryReceiver
implements Runnable,
IShutdownObserver {
    private static final Log log = LogFactory.getLog(UDPDiscoveryReceiver.class);
    private final byte[] mBuffer = new byte[65536];
    private MulticastSocket mSocket;
    private static final int maxPoolSize = 2;
    private final ExecutorService pooledExecutor;
    private AtomicInteger cnt = new AtomicInteger(0);
    private final UDPDiscoveryService service;
    private final String multicastAddressString;
    private final int multicastPort;
    private boolean shutdown = false;

    public UDPDiscoveryReceiver(UDPDiscoveryService service, String multicastAddressString, int multicastPort) throws IOException {
        this.service = service;
        this.multicastAddressString = multicastAddressString;
        this.multicastPort = multicastPort;
        this.pooledExecutor = ThreadPoolManager.getInstance().createPool(new PoolConfiguration(false, 0, 2, 2, 0, PoolConfiguration.WhenBlockedPolicy.DISCARDOLDEST, 2), "JCS-UDPDiscoveryReceiver-", 1);
        if (log.isInfoEnabled()) {
            log.info("Constructing listener, [" + this.multicastAddressString + ":" + this.multicastPort + "]");
        }
        this.createSocket(this.multicastAddressString, this.multicastPort);
    }

    private void createSocket(String multicastAddressString, int multicastPort) throws IOException {
        try {
            this.mSocket = new MulticastSocket(multicastPort);
            if (log.isInfoEnabled()) {
                log.info("Joining Group: [" + InetAddress.getByName(multicastAddressString) + "]");
            }
            this.mSocket.joinGroup(InetAddress.getByName(multicastAddressString));
        }
        catch (IOException e) {
            log.error("Could not bind to multicast address [" + InetAddress.getByName(multicastAddressString) + ":" + multicastPort + "]", e);
            throw e;
        }
    }

    public Object waitForMessage() throws IOException {
        DatagramPacket packet = new DatagramPacket(this.mBuffer, this.mBuffer.length);
        Object obj = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Waiting for message.");
            }
            this.mSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug("Received packet from address [" + packet.getSocketAddress() + "]");
            }
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(this.mBuffer, 0, packet.getLength());
                 ObjectInputStreamClassLoaderAware objectStream = new ObjectInputStreamClassLoaderAware(byteStream, null);){
                obj = objectStream.readObject();
            }
            if (obj instanceof UDPDiscoveryMessage) {
                UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
                msg.setHost(packet.getAddress().getHostAddress());
                if (log.isDebugEnabled()) {
                    log.debug("Read object from address [" + packet.getSocketAddress() + "], object=[" + obj + "]");
                }
            }
        }
        catch (Exception e) {
            log.error("Error receiving multicast packet", e);
        }
        return obj;
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (!this.shutdown) {
                    Object obj = this.waitForMessage();
                    this.cnt.incrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug(this.getCnt() + " messages received.");
                    }
                    UDPDiscoveryMessage message = null;
                    try {
                        message = (UDPDiscoveryMessage)obj;
                        if (message != null) {
                            MessageHandler handler = new MessageHandler(message);
                            this.pooledExecutor.execute(handler);
                            if (!log.isDebugEnabled()) continue block6;
                            log.debug("Passed handler to executor.");
                            continue block6;
                        }
                        log.warn("message is null");
                        continue block6;
                    }
                    catch (ClassCastException cce) {
                        log.warn("Received unknown message type " + cce.getMessage());
                    }
                }
                break;
            }
            catch (Exception e) {
                log.error("Unexpected exception in UDP receiver.", e);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (Exception e2) {
                    log.error("Problem sleeping", e2);
                    break;
                }
            }
        }
    }

    public void setCnt(int cnt) {
        this.cnt.set(cnt);
    }

    public int getCnt() {
        return this.cnt.get();
    }

    @Override
    public void shutdown() {
        try {
            this.shutdown = true;
            this.mSocket.leaveGroup(InetAddress.getByName(this.multicastAddressString));
            this.mSocket.close();
            this.pooledExecutor.shutdownNow();
        }
        catch (IOException e) {
            log.error("Problem closing socket");
        }
    }

    public class MessageHandler
    implements Runnable {
        private UDPDiscoveryMessage message = null;

        public MessageHandler(UDPDiscoveryMessage message) {
            this.message = message;
        }

        @Override
        public void run() {
            if (this.message.getRequesterId() == CacheInfo.listenerId) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring message sent from self");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Process message sent from another");
                    log.debug("Message = " + this.message);
                }
                if (this.message.getHost() == null || this.message.getCacheNames() == null || this.message.getCacheNames().isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring invalid message: " + this.message);
                    }
                } else {
                    this.processMessage();
                }
            }
        }

        private void processMessage() {
            DiscoveredService discoveredService = new DiscoveredService();
            discoveredService.setServiceAddress(this.message.getHost());
            discoveredService.setCacheNames(this.message.getCacheNames());
            discoveredService.setServicePort(this.message.getPort());
            discoveredService.setLastHearFromTime(System.currentTimeMillis());
            if (this.message.getMessageType() == UDPDiscoveryMessage.BroadcastType.REQUEST) {
                if (log.isDebugEnabled()) {
                    log.debug("Message is a Request Broadcast, will have the service handle it.");
                }
                UDPDiscoveryReceiver.this.service.serviceRequestBroadcast();
                return;
            }
            if (this.message.getMessageType() == UDPDiscoveryMessage.BroadcastType.REMOVE) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing service from set " + discoveredService);
                }
                UDPDiscoveryReceiver.this.service.removeDiscoveredService(discoveredService);
            } else {
                UDPDiscoveryReceiver.this.service.addOrUpdateService(discoveredService);
            }
        }
    }
}

