/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.MapPaintDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.util.StayOpenCheckBoxMenuItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapPaintMenu
extends JMenu
implements MapPaintStyles.MapPaintSylesUpdateListener {
    private final transient Map<String, MapPaintAction> actions = new HashMap<String, MapPaintAction>();

    public MapPaintMenu() {
        super(I18n.tr("Map Paint Styles", new Object[0]));
        this.setIcon(ImageProvider.get("dialogs", "mapstyle", ImageProvider.ImageSizes.MENU));
        MapPaintStyles.addMapPaintSylesUpdateListener(this);
        this.putClientProperty("help", HelpUtil.ht("/Dialog/MapPaint"));
    }

    @Override
    public void mapPaintStylesUpdated() {
        this.removeAll();
        for (StyleSource style : MapPaintStyles.getStyles().getStyleSources()) {
            String k = style.getDisplayString();
            MapPaintAction a = this.actions.get(k);
            if (a == null) {
                a = new MapPaintAction(style);
                this.actions.put(k, a);
                this.add(a.getButton());
                continue;
            }
            a.setStyle(style);
            this.add(a.getButton());
            a.updateButton();
        }
        this.addSeparator();
        this.add(MapPaintDialog.PREFERENCE_ACTION);
    }

    @Override
    public void mapPaintStyleEntryUpdated(int idx) {
        this.mapPaintStylesUpdated();
    }

    private static class MapPaintAction
    extends JosmAction {
        private transient StyleSource style;
        private final JCheckBoxMenuItem button = new StayOpenCheckBoxMenuItem(this);

        MapPaintAction(StyleSource style) {
            super(style.getDisplayString(), style.getIconProvider(), I18n.tr("Select the map painting styles", new Object[0]), null, true, "mappaint/" + style.getDisplayString(), true);
            this.style = style;
            this.updateButton();
            this.putValue("help", HelpUtil.ht("/Dialog/MapPaint"));
        }

        private void updateButton() {
            this.button.getModel().setSelected(this.style.active);
        }

        private void toggleStyle() {
            MapPaintStyles.toggleStyleActive(MapPaintStyles.getStyles().getStyleSources().indexOf(this.style));
            this.updateButton();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.toggleStyle();
        }

        public JCheckBoxMenuItem getButton() {
            return this.button;
        }

        public void setStyle(StyleSource style) {
            this.style = style;
        }

        @Override
        protected boolean listenToSelectionChange() {
            return false;
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(MainApplication.isDisplayingMapView() && (MainApplication.getLayerManager().getActiveData() != null || MapPaintAction.mapHasGpxOrMarkerLayer()));
        }

        private static boolean mapHasGpxOrMarkerLayer() {
            return MainApplication.getLayerManager().getLayers().stream().anyMatch(layer -> layer instanceof GpxLayer || layer instanceof MarkerLayer);
        }
    }
}

