/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import javax.swing.ListSelectionModel;
import org.openstreetmap.josm.data.ReorderableModel;
import org.openstreetmap.josm.gui.util.TableHelper;

public interface ReorderableTableModel<T>
extends ReorderableModel<T> {
    public ListSelectionModel getSelectionModel();

    public int getRowCount();

    default public int[] getSelectedIndices() {
        return TableHelper.getSelectedIndices(this.getSelectionModel());
    }

    default public boolean canMove(int delta) {
        return this.canMove(delta, this::getRowCount, this.getSelectedIndices());
    }

    default public boolean canMoveUp() {
        return this.canMoveUp(this.getSelectedIndices());
    }

    default public boolean canMoveUp(int ... rows) {
        return this.canMoveUp(this::getRowCount, rows);
    }

    default public boolean canMoveDown() {
        return this.canMoveDown(this.getSelectedIndices());
    }

    default public boolean canMoveDown(int ... rows) {
        return this.canMoveDown(this::getRowCount, rows);
    }

    default public boolean moveUp() {
        return this.moveUp(this.getSelectedIndices());
    }

    default public boolean moveUp(int ... selectedRows) {
        return this.move(-1, selectedRows);
    }

    default public boolean moveDown() {
        return this.moveDown(this.getSelectedIndices());
    }

    default public boolean moveDown(int ... selectedRows) {
        return this.move(1, selectedRows);
    }

    default public boolean move(int delta, int ... selectedRows) {
        if (!this.canMove(delta, this::getRowCount, selectedRows)) {
            return false;
        }
        if (!this.doMove(delta, selectedRows)) {
            return false;
        }
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (int row : selectedRows) {
            selectionModel.addSelectionInterval(row + delta, row + delta);
        }
        selectionModel.setValueIsAdjusting(false);
        return true;
    }
}

