/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class ConditionalKeys
extends Test.TagTest {
    private final OpeningHourTest openingHourTest = new OpeningHourTest();
    private static final Set<String> RESTRICTION_TYPES = new HashSet<String>(Arrays.asList("oneway", "toll", "noexit", "maxspeed", "minspeed", "maxstay", "maxweight", "maxaxleload", "maxheight", "maxwidth", "maxlength", "overtaking", "maxgcweight", "maxgcweightrating", "fee", "restriction", "interval", "duration"));
    private static final Set<String> RESTRICTION_VALUES = new HashSet<String>(Arrays.asList("yes", "official", "designated", "destination", "delivery", "customers", "permissive", "private", "agricultural", "forestry", "no"));
    private static final Set<String> TRANSPORT_MODES = new HashSet<String>(Arrays.asList("access", "foot", "ski", "inline_skates", "ice_skates", "horse", "vehicle", "bicycle", "carriage", "trailer", "caravan", "motor_vehicle", "motorcycle", "moped", "mofa", "motorcar", "motorhome", "psv", "bus", "taxi", "tourist_bus", "goods", "hgv", "agricultural", "atv", "snowmobile", "hgv_articulated", "ski:nordic", "ski:alpine", "ski:telemark", "coach", "golf_cart"));
    private static final Pattern CONDITIONAL_PATTERN;

    public ConditionalKeys() {
        super(I18n.tr("Conditional Keys", new Object[0]), I18n.tr("Tests for the correct usage of ''*:conditional'' tags.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.openingHourTest.initialize();
    }

    public static boolean isRestrictionType(String part) {
        return RESTRICTION_TYPES.contains(part);
    }

    public static boolean isRestrictionValue(String part) {
        return RESTRICTION_VALUES.contains(part);
    }

    public static boolean isTransportationMode(String part) {
        return TRANSPORT_MODES.contains(part);
    }

    public static boolean isDirection(String part) {
        return "forward".equals(part) || "backward".equals(part);
    }

    public boolean isKeyValid(String key) {
        if (!key.endsWith(":conditional")) {
            return false;
        }
        String[] parts = key.replace(":conditional", "").split(":", -1);
        return ConditionalKeys.isKeyValid3Parts(parts) || ConditionalKeys.isKeyValid1Part(parts) || ConditionalKeys.isKeyValid2Parts(parts);
    }

    private static boolean isKeyValid3Parts(String ... parts) {
        return parts.length == 3 && ConditionalKeys.isRestrictionType(parts[0]) && ConditionalKeys.isTransportationMode(parts[1]) && ConditionalKeys.isDirection(parts[2]);
    }

    private static boolean isKeyValid2Parts(String ... parts) {
        return parts.length == 2 && (ConditionalKeys.isRestrictionType(parts[0]) && (ConditionalKeys.isTransportationMode(parts[1]) || ConditionalKeys.isDirection(parts[1])) || ConditionalKeys.isTransportationMode(parts[0]) && ConditionalKeys.isDirection(parts[1]));
    }

    private static boolean isKeyValid1Part(String ... parts) {
        return parts.length == 1 && (ConditionalKeys.isRestrictionType(parts[0]) || ConditionalKeys.isTransportationMode(parts[0]));
    }

    public boolean isValueValid(String key, String value) {
        return this.validateValue(key, value) == null;
    }

    public String validateValue(String key, String value) {
        try {
            for (ConditionalValue conditional : ConditionalValue.parse(value)) {
                if (ConditionalKeys.isTransportationMode(key.split(":", -1)[0]) && !ConditionalKeys.isRestrictionValue(conditional.restrictionValue)) {
                    return I18n.tr("{0} is not a valid restriction value", conditional.restrictionValue);
                }
                for (String condition : conditional.conditions) {
                    List<TestError> errors;
                    if (!condition.matches(".*[0-9]:[0-9]{2}.*") || (errors = this.openingHourTest.checkOpeningHourSyntax("", condition)).isEmpty()) continue;
                    return errors.get(0).getDescription();
                }
            }
        }
        catch (ConditionalParsingException ex) {
            Logging.debug(ex);
            return ex.getMessage();
        }
        return null;
    }

    public List<TestError> validatePrimitive(OsmPrimitive p) {
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (String key : SubclassFilteredCollection.filter(p.keySet(), Pattern.compile(":conditional(:.*)?$").asPredicate())) {
            if (!this.isKeyValid(key)) {
                errors.add(TestError.builder(this, Severity.WARNING, 3201).message(I18n.tr("Wrong syntax in {0} key", key)).primitives(p).build());
                continue;
            }
            String value = p.get(key);
            String error = this.validateValue(key, value);
            if (error == null) continue;
            errors.add(TestError.builder(this, Severity.WARNING, 3202).message(I18n.tr("Error in {0} value: {1}", key, error)).primitives(p).build());
        }
        return errors;
    }

    @Override
    public void check(OsmPrimitive p) {
        if (p.isTagged()) {
            this.errors.addAll(this.validatePrimitive(p));
        }
    }

    static {
        String part = Pattern.compile("([^@\\p{Space}][^@]*?)\\s*@\\s*(\\([^)\\p{Space}][^)]+?\\)|[^();\\p{Space}][^();]*?)\\s*").toString();
        CONDITIONAL_PATTERN = Pattern.compile('(' + part + ")(;\\s*" + part + ")*");
    }

    public static class ConditionalValue {
        public final String restrictionValue;
        public final Collection<String> conditions;

        public ConditionalValue(String restrictionValue, Collection<String> conditions) {
            this.restrictionValue = restrictionValue;
            this.conditions = conditions;
        }

        public static List<ConditionalValue> parse(String value) {
            ArrayList<ConditionalValue> r = new ArrayList<ConditionalValue>();
            Matcher m = CONDITIONAL_PATTERN.matcher(value);
            if (!m.matches()) {
                throw new ConditionalParsingException(I18n.tr("Does not match pattern ''restriction value @ condition''", new Object[0]));
            }
            int i = 2;
            while (i + 1 <= m.groupCount() && m.group(i + 1) != null) {
                String restrictionValue = m.group(i);
                String[] conditions = m.group(i + 1).replace("(", "").replace(")", "").split("\\s+(AND|and)\\s+", -1);
                r.add(new ConditionalValue(restrictionValue, Arrays.asList(conditions)));
                i += 3;
            }
            return r;
        }
    }

    static class ConditionalParsingException
    extends RuntimeException {
        ConditionalParsingException(String message) {
            super(message);
        }
    }
}

