/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadFromOverpassTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private final String request;
    private final DataSet ds;
    private Exception lastException;

    public DownloadFromOverpassTask(String request, DataSet ds, ProgressMonitor monitor) {
        super(I18n.tr("Download objects via Overpass API", new Object[0]), monitor, false);
        this.request = request;
        this.ds = ds;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            OverpassDownloadReader reader = new OverpassDownloadReader(new Bounds(0.0, 0.0, 0.0, 0.0), OverpassDownloadReader.OVERPASS_SERVER.get(), this.request);
            DataSet tmpDs = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
            if (!this.canceled) {
                new DataSetMerger(this.ds, tmpDs).merge();
            }
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }
}

