/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpClient connection;
    private List<PluginInformation> availablePlugins;
    private boolean displayErrMsg;

    protected final void init(Collection<String> sites, boolean displayErrMsg) {
        this.sites = Optional.ofNullable(sites).orElseGet(Collections::emptySet);
        this.availablePlugins = new LinkedList<PluginInformation>();
        this.displayErrMsg = displayErrMsg;
    }

    public ReadRemotePluginInformationTask(Collection<String> sites) {
        super(I18n.tr("Download plugin list...", new Object[0]), false);
        this.init(sites, true);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor monitor, Collection<String> sites, boolean displayErrMsg) {
        super(I18n.tr("Download plugin list...", new Object[0]), monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        this.init(sites, displayErrMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File pluginDir, String site) {
        String name;
        try {
            site = site.replaceAll("%<(.*)>", "");
            URL url = new URL(site);
            StringBuilder sb = new StringBuilder();
            sb.append("site-").append(url.getHost()).append('-');
            if (url.getPort() != -1) {
                sb.append(url.getPort()).append('-');
            }
            String path = url.getPath();
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append('_');
            }
            sb.append(".txt");
            name = sb.toString();
        }
        catch (MalformedURLException e) {
            name = "site-unknown.txt";
        }
        return new File(pluginDir, name);
    }

    /*
     * Exception decompiling
     */
    protected String downloadPluginList(String site, ProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 41[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleIOException(ProgressMonitor monitor, IOException e, String details) {
        String msg = e.getMessage();
        if (details == null || details.isEmpty()) {
            Logging.error(e.getClass().getSimpleName() + ": " + msg);
        } else {
            Logging.error(msg + " - Details:\n" + details);
        }
        if (this.displayErrMsg) {
            ReadRemotePluginInformationTask.displayErrorMessage(monitor, msg, details, I18n.tr("Plugin list download error", new Object[0]), I18n.tr("JOSM failed to download plugin list:", new Object[0]));
        }
    }

    private static void displayErrorMessage(ProgressMonitor monitor, String msg, String details, String title, String firstMessage) {
        GuiHelper.runInEDTAndWait(() -> {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(firstMessage), GBC.eol().insets(0, 0, 0, 10));
            StringBuilder b = new StringBuilder();
            for (String part : msg.split("(?<=\\G.{200})", -1)) {
                b.append(part).append('\n');
            }
            panel.add((Component)new JLabel("<html><body width=\"500\"><b>" + b.toString().trim() + "</b></body></html>"), GBC.eol().insets(0, 0, 0, 10));
            if (details != null && !details.isEmpty()) {
                panel.add((Component)new JLabel(I18n.tr("Details:", new Object[0])), GBC.eol().insets(0, 0, 0, 10));
                JosmTextArea area = new JosmTextArea(details);
                area.setEditable(false);
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                JScrollPane scrollPane = new JScrollPane(area);
                scrollPane.setPreferredSize(new Dimension(500, 300));
                panel.add((Component)scrollPane, GBC.eol().fill());
            }
            JOptionPane.showMessageDialog(monitor.getWindowParent(), panel, title, 0);
        });
    }

    protected void cachePluginList(String site, String list) {
        File pluginDir = Preferences.main().getPluginsDirectory();
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            Logging.warn(I18n.tr("Failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", pluginDir.toString(), site));
        }
        File cacheFile = this.createSiteCacheFile(pluginDir, site);
        this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", cacheFile.toString()));
        try (PrintWriter writer = new PrintWriter(cacheFile, StandardCharsets.UTF_8.name());){
            writer.write(list);
            writer.flush();
        }
        catch (IOException e) {
            Logging.error(e);
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> plugins) {
        ArrayList<PluginInformation> ret = new ArrayList<PluginInformation>(plugins.size());
        HashSet<String> deprecatedPluginNames = new HashSet<String>();
        for (PluginHandler.DeprecatedPlugin p : PluginHandler.DEPRECATED_PLUGINS) {
            deprecatedPluginNames.add(p.name);
        }
        for (PluginInformation plugin : plugins) {
            if (deprecatedPluginNames.contains(plugin.name)) continue;
            ret.add(plugin);
        }
        return ret;
    }

    protected List<PluginInformation> filterIrrelevantPlugins(List<PluginInformation> plugins) {
        return plugins.stream().filter(PluginInformation::isForCurrentPlatform).collect(Collectors.toList());
    }

    protected void parsePluginListDocument(String site, String doc) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", site));
            ByteArrayInputStream in = new ByteArrayInputStream(doc.getBytes(StandardCharsets.UTF_8));
            List<PluginInformation> pis = new PluginListParser().parse(in);
            this.availablePlugins.addAll(this.filterIrrelevantPlugins(this.filterDeprecatedPlugins(pis)));
        }
        catch (PluginListParseException e) {
            Logging.error(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", site, e.toString()));
            Logging.error(e);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        LinkedList<File> siteCacheFiles = new LinkedList<File>();
        for (String location : PluginInformation.getPluginLocations()) {
            File[] f = new File(location).listFiles((dir, name) -> name.matches("^([0-9]+-)?site.*\\.txt$") || name.matches("^([0-9]+-)?site.*-icons\\.zip$"));
            if (f == null || f.length <= 0) continue;
            siteCacheFiles.addAll(Arrays.asList(f));
        }
        File pluginDir = Preferences.main().getPluginsDirectory();
        for (String site : this.sites) {
            String printsite = site.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", printsite));
            String list = this.downloadPluginList(site, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            siteCacheFiles.remove(this.createSiteCacheFile(pluginDir, site));
            if (list == null) continue;
            this.getProgressMonitor().worked(1);
            this.cachePluginList(site, list);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            this.parsePluginListDocument(site, list);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        for (File file : siteCacheFiles) {
            Utils.deleteFile(file);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailablePlugins() {
        return this.availablePlugins;
    }
}

