/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorListManagementDialog;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidatorDialog
extends ToggleDialog
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener,
DataSetListenerAdapter.Listener {
    public final ValidatorTreePanel tree;
    public static final ValidateAction validateAction = new ValidateAction();
    private final transient Action fixAction;
    private final transient Action ignoreAction;
    private final transient Action ignorelistManagementAction;
    private final transient Action selectAction;
    private final transient LookupAction lookupAction;
    private final transient JosmAction ignoreForNowAction;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final transient PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private final transient DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private DefaultMutableTreeNode lastSelectedNode;

    public ValidatorDialog() {
        super(I18n.tr("Validation Results", new Object[0]), "validator", I18n.tr("Open the validation window.", new Object[0]), Shortcut.registerShortcut("subwindow:validator", I18n.tr("Windows: {0}", I18n.tr("Validation Results", new Object[0])), 86, 5007), 150, false, ValidatorPreference.class);
        this.tree = new ValidatorTreePanel();
        this.tree.addMouseListener(new MouseEventHandler());
        this.addTreeSelectionListener(new SelectionWatch());
        InputMapUtils.unassignCtrlShiftUpDown(this.tree, 0);
        this.ignoreForNowAction = new JosmAction(I18n.tr("Ignore for now", new Object[0]), "dialogs/delete", I18n.tr("Ignore and remove from tree.", new Object[0]), Shortcut.registerShortcut("tools:validate:ignore-for-now", I18n.tr("Ignore and remove from tree.", new Object[0]), 45, 5005), false, false){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestError error = ValidatorDialog.this.getSelectedError();
                if (error != null) {
                    error.setIgnored(true);
                    ValidatorDialog.this.tree.resetErrors();
                    ValidatorDialog.invalidateValidatorLayers();
                }
            }
        };
        this.popupMenuHandler.addAction(MainApplication.getMenu().autoScaleActions.get((Object)AutoScaleAction.AutoScaleMode.PROBLEM));
        this.popupMenuHandler.addAction(new EditRelationAction());
        this.popupMenuHandler.addAction(this.ignoreForNowAction);
        LinkedList<SideButton> buttons = new LinkedList<SideButton>();
        this.selectAction = new AbstractSelectAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.setSelectedItems();
            }
        };
        this.selectAction.setEnabled(false);
        InputMapUtils.addEnterAction(this.tree, this.selectAction);
        buttons.add(new SideButton(this.selectAction));
        this.lookupAction = new LookupAction();
        buttons.add(new SideButton(this.lookupAction));
        buttons.add(new SideButton(validateAction));
        this.fixAction = new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Fix", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Fix the selected issue.", new Object[0]));
                new ImageProvider("dialogs", "fix").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.fixErrors();
            }
        };
        this.fixAction.setEnabled(false);
        buttons.add(new SideButton(this.fixAction));
        if (ValidatorPrefHelper.PREF_USE_IGNORE.get().booleanValue()) {
            this.ignoreAction = new AbstractAction(){
                {
                    this.putValue("Name", I18n.tr("Ignore", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Ignore the selected issue next time.", new Object[0]));
                    new ImageProvider("dialogs", "fix").getResource().attachImageIcon(this, true);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValidatorDialog.this.ignoreErrors();
                }
            };
            this.ignoreAction.setEnabled(false);
            buttons.add(new SideButton(this.ignoreAction));
            this.ignorelistManagementAction = new IgnorelistManagementAction();
            buttons.add(new SideButton(this.ignorelistManagementAction));
        } else {
            this.ignoreAction = null;
            this.ignorelistManagementAction = null;
        }
        this.createLayout(this.tree, true, buttons);
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this);
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null) {
            this.updateSelection(ds.getAllSelected());
        }
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        SelectionEventManager.getInstance().removeSelectionListener(this);
    }

    @Override
    public void setVisible(boolean v) {
        if (this.tree != null) {
            this.tree.setVisible(v);
        }
        super.setVisible(v);
    }

    private void fixErrors() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        LinkedList<TestError> errorsToFix = new LinkedList<TestError>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            ValidatorTreePanel.visitTestErrors(node, errorsToFix::add, processedNodes);
        }
        MainApplication.worker.submit(new FixTask(errorsToFix));
    }

    private void ignoreErrors() {
        int asked = -1;
        AtomicBoolean changed = new AtomicBoolean();
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            Object mainNodeInfo = node.getUserObject();
            int depth = node.getDepth();
            if (!(mainNodeInfo instanceof TestError)) {
                HashSet state = new HashSet();
                if (asked == -1) {
                    Object[] a = new String[]{I18n.tr("Whole group", new Object[0]), I18n.tr("Single elements", new Object[0]), I18n.tr("Nothing", new Object[0])};
                    asked = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("Ignore whole group or individual elements?", new Object[0]), I18n.tr("Ignoring elements", new Object[0]), 1, 2, null, a, a[1]);
                }
                if (asked == 0) {
                    ValidatorTreePanel.visitTestErrors(node, err -> {
                        err.setIgnored(true);
                        changed.set(true);
                        state.add(new Pair<String, String>(depth == 1 ? err.getIgnoreSubGroup() : err.getIgnoreGroup(), err.getMessage()));
                    }, processedNodes);
                    for (Pair s : state) {
                        OsmValidator.addIgnoredError((String)s.a, (String)s.b);
                    }
                    continue;
                }
                if (asked == 2 || asked == -1) continue;
            }
            ValidatorTreePanel.visitTestErrors(node, error -> {
                String state = error.getIgnoreState();
                if (state != null) {
                    OsmValidator.addIgnoredError(state, error.getMessage());
                }
                changed.set(true);
                error.setIgnored(true);
            }, processedNodes);
        }
        if (changed.get()) {
            this.tree.resetErrors();
            OsmValidator.saveIgnoredErrors();
            ValidatorDialog.invalidateValidatorLayers();
        }
    }

    private void setSelectedItems() {
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (this.tree == null || ds == null) {
            return;
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null) {
            return;
        }
        HashSet sel = new HashSet(40);
        for (TreePath path : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                TestError error = (TestError)nodeInfo;
                error.getPrimitives().stream().filter(OsmPrimitive::isSelectable).forEach(sel::add);
            }
        }
        ds.setSelected(sel);
    }

    private boolean setSelection(Collection<OsmPrimitive> sel, boolean addSelected) {
        AtomicBoolean hasFixes = new AtomicBoolean();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(node)) {
            ValidatorTreePanel.visitTestErrors(this.lastSelectedNode, error -> error.setSelected(false));
        }
        this.lastSelectedNode = node;
        if (node != null) {
            ValidatorTreePanel.visitTestErrors(node, error -> {
                error.setSelected(true);
                hasFixes.set(hasFixes.get() || error.isFixable());
                if (addSelected) {
                    error.getPrimitives().stream().filter(OsmPrimitive::isSelectable).forEach(sel::add);
                }
            });
            this.selectAction.setEnabled(true);
            if (this.ignoreAction != null) {
                this.ignoreAction.setEnabled(!(node.getUserObject() instanceof Severity));
            }
        }
        return hasFixes.get();
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        OsmDataLayer editLayer = e.getSource().getEditLayer();
        if (editLayer == null) {
            this.tree.setErrorList(new ArrayList<TestError>());
        } else {
            this.tree.setErrorList(editLayer.validationErrors);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.removeTreeSelectionListener(listener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public TestError getSelectedError() {
        Object object;
        Object comp = this.tree.getLastSelectedPathComponent();
        if (comp instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)comp).getUserObject()) instanceof TestError) {
            return (TestError)object;
        }
        return null;
    }

    public void updateSelection(Collection<? extends OsmPrimitive> newSelection) {
        if (!Config.getPref().getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (newSelection.isEmpty()) {
            this.tree.setFilter(null);
        }
        this.tree.setFilter(new HashSet<OsmPrimitive>(newSelection));
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.updateSelection(event.getSelection());
        this.lookupAction.updateEnabledState();
    }

    private static void invalidateValidatorLayers() {
        MainApplication.getLayerManager().getLayersOfType(ValidatorLayer.class).forEach(AbstractMapViewPaintable::invalidate);
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        validateAction.updateEnabledState();
        this.lookupAction.updateEnabledState();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.ignoreForNowAction != null) {
            this.ignoreForNowAction.destroy();
        }
    }

    private static class AutofixCommand
    extends SequenceCommand {
        AutofixCommand(Collection<Command> sequenz) {
            super(I18n.tr("auto-fixed validator issues", new Object[0]), sequenz, true);
            this.setSequenceComplete(true);
        }

        @Override
        public void undoCommand() {
            this.getAffectedDataSet().update(() -> super.undoCommand());
        }

        @Override
        public boolean executeCommand() {
            return this.getAffectedDataSet().update(() -> super.executeCommand());
        }
    }

    class FixTask
    extends PleaseWaitRunnable {
        private final Collection<TestError> testErrors;
        private final List<Command> fixCommands;
        private boolean canceled;

        FixTask(Collection<TestError> testErrors) {
            super(I18n.tr("Fixing errors ...", new Object[0]), false);
            this.fixCommands = new ArrayList<Command>();
            this.testErrors = testErrors == null ? new ArrayList() : testErrors;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void fixError(TestError error) throws InterruptedException, InvocationTargetException {
            if (error.isFixable()) {
                Command fixCommand;
                if (error.getPrimitives().stream().noneMatch(p -> p.isDeleted() || p.getDataSet() == null) && (fixCommand = error.getFix()) != null) {
                    SwingUtilities.invokeAndWait(fixCommand::executeCommand);
                    this.fixCommands.add(fixCommand);
                }
                error.setIgnored(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor monitor = this.getProgressMonitor();
            try {
                monitor.setTicksCount(this.testErrors.size());
                DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
                int i = 0;
                SwingUtilities.invokeAndWait(ds::beginUpdate);
                ValidatorDialog.this.tree.setResetScheduled();
                try {
                    for (TestError error : this.testErrors) {
                        monitor.subTask(I18n.tr("Fixing ({0}/{1}): ''{2}''", ++i, this.testErrors.size(), error.getMessage()));
                        if (!this.canceled) break block12;
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeAndWait(ds::endUpdate);
                    throw throwable;
                }
                {
                    TestError error;
                    block12: {
                        SwingUtilities.invokeAndWait(ds::endUpdate);
                        return;
                    }
                    this.fixError(error);
                    monitor.worked(1);
                    continue;
                }
                SwingUtilities.invokeAndWait(ds::endUpdate);
                monitor.subTask(I18n.tr("Updating map ...", new Object[0]));
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.fixCommands.isEmpty()) {
                        UndoRedoHandler.getInstance().add(this.fixCommands.size() > 1 ? new AutofixCommand(this.fixCommands) : this.fixCommands.get(0), false);
                    }
                    ValidatorDialog.invalidateValidatorLayers();
                });
            }
            catch (InterruptedException e) {
                this.tryUndo();
                throw new JosmRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JosmRuntimeException(e);
            }
            finally {
                if (monitor.isCanceled()) {
                    this.tryUndo();
                }
                GuiHelper.runInEDTAndWait(ValidatorDialog.this.tree::resetErrors);
                monitor.finishTask();
            }
        }

        private void tryUndo() {
            MainApplication.getLayerManager().getActiveDataSet().update(() -> {
                for (int i = this.fixCommands.size() - 1; i >= 0; --i) {
                    this.fixCommands.get(i).undoCommand();
                }
            });
        }
    }

    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        @Override
        public void visit(OsmPrimitive p) {
            if (p.isUsable()) {
                p.accept(this);
            }
        }

        @Override
        public void visit(WaySegment ws) {
            if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.getNodesCount()) {
                return;
            }
            this.visit(ws.getFirstNode());
            this.visit(ws.getSecondNode());
        }

        @Override
        public void visit(List<Node> nodes) {
            for (Node n : nodes) {
                this.visit(n);
            }
        }

        @Override
        public void visit(TestError error) {
            if (error != null) {
                error.visitHighlighted(this);
            }
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ValidatorDialog.this.ignoreAction != null) {
                ValidatorDialog.this.ignoreAction.setEnabled(false);
            }
            ValidatorDialog.this.selectAction.setEnabled(false);
            HashSet sel = new HashSet();
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, true);
            ValidatorDialog.this.fixAction.setEnabled(hasFixes);
            ValidatorDialog.this.popupMenuHandler.setPrimitives(sel);
            ValidatorDialog.invalidateValidatorLayers();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(ValidatorDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath selPath = ValidatorDialog.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                ValidatorDialog.this.tree.clearSelection();
            }
            ValidatorDialog.this.fixAction.setEnabled(false);
            if (ValidatorDialog.this.ignoreAction != null) {
                ValidatorDialog.this.ignoreAction.setEnabled(false);
            }
            ValidatorDialog.this.selectAction.setEnabled(false);
            boolean isDblClick = MouseEventHandler.isDoubleClick(e);
            HashSet sel = isDblClick ? new HashSet(40) : null;
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, isDblClick);
            ValidatorDialog.this.fixAction.setEnabled(hasFixes);
            if (isDblClick) {
                DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
                if (ds != null) {
                    ds.setSelected(sel);
                }
                if (Config.getPref().getBoolean("validator.autozoom", false)) {
                    AutoScaleAction.zoomTo(sel);
                }
            }
        }

        @Override
        public void launch(MouseEvent e) {
            TreePath selPath = ValidatorDialog.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
            if (!(node.getUserObject() instanceof TestError)) {
                return;
            }
            super.launch(e);
        }
    }

    class LookupAction
    extends AbstractAction {
        LookupAction() {
            this.putValue("Name", I18n.tr("Lookup", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Looks up the selected primitives in the error list.", new Object[0]));
            new ImageProvider("dialogs", "search").getResource().attachImageIcon(this, true);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            if (ds == null) {
                return;
            }
            ValidatorDialog.this.tree.selectRelatedErrors(ds.getSelected());
        }

        void updateEnabledState() {
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            if (ds == null || ds.selectionEmpty()) {
                this.setEnabled(false);
            } else {
                boolean found = ValidatorDialog.this.tree.getErrors().stream().anyMatch(e -> e.getPrimitives().stream().anyMatch(OsmPrimitive::isSelected));
                this.setEnabled(found);
            }
        }
    }

    static class IgnorelistManagementAction
    extends AbstractAction {
        IgnorelistManagementAction() {
            this.putValue("Name", I18n.tr("Manage Ignore", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Manage the ignore list", new Object[0]));
            new ImageProvider("dialogs", "fix").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ValidatorListManagementDialog("Ignore");
        }
    }
}

