/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class EmptyLineRule
extends TextLevelRule {
    public EmptyLineRule(ResourceBundle messages, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setOfficeDefaultOn();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public EmptyLineRule(ResourceBundle messages) {
        this(messages, false);
    }

    @Override
    public String getId() {
        return "EMPTY_LINE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("empty_line_rule_desc");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedSentence sentence = sentences.get(n);
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            for (int i = 2; i < tokens.length; ++i) {
                if (!tokens[i].isLinebreak() || tokens[i - 1].isLinebreak()) continue;
                int firstLB = i++;
                while (i < tokens.length && tokens[i].isWhitespace() && !tokens[i].isLinebreak() && !tokens[i].getToken().equals("\u200b")) {
                    ++i;
                }
                if (i >= tokens.length || !tokens[i].isLinebreak()) continue;
                int toPos = pos + tokens[firstLB - 1].getEndPos();
                int fromPos = toPos - 1;
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, this.messages.getString("empty_line_rule_msg"));
                ruleMatches.add(ruleMatch);
                --i;
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

