/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.synonym;

import com.hankcs.hanlp.corpus.synonym.ISynonym;
import com.hankcs.hanlp.corpus.synonym.SynonymHelper;
import java.util.ArrayList;
import java.util.List;

public class Synonym
implements ISynonym {
    public String realWord;
    public long id;
    public Type type;

    @Deprecated
    public Synonym(String realWord, String idString) {
        this.realWord = realWord;
        this.id = SynonymHelper.convertString2Id(idString);
    }

    @Deprecated
    public Synonym(String realWord, long id) {
        this.realWord = realWord;
        this.id = id;
    }

    public Synonym(String realWord, long id, Type type) {
        this.realWord = realWord;
        this.id = id;
        this.type = type;
    }

    @Override
    public String getRealWord() {
        return this.realWord;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getIdString() {
        return SynonymHelper.convertId2StringWithIndex(this.id);
    }

    public static List<Synonym> create(String param) {
        if (param == null) {
            return null;
        }
        String[] args = param.split(" ");
        return Synonym.create(args);
    }

    public static ArrayList<Synonym> create(String[] args) {
        Type type;
        ArrayList<Synonym> synonymList = new ArrayList<Synonym>(args.length - 1);
        String idString = args[0];
        switch (idString.charAt(idString.length() - 1)) {
            case '=': {
                type = Type.EQUAL;
                break;
            }
            case '#': {
                type = Type.LIKE;
                break;
            }
            default: {
                type = Type.SINGLE;
            }
        }
        long startId = SynonymHelper.convertString2IdWithIndex(idString, 0);
        for (int i = 1; i < args.length; ++i) {
            if (type == Type.LIKE) {
                synonymList.add(new Synonym(args[i], startId + (long)i, type));
                continue;
            }
            synonymList.add(new Synonym(args[i], startId, type));
        }
        return synonymList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.realWord);
        switch (this.type) {
            case EQUAL: {
                sb.append('=');
                break;
            }
            case LIKE: {
                sb.append('#');
                break;
            }
            case SINGLE: {
                sb.append('@');
                break;
            }
            case UNDEFINED: {
                sb.append('?');
            }
        }
        sb.append(this.getIdString());
        return sb.toString();
    }

    public long distance(Synonym other) {
        return Math.abs(this.id - other.id);
    }

    public static enum Type {
        EQUAL,
        LIKE,
        SINGLE,
        UNDEFINED;

    }
}

