/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.MatchPosition;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;

public final class RemoteRuleFilters {
    public static final String RULE_FILE = "remote-rule-filters.xml";
    private static final LoadingCache<Language, Map<String, List<AbstractPatternRule>>> rules = CacheBuilder.newBuilder().build(CacheLoader.from(RemoteRuleFilters::load));

    private RemoteRuleFilters() {
    }

    public static List<RuleMatch> filterMatches(@NotNull Language lang, @NotNull AnalyzedSentence sentence, @NotNull List<RuleMatch> matches) throws ExecutionException, IOException {
        if (matches.isEmpty()) {
            return matches;
        }
        Set matchIds = matches.stream().map(m -> m.getRule().getId()).collect(Collectors.toSet());
        List filters = ((Map)rules.get((Object)lang)).entrySet().stream().filter(e -> matchIds.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
        HashMap<MatchPosition, Set> filterRulesByPosition = new HashMap<MatchPosition, Set>();
        for (AbstractPatternRule rule : filters) {
            RuleMatch[] filterMatches;
            for (RuleMatch match2 : filterMatches = rule.match(sentence)) {
                MatchPosition pos = new MatchPosition(match2.getFromPos(), match2.getToPos());
                filterRulesByPosition.computeIfAbsent(pos, k -> new HashSet()).add(rule);
            }
        }
        List<RuleMatch> filteredMatches = matches.stream().filter(match -> {
            MatchPosition pos = new MatchPosition(match.getFromPos(), match.getToPos());
            boolean matched = filterRulesByPosition.getOrDefault(pos, Collections.emptySet()).stream().anyMatch(rule -> rule.getId().equals(match.getRule().getId()));
            return !matched;
        }).collect(Collectors.toList());
        return filteredMatches;
    }

    public static void main(String[] args) throws Exception {
        String langCode = args[0];
        String matchesFile = args[1];
        Language lang = Languages.getLanguageForShortCode(langCode);
        List rules = RemoteRuleFilters.load(lang).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Stream<String> lines = Files.lines(Paths.get(matchesFile, new String[0]), Charset.forName("UTF-8"));
        ObjectMapper mapper = new ObjectMapper();
        JLanguageTool lt = new JLanguageTool(lang);
        Map<String, List<AbstractMap.SimpleEntry>> result = ((Stream)lines.parallel()).map(s -> {
            try {
                return (ExpectedMatches)mapper.readValue(s, ExpectedMatches.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(matches -> {
            try {
                AnalyzedSentence s = lt.getAnalyzedSentence(matches.sentence);
                List<RuleMatch> ruleMatches = matches.matches.stream().map(m -> new RuleMatch(new ExpectedRule(m.rule_id), s, m.offset, m.offset + m.length, "")).collect(Collectors.toList());
                List<RuleMatch> remaining = RemoteRuleFilters.filterMatches(lang, s, ruleMatches);
                ruleMatches.removeAll(remaining);
                return Streams.concat((Stream[])new Stream[]{remaining.stream().map(m -> new AbstractMap.SimpleEntry<Boolean, RuleMatch>(true, (RuleMatch)m)), ruleMatches.stream().map(m -> new AbstractMap.SimpleEntry<Boolean, RuleMatch>(false, (RuleMatch)m))});
            }
            catch (IOException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.groupingBy(key -> ((Boolean)key.getKey() != false ? "Remaining" : "Removed") + " - " + ((RuleMatch)key.getValue()).getRule().getId()));
        result.forEach((section, matches) -> {
            System.out.println((String)section);
            System.out.println("---");
            for (Map.Entry entry : matches) {
                RuleMatch match = (RuleMatch)entry.getValue();
                String s = match.getSentence().getText();
                String marked = s.substring(0, match.getFromPos()) + "<marker>" + s.substring(match.getFromPos(), match.getToPos()) + "</marker>" + s.substring(match.getToPos());
                System.out.println(marked);
            }
            System.out.println("---");
        });
    }

    static Map<String, List<AbstractPatternRule>> load(Language lang) {
        JLanguageTool lt = new JLanguageTool(lang);
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String filename = dataBroker.getRulesDir() + "/" + RemoteRuleFilters.getFilename(lang);
        try {
            List<AbstractPatternRule> allRules = lt.loadPatternRules(filename);
            HashMap<String, List<AbstractPatternRule>> rules = new HashMap<String, List<AbstractPatternRule>>();
            for (AbstractPatternRule rule : allRules) {
                rules.computeIfAbsent(rule.getId(), k -> new ArrayList()).add(rule);
            }
            return rules;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    static String getFilename(Language lang) {
        return lang.getShortCode() + "/" + RULE_FILE;
    }

    static class ExpectedRule
    extends Rule {
        private final String id;

        public ExpectedRule(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new IllegalStateException();
        }
    }

    static class ExpectedMatch {
        public int offset;
        public int length;
        public String rule_id;

        ExpectedMatch() {
        }
    }

    static class ExpectedMatches {
        public String sentence;
        public List<ExpectedMatch> matches;

        ExpectedMatches() {
        }
    }
}

