/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;

public abstract class AbstractSuppressMisspelledSuggestionsFilter
extends RuleFilter {
    protected final Language language;
    protected final ResourceBundle messages;

    protected AbstractSuppressMisspelledSuggestionsFilter(Language language) {
        this.language = language;
        this.messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale(language.getShortCode()));
    }

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        RuleMatch ruleMatch = match;
        List<String> replacements = match.getSuggestedReplacements();
        ArrayList<String> newReplacements = new ArrayList<String>();
        for (String r : replacements) {
            if (this.isMisspelled(r)) continue;
            newReplacements.add(r);
        }
        String suppressMatch = this.getRequired("suppressMatch", arguments);
        boolean bSuppressMatch = true;
        if (suppressMatch != null && suppressMatch.equalsIgnoreCase("false")) {
            bSuppressMatch = false;
        }
        if (newReplacements.isEmpty() && bSuppressMatch) {
            return null;
        }
        ruleMatch.setSuggestedReplacements(newReplacements);
        return ruleMatch;
    }

    public boolean isMisspelled(String s) throws IOException {
        SpellingCheckRule spellerRule = this.language.getDefaultSpellingRule(this.messages);
        try {
            List<String> tokens = this.language.getWordTokenizer().tokenize(s);
            boolean isMisspelled = false;
            for (String token : tokens) {
                isMisspelled = isMisspelled || spellerRule.isMisspelled(token);
            }
            return isMisspelled;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

