/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionState;
import io.lettuce.core.RedisCommandBuilder;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.ConnectionInitializer;
import io.lettuce.core.protocol.ProtocolVersion;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class RedisHandshake
implements ConnectionInitializer {
    private final RedisCommandBuilder<String, String> commandBuilder = new RedisCommandBuilder<String, String>(StringCodec.UTF8);
    private final ProtocolVersion requestedProtocolVersion;
    private final boolean pingOnConnect;
    private final ConnectionState connectionState;
    private volatile ProtocolVersion negotiatedProtocolVersion;

    RedisHandshake(ProtocolVersion requestedProtocolVersion, boolean pingOnConnect, ConnectionState connectionState) {
        this.requestedProtocolVersion = requestedProtocolVersion;
        this.pingOnConnect = pingOnConnect;
        this.connectionState = connectionState;
    }

    public ProtocolVersion getRequestedProtocolVersion() {
        return this.requestedProtocolVersion;
    }

    public ProtocolVersion getNegotiatedProtocolVersion() {
        return this.negotiatedProtocolVersion;
    }

    @Override
    public CompletionStage<Void> initialize(Channel channel) {
        CompletableFuture<Object> handshake;
        if (this.requestedProtocolVersion == ProtocolVersion.RESP2) {
            handshake = this.initializeResp2(channel);
            this.negotiatedProtocolVersion = ProtocolVersion.RESP2;
        } else {
            handshake = this.requestedProtocolVersion == ProtocolVersion.RESP3 ? this.initializeResp3(channel) : (this.requestedProtocolVersion == null ? this.tryHandshakeResp3(channel) : Futures.failed(new RedisConnectionException("Protocol version" + (Object)((Object)this.requestedProtocolVersion) + " not supported")));
        }
        return handshake.thenCompose(ignore -> this.applyPostHandshake(channel, this.getNegotiatedProtocolVersion()));
    }

    private CompletableFuture<?> tryHandshakeResp3(Channel channel) {
        CompletableFuture handshake = new CompletableFuture();
        AsyncCommand<String, String, Map<String, Object>> hello = this.initiateHandshakeResp3(channel);
        hello.whenComplete((settings, throwable) -> {
            if (throwable != null) {
                if (RedisHandshake.isUnknownCommand(hello.getError())) {
                    this.fallbackToResp2(channel, handshake);
                } else {
                    handshake.completeExceptionally((Throwable)throwable);
                }
            } else {
                handshake.complete(null);
            }
        });
        return handshake;
    }

    private void fallbackToResp2(Channel channel, CompletableFuture<?> handshake) {
        this.initializeResp2(channel).whenComplete((o, nested) -> {
            if (nested != null) {
                handshake.completeExceptionally((Throwable)nested);
            } else {
                handshake.complete(null);
            }
        });
    }

    private CompletableFuture<?> initializeResp2(Channel channel) {
        return this.initiateHandshakeResp2(channel).thenRun(() -> {
            this.negotiatedProtocolVersion = ProtocolVersion.RESP2;
            this.connectionState.setHandshakeResponse(new ConnectionState.HandshakeResponse(this.negotiatedProtocolVersion, null, null, null, null));
        });
    }

    private CompletableFuture<Void> initializeResp3(Channel channel) {
        return this.initiateHandshakeResp3(channel).thenAccept(response -> {
            Long id = (Long)response.get("id");
            String mode = (String)response.get("mode");
            String version = (String)response.get("version");
            String role = (String)response.get("role");
            this.negotiatedProtocolVersion = ProtocolVersion.RESP3;
            this.connectionState.setHandshakeResponse(new ConnectionState.HandshakeResponse(this.negotiatedProtocolVersion, id, version, mode, role));
        });
    }

    private CompletableFuture<?> initiateHandshakeResp2(Channel channel) {
        if (this.connectionState.hasUsername()) {
            return this.dispatch(channel, this.commandBuilder.auth(this.connectionState.getUsername(), this.connectionState.getPassword()));
        }
        if (this.connectionState.hasPassword()) {
            return this.dispatch(channel, this.commandBuilder.auth(this.connectionState.getPassword()));
        }
        if (this.pingOnConnect) {
            return this.dispatch(channel, this.commandBuilder.ping());
        }
        return CompletableFuture.completedFuture(null);
    }

    private AsyncCommand<String, String, Map<String, Object>> initiateHandshakeResp3(Channel channel) {
        if (this.connectionState.hasPassword()) {
            return this.dispatch(channel, this.commandBuilder.hello(3, LettuceStrings.isNotEmpty(this.connectionState.getUsername()) ? this.connectionState.getUsername() : "default", this.connectionState.getPassword(), this.connectionState.getClientName()));
        }
        return this.dispatch(channel, this.commandBuilder.hello(3, null, null, this.connectionState.getClientName()));
    }

    private CompletableFuture<Void> applyPostHandshake(Channel channel, ProtocolVersion negotiatedProtocolVersion) {
        ArrayList postHandshake = new ArrayList();
        if (this.connectionState.getClientName() != null && negotiatedProtocolVersion == ProtocolVersion.RESP2) {
            postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.clientSetname(this.connectionState.getClientName())));
        }
        if (this.connectionState.getDb() > 0) {
            postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.select(this.connectionState.getDb())));
        }
        if (this.connectionState.isReadOnly()) {
            postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.readOnly()));
        }
        if (postHandshake.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.dispatch(channel, postHandshake);
    }

    private CompletableFuture<Void> dispatch(Channel channel, List<AsyncCommand<?, ?, ?>> commands) {
        CompletionStage writeFuture = Futures.toCompletionStage(channel.writeAndFlush(commands));
        return CompletableFuture.allOf(Futures.allOf(commands), writeFuture.toCompletableFuture());
    }

    private <T> AsyncCommand<String, String, T> dispatch(Channel channel, Command<String, String, T> command) {
        AsyncCommand future = new AsyncCommand(command);
        channel.writeAndFlush(future).addListener(writeFuture -> {
            if (!writeFuture.isSuccess()) {
                future.completeExceptionally(writeFuture.cause());
            }
        });
        return future;
    }

    private static boolean isUnknownCommand(String error) {
        return LettuceStrings.isNotEmpty(error) && error.startsWith("ERR unknown command");
    }
}

