/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.filter;

import java.util.LinkedList;
import java.util.List;
import org.dts.spell.filter.Filter;
import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.WordTokenizer;

public class ChainFilter
implements Filter {
    private List<Filter> filters = new LinkedList<Filter>();

    @Override
    public Word filter(Word word, WordTokenizer tokenizer) {
        for (Filter filter : this.filters) {
            word = filter.filter(word, tokenizer);
            if (null != word) continue;
            return null;
        }
        return word;
    }

    @Override
    public void updateCharSequence(WordTokenizer tokenizer, int start, int end, int cause) {
        for (Filter filter : this.filters) {
            filter.updateCharSequence(tokenizer, start, end, cause);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }
}

