/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.events.IProjectEventListener;

public final class ProjectFactory {
    private ProjectFactory() {
    }

    public static void createNotLoadedProject() {
        Core.setProject(new NotLoadedProject());
    }

    public static void createProject(ProjectProperties newProps) {
        RealProject p = new RealProject(newProps);
        Core.setProject(p);
        p.createProject();
        Core.getAutoSave().enable();
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.CREATE);
    }

    public static void loadProject(ProjectProperties props, boolean onlineMode) {
        Core.getAutoSave().disable();
        RealProject p = new RealProject(props);
        Core.setProject(p);
        p.loadProject(onlineMode);
        if (p.isProjectLoaded()) {
            Core.getAutoSave().enable();
            CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
        } else {
            Core.setProject(new NotLoadedProject());
        }
    }

    public static void closeProject() {
        Core.getAutoSave().disable();
        Core.getProject().closeProject();
        Core.setProject(new NotLoadedProject());
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
    }
}

