/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.gui.glossary.taas.TaaSClient;
import org.omegat.gui.glossary.taas.TaaSGlossary;
import org.omegat.gui.glossary.taas.TaaSPreferencesController;
import org.omegat.gui.preferences.PreferencesControllers;
import org.omegat.gui.preferences.PreferencesWindowController;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public final class TaaSPlugin {
    static Transformer filterTransformer;

    public static TaaSClient getClient() {
        return ClientHolder.CLIENT;
    }

    private TaaSPlugin() {
    }

    public static void loadPlugins() {
        TaaSGlossary glossary;
        TaaSClient client;
        block16: {
            client = TaaSPlugin.getClient();
            try {
                client.init();
                if (client.isAllowed()) {
                    glossary = new TaaSGlossary();
                    try (InputStream in = TaaSGlossary.class.getResourceAsStream("filter.xslt");){
                        if (in == null) {
                            throw new Exception("filter.xslt is unaccessible");
                        }
                        TransformerFactory factory = TransformerFactory.newInstance();
                        StreamSource xslt = new StreamSource(in);
                        filterTransformer = factory.newTransformer(xslt);
                        break block16;
                    }
                }
                glossary = null;
            }
            catch (Exception ex) {
                Log.log(ex);
                return;
            }
        }
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
                JCheckBoxMenuItem lookup = new JCheckBoxMenuItem();
                lookup.setSelected(Preferences.isPreferenceDefault("taas_lookup", false));
                Mnemonics.setLocalizedText((AbstractButton)lookup, (String)OStrings.getString("TAAS_MENU_LOOKUP"));
                lookup.addActionListener(e -> {
                    if (client.isAllowed()) {
                        Preferences.setPreference("taas_lookup", lookup.isSelected());
                        Preferences.save();
                    } else {
                        lookup.setSelected(false);
                        new PreferencesWindowController().show(Core.getMainWindow().getApplicationFrame(), TaaSPreferencesController.class);
                    }
                });
                Core.getMainWindow().getMainMenu().getGlossaryMenu().add(lookup);
                PreferencesControllers.addSupplier(TaaSPreferencesController::new);
                Preferences.addPropertyChangeListener("taas_lookup", e -> lookup.setSelected((Boolean)e.getNewValue()));
                if (client.isAllowed()) {
                    Core.getGlossaryManager().addGlossaryProvider(glossary);
                }
            }

            @Override
            public void onApplicationShutdown() {
            }
        });
    }

    static String filterTaasResult(String xml) throws Exception {
        StreamSource src = new StreamSource(new StringReader(xml));
        StringWriter out = new StringWriter();
        filterTransformer.transform(src, new StreamResult(out));
        return out.toString();
    }

    static void filterTaasResult(InputStream in, OutputStream out) throws Exception {
        StreamSource src = new StreamSource(in);
        filterTransformer.transform(src, new StreamResult(out));
    }

    public static void unloadPlugins() {
    }

    private static class ClientHolder {
        private static final TaaSClient CLIENT = new TaaSClient();

        private ClientHolder() {
        }
    }
}

