/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.trie4j.Trie;
import org.trie4j.bv.BitVector01Divider;
import org.trie4j.bv.BytesRank0OnlySuccinctBitVector;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.LongsSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.io.Constants;
import org.trie4j.louds.TailLOUDSTrie;
import org.trie4j.louds.bvtree.BvTree;
import org.trie4j.louds.bvtree.LOUDSBvTree;
import org.trie4j.louds.bvtree.LOUDSPPBvTree;
import org.trie4j.tail.DefaultTailArray;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.index.ArrayTailIndex;
import org.trie4j.tail.index.DenseArrayTailIndex;
import org.trie4j.tail.index.SBVTailIndex;
import org.trie4j.tail.index.TailIndex;
import org.trie4j.util.IntArray;

public class TrieReader
implements Constants {
    private DataInputStream dis;

    public TrieReader(InputStream is) {
        this.dis = new DataInputStream(is);
    }

    public Trie read() throws IOException {
        short type = this.dis.readShort();
        switch (type) {
            case 49: {
                return this.readTailLOUDSTrie();
            }
        }
        throw new IOException(String.format("unknown trie type: 0x%04x", type));
    }

    public TailLOUDSTrie readTailLOUDSTrie() throws IOException {
        return new TailLOUDSTrie(this.dis.readInt(), this.dis.readInt(), this.readBvTree(), this.readChars(), this.readTailArray(), this.readSuccinctBitVector()){};
    }

    public BvTree readBvTree() throws IOException {
        short type = this.dis.readShort();
        switch (type) {
            case 64: {
                return this.readLOUDSBvTree();
            }
            case 65: {
                return this.readLOUDSPPBvTree();
            }
        }
        throw new IOException(String.format("unknown bvTree type: 0x%04x", type));
    }

    public LOUDSBvTree readLOUDSBvTree() throws IOException {
        return new LOUDSBvTree(this.readBytesSuccinctBitVector());
    }

    public LOUDSPPBvTree readLOUDSPPBvTree() throws IOException {
        return new LOUDSPPBvTree(this.readBitVector01Divider(), this.readSuccinctBitVector(), this.readSuccinctBitVector());
    }

    public TailArray readTailArray() throws IOException {
        short type = this.dis.readShort();
        switch (type) {
            case 80: {
                return this.readDefaultTailArray();
            }
        }
        throw new IOException(String.format("unknown tailArray type: 0x%04x", type));
    }

    public DefaultTailArray readDefaultTailArray() throws IOException {
        return new DefaultTailArray(new String(this.readChars()), this.readTailIndex());
    }

    public TailIndex readTailIndex() throws IOException {
        short type = this.dis.readShort();
        switch (type) {
            case 96: {
                return this.readArrayTailIndex();
            }
            case 97: {
                return this.readDenseArrayTailIndex();
            }
            case 98: {
                return this.readSBVTailIndex();
            }
        }
        throw new IOException(String.format("unknown tailIndex type: 0x%04x", type));
    }

    public ArrayTailIndex readArrayTailIndex() throws IOException {
        return new ArrayTailIndex(this.readInts());
    }

    public DenseArrayTailIndex readDenseArrayTailIndex() throws IOException {
        return new DenseArrayTailIndex(this.readSuccinctBitVector(), this.readInts());
    }

    public SBVTailIndex readSBVTailIndex() throws IOException {
        return new SBVTailIndex(this.readSuccinctBitVector(), this.dis.readInt());
    }

    public BitVector01Divider readBitVector01Divider() throws IOException {
        return new BitVector01Divider(this.dis.readBoolean(), this.dis.readBoolean());
    }

    public SuccinctBitVector readSuccinctBitVector() throws IOException {
        short type = this.dis.readShort();
        switch (type) {
            case 112: {
                return this.readBytesSuccinctBitVector();
            }
            case 113: {
                return this.readRank0OnlySuccinctBitVector();
            }
            case 114: {
                return this.readRank1OnlySuccinctBitVector();
            }
            case 115: {
                return this.readLongsSuccinctBitVector();
            }
        }
        return null;
    }

    public BytesSuccinctBitVector readBytesSuccinctBitVector() throws IOException {
        return new BytesSuccinctBitVector(this.readBytes(), this.dis.readInt(), this.dis.readInt(), this.dis.readInt(), this.dis.readInt(), this.dis.readInt(), this.readInts(), this.readIntArray());
    }

    public LongsSuccinctBitVector readLongsSuccinctBitVector() throws IOException {
        return new LongsSuccinctBitVector(this.readLongs(), this.dis.readInt(), this.dis.readInt(), this.dis.readInt(), this.dis.readInt(), this.dis.readInt(), this.readInts(), this.readIntArray());
    }

    public BytesRank0OnlySuccinctBitVector readRank0OnlySuccinctBitVector() throws IOException {
        return new BytesRank0OnlySuccinctBitVector(this.readBytes(), this.dis.readInt(), this.readInts());
    }

    public BytesRank1OnlySuccinctBitVector readRank1OnlySuccinctBitVector() throws IOException {
        return new BytesRank1OnlySuccinctBitVector(this.readBytes(), this.dis.readInt(), this.readInts());
    }

    public byte[] readBytes() throws IOException {
        int s;
        int n;
        byte[] ret = new byte[n];
        int offset = 0;
        for (n = this.dis.readInt(); n > 0; n -= s) {
            s = this.dis.read(ret, offset, n);
            if (s == -1) {
                throw new EOFException("failed to read expected bytes. exp:" + (offset + n) + " act:" + offset);
            }
            offset += s;
        }
        return ret;
    }

    public char[] readChars() throws IOException {
        int n = this.dis.readInt();
        char[] ret = new char[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.dis.readChar();
        }
        return ret;
    }

    public int[] readInts() throws IOException {
        int n = this.dis.readInt();
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.dis.readInt();
        }
        return ret;
    }

    public long[] readLongs() throws IOException {
        int n = this.dis.readInt();
        long[] ret = new long[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.dis.readLong();
        }
        return ret;
    }

    public IntArray readIntArray() throws IOException {
        int[] i = this.readInts();
        return new IntArray(i, i.length);
    }
}

