/*
SRXMLController.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRXMLController.h"

@implementation SRXMLController

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)init
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Load nib
    if (![NSBundle loadNibNamed:@"XMLView" owner:self]) {
        // Error
        NSLog(@"Can't load XMLView.nib");
        return nil;
    }
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- View --
//--------------------------------------------------------------//

- (NSView*)view
{
    return _view;
}

//--------------------------------------------------------------//
#pragma mark -- WebDataSource loading --
//--------------------------------------------------------------//

- (void)finishedLoadingWithDataSource:(WebDataSource*)dataSource
{
    // Get XML data
    NSData* data;
    data = [dataSource data];
    
    // Create XML document
    _XMLDocument = [[NSXMLDocument alloc] initWithData:data options:0 error:NULL];
    
    // Reload outline
    [_outlineView reloadData];
}

//--------------------------------------------------------------//
#pragma mark -- NSOutlineView data source --
//--------------------------------------------------------------//

- (int)outlineView:(NSOutlineView*)outlineView 
        numberOfChildrenOfItem:(id)item
{
    // For root
    if (!item) {
        item = [_XMLDocument rootElement];
    }
    
    // Get child count
    return [item childCount];
}

- (id)outlineView:(NSOutlineView*)outlineView 
        child:(int)index 
        ofItem:(id)item
{
    // For root
    if (!item) {
        item = [_XMLDocument rootElement];
    }
    
    // Get child
    return [item childAtIndex:index];
}

- (BOOL)outlineView:(NSOutlineView*)outlineView 
        isItemExpandable:(id)item
{
    return [item childCount] > 0;
}

- (id)outlineView:(NSOutlineView*)outlineView 
        objectValueForTableColumn:(NSTableColumn*)tableColumn 
        byItem:(id)item
{
    // Get identifier
    id  identifier;
    identifier = [tableColumn identifier];
    
    // For name
    if ([identifier isEqual:@"name"]) {
        // Get node kind
        NSXMLNodeKind   kind;
        kind = [item kind];
        switch (kind) {
            // Return string represents kind
            case NSXMLTextKind: {
                return @"#text";
            }
            case NSXMLCommentKind: {
                return @"#comment";
            }
        }
        
        // Get node name
        return [item name];
    }
    
    // For value
    if ([identifier isEqual:@"value"]) {
        // Get node kind
        NSXMLNodeKind   kind;
        kind = [item kind];
        switch (kind) {
            // Return string value
            case NSXMLTextKind:
            case NSXMLCommentKind: {
                return [item stringValue];
            }
        }
    }
    
    return nil;
}

@end
