/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.explorer;

import com.android.ddmlib.FileListingService;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

class FileLabelProvider
implements ILabelProvider,
ITableLabelProvider {
    private Image mFileImage;
    private Image mFolderImage;
    private Image mPackageImage;
    private Image mOtherImage;

    public FileLabelProvider(Image fileImage, Image folderImage, Image packageImage, Image otherImage) {
        this.mFileImage = fileImage;
        this.mFolderImage = folderImage;
        this.mOtherImage = otherImage;
        this.mPackageImage = packageImage != null ? packageImage : fileImage;
    }

    public FileLabelProvider() {
    }

    @Override
    public Image getImage(Object element) {
        return null;
    }

    @Override
    public String getText(Object element) {
        return null;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof FileListingService.FileEntry) {
                FileListingService.FileEntry entry = (FileListingService.FileEntry)element;
                switch (entry.getType()) {
                    case 0: 
                    case 5: {
                        if (entry.isApplicationPackage()) {
                            return this.mPackageImage;
                        }
                        return this.mFileImage;
                    }
                    case 1: 
                    case 2: {
                        return this.mFolderImage;
                    }
                }
            }
            return this.mOtherImage;
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof FileListingService.FileEntry) {
            FileListingService.FileEntry entry = (FileListingService.FileEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getName();
                }
                case 1: {
                    return entry.getSize();
                }
                case 2: {
                    return entry.getDate();
                }
                case 3: {
                    return entry.getTime();
                }
                case 4: {
                    return entry.getPermissions();
                }
                case 5: {
                    return entry.getInfo();
                }
            }
        }
        return null;
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
    }
}

