/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.gradle.eclipse.GradleImport;
import com.android.tools.gradle.eclipse.ImportModule;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImportSummary {
    static final String MSG_HEADER = "ECLIPSE ANDROID PROJECT IMPORT SUMMARY\n======================================\n";
    static final String MSG_MANIFEST = "\nManifest Merging:\n-----------------\nYour project uses libraries that provide manifests, and your Eclipse\nproject did not explicitly turn on manifest merging. In Android Gradle\nprojects, manifests are always merged (meaning that contents from your\nlibraries' manifests will be merged into the app manifest. If you had\nmanually copied contents from library manifests into your app manifest\nyou may need to remove these for the app to build correctly.\n";
    static final String MSG_UNHANDLED = "\nIgnored Files:\n--------------\nThe following files were *not* copied into the new Gradle project; you\nshould evaluate whether these are still needed in your project and if\nso manually move them:\n\n";
    static final String MSG_REPLACED_JARS = "\nReplaced Jars with Dependencies:\n--------------------------------\nThe importer recognized the following .jar files as third party\nlibraries and replaced them with Gradle dependencies instead. This has\nthe advantage that more explicit version information is known, and the\nlibraries can be updated automatically. However, it is possible that\nthe .jar file in your project was of an older version than the\ndependency we picked, which could render the project not compileable.\nYou can disable the jar replacement in the import wizard and try again:\n\n";
    static final String MSG_REPLACED_LIBS = "\nReplaced Libraries with Dependencies:\n-------------------------------------\nThe importer recognized the following library projects as third party\nlibraries and replaced them with Gradle dependencies instead. This has\nthe advantage that more explicit version information is known, and the\nlibraries can be updated automatically. However, it is possible that\nthe source files in your project were of an older version than the\ndependency we picked, which could render the project not compileable.\nYou can disable the library replacement in the import wizard and try\nagain:\n\n";
    static final String MSG_FOOTER = "\nNext Steps:\n-----------\nYou can now build the project. The Gradle project needs network\nconnectivity to download dependencies.\n\nBugs:\n-----\nIf for some reason your project does not build, and you determine that\nit is due to a bug or limitation of the Eclipse to Gradle importer,\nplease file a bug at http://b.android.com with category\nComponent-Tools.\n\n(This import summary is for your information only, and can be deleted\nafter import once you are satisfied with the results.)\n";
    static final String MSG_FOLDER_STRUCTURE = "\nMoved Files:\n------------\nAndroid Gradle projects use a different directory structure than ADT\nEclipse projects. Here's how the projects were restructured:\n\n";
    static final String MSG_MISSING_REPO_1 = "\nMissing Android Support Repository:\n-----------------------------------\nSome useful libraries, such as the Android Support Library, are\ninstalled from a special Maven repository, which should be installed\nvia the SDK manager.\n\nIt looks like this library is missing from your SDK installation at:\n";
    static final String MSG_MISSING_REPO_2 = "\nTo install it, open the SDK manager, and in the Extras category,\nselect \"Android Support Repository\". You may also want to install the\n\"Google Repository\" if you want to use libraries like Google Play\nServices.\n";
    static final String MSG_MISSING_GOOGLE_REPOSITORY_1 = "\nMissing Google Repository:\n--------------------------\nThe Google Play Services library is installed from a special Maven\nRepository, which should be installed via the SDK manager.\n\nIt looks like this library is missing from your SDK installation at:\n";
    static final String MSG_MISSING_GOOGLE_REPOSITORY_2 = "\nTo install it, open the SDK manager, and in the Extras category,\nselect \"Google Repository\".\n";
    static final String MSG_BUILD_TOOLS_VERSION = "\nOld Build Tools:\n----------------\nThe version of the build tools installed with your SDK is old. It\nshould be at least version 19.0.1 to work well with the Gradle build\nsystem. To update it, open the Android SDK Manager, and install the\nhighest available version of Tools > Android SDK Build-tools.\n";
    static final String MSG_GUESSED_VERSIONS = "\nPotentially Missing Dependency:\n-------------------------------\nWhen we replaced the following .jar files with a Gradle dependency, we\ninferred the dependency version number from the filename. This\nspecific version may not actually be available from the repository.\nIf you get a build error stating that the dependency is missing, edit\nthe version number to for example \"+\" to pick up the latest version\ninstead. (This may require you to update your code if the library APIs\nhave changed.)\n\n";
    static final String MSG_USER_HOME_PROGUARD = "\nIgnored Per-User ProGuard Configuration File:\n---------------------------------------------\nThe ProGuard configuration in the imported project pointed to a\nProGuard rule file in the current user's home directory. This is not\nsupported from the Android Gradle build system (which emphasizes\nrepeatable builds). If you want to share ProGuard rules between\nprojects, use relative paths (from the project location) instead.\n";
    static final String MSG_RISKY_PROJECT_LOCATION = "\nRisky Project Location:\n-----------------------\nThe tools *should* handle project locations in any directory. However,\ndue to bugs, placing projects in directories containing spaces in the\npath, or characters like \", ' and &, have had issues. We're working to\neliminate these bugs, but to save yourself headaches you may want to\nmove your project to a location where this is not a problem.\n";
    private final GradleImport mImporter;
    private File mDestDir;
    private boolean mManifestsMayDiffer;
    private Map<String, List<String>> mNotMigrated = Maps.newHashMap();
    private Map<ImportModule, Map<File, File>> mMoved = Maps.newHashMap();
    private Map<File, GradleCoordinate> mJarDependencies = Maps.newHashMap();
    private Map<String, List<GradleCoordinate>> mLibDependencies = Maps.newHashMap();
    private List<String> mGuessedDependencyVersions = Lists.newArrayList();
    private File mLastGuessedJar;
    private List<String> mIgnoredUserHomeProGuardFiles = Lists.newArrayList();
    private boolean mHasRiskyPathChars;
    private boolean mWrapErrorMessages = true;

    ImportSummary(@NonNull GradleImport importer) {
        this.mImporter = importer;
    }

    public void write(@NonNull File file) throws IOException {
        String summary = this.createSummary();
        assert (file.getParentFile().exists());
        Files.write((CharSequence)summary, (File)file, (Charset)Charsets.UTF_8);
    }

    public void setDestDir(File destDir) {
        this.mDestDir = destDir;
        this.mHasRiskyPathChars = false;
        String path = destDir.getPath();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (!ImportSummary.isRiskyPathChar(c)) continue;
            this.mHasRiskyPathChars = true;
        }
    }

    void setWrapErrorMessages(boolean wrap) {
        this.mWrapErrorMessages = wrap;
    }

    private static boolean isRiskyPathChar(char c) {
        return c == ' ' || c == '\'' || c == '\"' || c == '&';
    }

    public void reportManifestsMayDiffer() {
        this.mManifestsMayDiffer = true;
    }

    public void reportReplacedJar(@NonNull File jar, @NonNull GradleCoordinate dependency) {
        this.mJarDependencies.put(jar, dependency);
        if (jar.equals(this.mLastGuessedJar)) {
            boolean replaced = this.mGuessedDependencyVersions.remove(jar.getName());
            if (replaced) {
                this.mGuessedDependencyVersions.add(jar.getName() + " => version " + dependency.getFullRevision() + " in " + dependency.toString());
            }
            this.mLastGuessedJar = null;
        }
    }

    public void reportReplacedLib(@NonNull String module, @NonNull List<GradleCoordinate> dependencies) {
        this.mLibDependencies.put(module, dependencies);
    }

    public void reportGuessedVersion(@NonNull File jar) {
        this.mGuessedDependencyVersions.add(jar.getName());
        this.mLastGuessedJar = jar;
    }

    public void reportIgnoredUserHomeProGuardFile(@NonNull String relativePath) {
        this.mIgnoredUserHomeProGuardFiles.add(relativePath);
    }

    public void reportMoved(@NonNull ImportModule module, @NonNull File from, @NonNull File to) {
        Map<File, File> map = this.mMoved.get(module);
        if (map == null) {
            map = new LinkedHashMap<File, File>();
            this.mMoved.put(module, map);
        }
        map.put(from, to);
    }

    public void reportIgnored(@NonNull String module, @NonNull String path) {
        ArrayList list = this.mNotMigrated.get(module);
        if (list == null) {
            list = Lists.newArrayList();
            this.mNotMigrated.put(module, list);
        }
        list.add(path);
    }

    @NonNull
    public String createSummary() {
        ArrayList modules;
        StringBuilder sb = new StringBuilder(2000);
        sb.append(MSG_HEADER);
        ArrayList problems = Lists.newArrayList();
        problems.addAll(this.mImporter.getErrors());
        problems.addAll(this.mImporter.getWarnings());
        if (!problems.isEmpty()) {
            sb.append("\n");
            for (String warning : problems) {
                sb.append(" * ");
                if (this.mWrapErrorMessages) {
                    sb.append(SdkUtils.wrap((String)warning, (int)80, (String)"   "));
                } else {
                    sb.append(warning);
                }
                sb.append("\n");
            }
        }
        if (this.mHasRiskyPathChars) {
            sb.append(MSG_RISKY_PROJECT_LOCATION);
            String path = this.mDestDir.getPath();
            sb.append(path).append("\n");
            int n = path.length();
            for (int i = 0; i < n; ++i) {
                char c = path.charAt(i);
                sb.append(ImportSummary.isRiskyPathChar(c) ? (char)'-' : ' ');
            }
            sb.append("\n");
        }
        if (this.mManifestsMayDiffer) {
            sb.append(MSG_MANIFEST);
        }
        if (!this.mNotMigrated.isEmpty()) {
            sb.append(MSG_UNHANDLED);
            modules = Lists.newArrayList(this.mNotMigrated.keySet());
            Collections.sort(modules);
            for (String module : modules) {
                if (modules.size() > 1) {
                    sb.append("From ").append(module).append(":\n");
                }
                ArrayList sorted = new ArrayList(this.mNotMigrated.get(module));
                Collections.sort(sorted);
                for (String path : sorted) {
                    sb.append("* ").append(path).append("\n");
                }
            }
        }
        if (!this.mJarDependencies.isEmpty()) {
            sb.append(MSG_REPLACED_JARS);
            ArrayList files = Lists.newArrayList(this.mJarDependencies.keySet());
            Collections.sort(files);
            for (File file : files) {
                String jar = file.getName();
                GradleCoordinate dependency = this.mJarDependencies.get(file);
                sb.append(jar).append(" => ").append(dependency).append("\n");
            }
        }
        if (!this.mGuessedDependencyVersions.isEmpty()) {
            sb.append(MSG_GUESSED_VERSIONS);
            Collections.sort(this.mGuessedDependencyVersions);
            for (String replaced : this.mGuessedDependencyVersions) {
                sb.append(replaced).append("\n");
            }
        }
        if (!this.mLibDependencies.isEmpty()) {
            sb.append(MSG_REPLACED_LIBS);
            modules = Lists.newArrayList(this.mLibDependencies.keySet());
            Collections.sort(modules);
            for (String module : modules) {
                List<GradleCoordinate> dependencies = this.mLibDependencies.get(module);
                if (dependencies.size() == 1) {
                    sb.append(module).append(" => ").append(dependencies).append("\n");
                    continue;
                }
                sb.append(module).append(" =>\n");
                for (GradleCoordinate dependency : dependencies) {
                    sb.append("    ").append(dependency).append("\n");
                }
            }
        }
        if (!this.mMoved.isEmpty()) {
            sb.append(MSG_FOLDER_STRUCTURE);
            modules = Lists.newArrayList(this.mMoved.keySet());
            Collections.sort(modules);
            for (ImportModule module : modules) {
                if (modules.size() > 1) {
                    sb.append("In ").append(module.getOriginalName()).append(":\n");
                }
                Map<File, File> map = this.mMoved.get(module);
                ArrayList<File> sorted = new ArrayList<File>(map.keySet());
                Collections.sort(sorted);
                for (File from : sorted) {
                    sb.append("* ");
                    File to = map.get(from);
                    assert (to != null) : from;
                    File fromRelative = null;
                    File toRelative = null;
                    try {
                        fromRelative = module.computeProjectRelativePath(from);
                        if (this.mDestDir != null) {
                            toRelative = GradleImport.computeRelativePath(this.mDestDir.getCanonicalFile(), to);
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (fromRelative == null) {
                        fromRelative = from;
                    }
                    if (toRelative == null) {
                        toRelative = to;
                    }
                    sb.append(fromRelative.getPath());
                    if (from.isDirectory()) {
                        sb.append(File.separator);
                    }
                    sb.append(" => ");
                    sb.append(toRelative.getPath());
                    if (to.isDirectory()) {
                        sb.append(File.separator);
                    }
                    sb.append("\n");
                }
            }
        }
        if (this.mImporter.needSupportRepository() && this.mImporter.isMissingSupportRepository()) {
            sb.append(MSG_MISSING_REPO_1);
            sb.append(this.mImporter.getSdkLocation()).append("\n");
            sb.append(MSG_MISSING_REPO_2);
        }
        if (this.mImporter.needGoogleRepository() && this.mImporter.isMissingGoogleRepository()) {
            sb.append(MSG_MISSING_GOOGLE_REPOSITORY_1);
            sb.append(this.mImporter.getSdkLocation()).append("\n");
            sb.append(MSG_MISSING_GOOGLE_REPOSITORY_2);
        }
        if (FullRevision.parseRevision(this.mImporter.getBuildToolsVersion()).getMajor() < 19) {
            sb.append(MSG_BUILD_TOOLS_VERSION);
        }
        if (!this.mIgnoredUserHomeProGuardFiles.isEmpty()) {
            sb.append(MSG_USER_HOME_PROGUARD);
            Collections.sort(this.mIgnoredUserHomeProGuardFiles);
            for (String path : this.mIgnoredUserHomeProGuardFiles) {
                sb.append(path).append("\n");
            }
        }
        sb.append(MSG_FOOTER);
        return sb.toString().replace("\n", GradleImport.NL);
    }
}

