/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.device.HvDeviceFactory;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.device.WindowUpdater;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.hierarchyviewerlib.models.Window;
import com.android.hierarchyviewerlib.ui.CaptureDisplay;
import com.android.hierarchyviewerlib.ui.TreeView;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import com.android.hierarchyviewerlib.ui.util.PsdFile;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class HierarchyViewerDirector
implements AndroidDebugBridge.IDeviceChangeListener,
WindowUpdater.IWindowChangeListener {
    private static final boolean sIsUsingDdmProtocol;
    protected static HierarchyViewerDirector sDirector;
    public static final String TAG = "hierarchyviewer";
    private int mPixelPerfectRefreshesInProgress = 0;
    private Timer mPixelPerfectRefreshTimer = new Timer();
    private boolean mAutoRefresh = false;
    public static final int DEFAULT_PIXEL_PERFECT_AUTOREFRESH_INTERVAL = 5;
    private int mPixelPerfectAutoRefreshInterval = 5;
    private PixelPerfectAutoRefreshTask mCurrentAutoRefreshTask;
    private String mFilterText = "";
    private static final Object mDevicesLock;
    private Map<IDevice, IHvDevice> mDevices = new HashMap<IDevice, IHvDevice>(10);

    public static boolean isUsingDdmProtocol() {
        return sIsUsingDdmProtocol;
    }

    public void terminate() {
        WindowUpdater.terminate();
        this.mPixelPerfectRefreshTimer.cancel();
    }

    public abstract String getAdbLocation();

    public static HierarchyViewerDirector getDirector() {
        return sDirector;
    }

    public void acquireBridge(AndroidDebugBridge bridge) {
        DeviceBridge.acquireBridge(bridge);
    }

    public void initDebugBridge() {
        DeviceBridge.initDebugBridge(this.getAdbLocation());
    }

    public void stopDebugBridge() {
        DeviceBridge.terminate();
    }

    public void populateDeviceSelectionModel() {
        IDevice[] devices;
        for (IDevice device : devices = DeviceBridge.getDevices()) {
            this.deviceConnected(device);
        }
    }

    public void startListenForDevices() {
        DeviceBridge.startListenForDevices(this);
    }

    public void stopListenForDevices() {
        DeviceBridge.stopListenForDevices(this);
    }

    public abstract void executeInBackground(String var1, Runnable var2);

    @Override
    public void deviceConnected(final IDevice device) {
        this.executeInBackground("Connecting device", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IHvDevice hvDevice;
                if (!device.isOnline()) {
                    return;
                }
                Object object = mDevicesLock;
                synchronized (object) {
                    hvDevice = (IHvDevice)HierarchyViewerDirector.this.mDevices.get(device);
                    if (hvDevice == null) {
                        hvDevice = HvDeviceFactory.create(device);
                        hvDevice.initializeViewDebug();
                        hvDevice.addWindowChangeListener(HierarchyViewerDirector.getDirector());
                        HierarchyViewerDirector.this.mDevices.put(device, hvDevice);
                    } else {
                        hvDevice.initializeViewDebug();
                    }
                }
                DeviceSelectionModel.getModel().addDevice(hvDevice);
                HierarchyViewerDirector.this.focusChanged(device);
            }
        });
    }

    @Override
    public void deviceDisconnected(final IDevice device) {
        this.executeInBackground("Disconnecting device", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Window treeViewWindow;
                IHvDevice hvDevice;
                Object object = mDevicesLock;
                synchronized (object) {
                    hvDevice = (IHvDevice)HierarchyViewerDirector.this.mDevices.get(device);
                    if (hvDevice != null) {
                        HierarchyViewerDirector.this.mDevices.remove(device);
                    }
                }
                if (hvDevice == null) {
                    return;
                }
                hvDevice.terminateViewDebug();
                hvDevice.removeWindowChangeListener(HierarchyViewerDirector.getDirector());
                DeviceSelectionModel.getModel().removeDevice(hvDevice);
                if (PixelPerfectModel.getModel().getDevice() == device) {
                    PixelPerfectModel.getModel().setData(null, null, null);
                }
                if ((treeViewWindow = TreeViewModel.getModel().getWindow()) != null && treeViewWindow.getDevice() == device) {
                    TreeViewModel.getModel().setData(null, null);
                    HierarchyViewerDirector.this.mFilterText = "";
                }
            }
        });
    }

    @Override
    public void windowsChanged(final IDevice device) {
        this.executeInBackground("Refreshing windows", new Runnable(){

            @Override
            public void run() {
                IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(device);
                hvDevice.reloadWindows();
                DeviceSelectionModel.getModel().updateDevice(hvDevice);
            }
        });
    }

    @Override
    public void focusChanged(final IDevice device) {
        this.executeInBackground("Updating focus", new Runnable(){

            @Override
            public void run() {
                IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(device);
                int focusedWindow = hvDevice.getFocusedWindow();
                DeviceSelectionModel.getModel().updateFocusedWindow(hvDevice, focusedWindow);
            }
        });
    }

    @Override
    public void deviceChanged(IDevice device, int changeMask) {
        if ((changeMask & 1) != 0 && device.isOnline()) {
            this.deviceConnected(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPixelPerfect() {
        final IDevice device = PixelPerfectModel.getModel().getDevice();
        if (device != null) {
            boolean proceed = false;
            HierarchyViewerDirector hierarchyViewerDirector = this;
            synchronized (hierarchyViewerDirector) {
                if (this.mPixelPerfectRefreshesInProgress <= 1) {
                    proceed = true;
                    ++this.mPixelPerfectRefreshesInProgress;
                }
            }
            if (proceed) {
                this.executeInBackground("Refreshing pixel perfect screenshot", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Image screenshotImage = HierarchyViewerDirector.this.getScreenshotImage(HierarchyViewerDirector.this.getHvDevice(device));
                        if (screenshotImage != null) {
                            PixelPerfectModel.getModel().setImage(screenshotImage);
                        }
                        HierarchyViewerDirector hierarchyViewerDirector = HierarchyViewerDirector.this;
                        synchronized (hierarchyViewerDirector) {
                            HierarchyViewerDirector.this.mPixelPerfectRefreshesInProgress--;
                        }
                    }
                });
            }
        }
    }

    public void refreshPixelPerfectTree() {
        final IDevice device = PixelPerfectModel.getModel().getDevice();
        if (device != null) {
            this.executeInBackground("Refreshing pixel perfect tree", new Runnable(){

                @Override
                public void run() {
                    IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(device);
                    ViewNode viewNode = hvDevice.loadWindowData(Window.getFocusedWindow(hvDevice));
                    if (viewNode != null) {
                        PixelPerfectModel.getModel().setTree(viewNode);
                    }
                }
            });
        }
    }

    public void loadPixelPerfectData(final IHvDevice hvDevice) {
        this.executeInBackground("Loading pixel perfect data", new Runnable(){

            @Override
            public void run() {
                ViewNode viewNode;
                Image screenshotImage = HierarchyViewerDirector.this.getScreenshotImage(hvDevice);
                if (screenshotImage != null && (viewNode = hvDevice.loadWindowData(Window.getFocusedWindow(hvDevice))) != null) {
                    PixelPerfectModel.getModel().setData(hvDevice.getDevice(), screenshotImage, viewNode);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHvDevice getHvDevice(IDevice device) {
        Object object = mDevicesLock;
        synchronized (object) {
            return this.mDevices.get(device);
        }
    }

    private Image getScreenshotImage(IHvDevice hvDevice) {
        return hvDevice == null ? null : hvDevice.getScreenshotImage();
    }

    public void loadViewTreeData(final Window window) {
        this.executeInBackground("Loading view hierarchy", new Runnable(){

            @Override
            public void run() {
                HierarchyViewerDirector.this.mFilterText = "";
                IHvDevice hvDevice = window.getHvDevice();
                ViewNode viewNode = hvDevice.loadWindowData(window);
                if (viewNode != null) {
                    viewNode.setViewCount();
                    TreeViewModel.getModel().setData(window, viewNode);
                }
            }
        });
    }

    public void loadOverlay(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.png;*.gif;*.bmp"});
                fileDialog.setFilterNames(new String[]{"Image (*.jpg, *.jpeg, *.png, *.gif, *.bmp)"});
                fileDialog.setText("Choose an overlay image");
                String fileName = fileDialog.open();
                if (fileName != null) {
                    try {
                        Image image = new Image((Device)Display.getDefault(), fileName);
                        PixelPerfectModel.getModel().setOverlayImage(image);
                    }
                    catch (SWTException e) {
                        Log.e(HierarchyViewerDirector.TAG, "Unable to load image from " + fileName);
                    }
                }
            }
        });
    }

    public void showCapture(final Shell shell, final ViewNode viewNode) {
        this.executeInBackground("Capturing node", new Runnable(){

            @Override
            public void run() {
                final Image image = HierarchyViewerDirector.this.loadCapture(viewNode);
                if (image != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CaptureDisplay.show(shell, viewNode, image);
                        }
                    });
                }
            }
        });
    }

    public Image loadCapture(ViewNode viewNode) {
        IHvDevice hvDevice = viewNode.window.getHvDevice();
        Image image = hvDevice.loadCapture(viewNode.window, viewNode);
        if (image != null) {
            viewNode.image = image;
            TreeViewModel.getModel().notifySelectionChanged();
        }
        return image;
    }

    public void loadCaptureInBackground(final ViewNode viewNode) {
        this.executeInBackground("Capturing node", new Runnable(){

            @Override
            public void run() {
                HierarchyViewerDirector.this.loadCapture(viewNode);
            }
        });
    }

    public void showCapture(Shell shell) {
        DrawableViewNode viewNode = TreeViewModel.getModel().getSelection();
        if (viewNode != null) {
            this.showCapture(shell, viewNode.viewNode);
        }
    }

    public void refreshWindows() {
        this.executeInBackground("Refreshing windows", new Runnable(){

            @Override
            public void run() {
                int i;
                IHvDevice[] hvDevicesA = DeviceSelectionModel.getModel().getDevices();
                IDevice[] devicesA = new IDevice[hvDevicesA.length];
                for (int i2 = 0; i2 < hvDevicesA.length; ++i2) {
                    devicesA[i2] = hvDevicesA[i2].getDevice();
                }
                IDevice[] devicesB = DeviceBridge.getDevices();
                HashSet<IDevice> deviceSet = new HashSet<IDevice>();
                for (i = 0; i < devicesB.length; ++i) {
                    deviceSet.add(devicesB[i]);
                }
                for (i = 0; i < devicesA.length; ++i) {
                    if (deviceSet.contains(devicesA[i])) {
                        HierarchyViewerDirector.this.windowsChanged(devicesA[i]);
                        deviceSet.remove(devicesA[i]);
                        continue;
                    }
                    HierarchyViewerDirector.this.deviceDisconnected(devicesA[i]);
                }
                for (IDevice device : deviceSet) {
                    HierarchyViewerDirector.this.deviceConnected(device);
                }
            }
        });
    }

    public void loadViewHierarchy() {
        Window window = DeviceSelectionModel.getModel().getSelectedWindow();
        if (window != null) {
            this.loadViewTreeData(window);
        }
    }

    public void inspectScreenshot() {
        IHvDevice device = DeviceSelectionModel.getModel().getSelectedDevice();
        if (device != null) {
            this.loadPixelPerfectData(device);
        }
    }

    public void saveTreeView(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final DrawableViewNode viewNode = TreeViewModel.getModel().getTree();
                if (viewNode != null) {
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.png"});
                    fileDialog.setFilterNames(new String[]{"Portable Network Graphics File (*.png)"});
                    fileDialog.setText("Choose where to save the tree image");
                    final String fileName = fileDialog.open();
                    if (fileName != null) {
                        HierarchyViewerDirector.this.executeInBackground("Saving tree view", new Runnable(){

                            @Override
                            public void run() {
                                Image image = TreeView.paintToImage(viewNode);
                                ImageLoader imageLoader = new ImageLoader();
                                imageLoader.data = new ImageData[]{image.getImageData()};
                                String extensionedFileName = fileName;
                                if (!extensionedFileName.toLowerCase().endsWith(".png")) {
                                    extensionedFileName = extensionedFileName + ".png";
                                }
                                try {
                                    imageLoader.save(extensionedFileName, 5);
                                }
                                catch (SWTException e) {
                                    Log.e(HierarchyViewerDirector.TAG, "Unable to save tree view as a PNG image at " + fileName);
                                }
                                image.dispose();
                            }
                        });
                    }
                }
            }
        });
    }

    public void savePixelPerfect(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Image untouchableImage = PixelPerfectModel.getModel().getImage();
                if (untouchableImage != null) {
                    final ImageData imageData = untouchableImage.getImageData();
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.png"});
                    fileDialog.setFilterNames(new String[]{"Portable Network Graphics File (*.png)"});
                    fileDialog.setText("Choose where to save the screenshot");
                    final String fileName = fileDialog.open();
                    if (fileName != null) {
                        HierarchyViewerDirector.this.executeInBackground("Saving pixel perfect", new Runnable(){

                            @Override
                            public void run() {
                                ImageLoader imageLoader = new ImageLoader();
                                imageLoader.data = new ImageData[]{imageData};
                                String extensionedFileName = fileName;
                                if (!extensionedFileName.toLowerCase().endsWith(".png")) {
                                    extensionedFileName = extensionedFileName + ".png";
                                }
                                try {
                                    imageLoader.save(extensionedFileName, 5);
                                }
                                catch (SWTException e) {
                                    Log.e(HierarchyViewerDirector.TAG, "Unable to save tree view as a PNG image at " + fileName);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void capturePSD(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final Window window = TreeViewModel.getModel().getWindow();
                if (window != null) {
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.psd"});
                    fileDialog.setFilterNames(new String[]{"Photoshop Document (*.psd)"});
                    fileDialog.setText("Choose where to save the window layers");
                    final String fileName = fileDialog.open();
                    if (fileName != null) {
                        HierarchyViewerDirector.this.executeInBackground("Saving window layers", new Runnable(){

                            @Override
                            public void run() {
                                IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(window.getDevice());
                                PsdFile psdFile = hvDevice.captureLayers(window);
                                if (psdFile != null) {
                                    String extensionedFileName = fileName;
                                    if (!extensionedFileName.toLowerCase().endsWith(".psd")) {
                                        extensionedFileName = extensionedFileName + ".psd";
                                    }
                                    try {
                                        psdFile.write(new FileOutputStream(extensionedFileName));
                                    }
                                    catch (FileNotFoundException e) {
                                        Log.e(HierarchyViewerDirector.TAG, "Unable to write to file " + fileName);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void reloadViewHierarchy() {
        Window window = TreeViewModel.getModel().getWindow();
        if (window != null) {
            this.loadViewTreeData(window);
        }
    }

    public void invalidateCurrentNode() {
        final DrawableViewNode selectedNode = TreeViewModel.getModel().getSelection();
        if (selectedNode != null) {
            this.executeInBackground("Invalidating view", new Runnable(){

                @Override
                public void run() {
                    IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(selectedNode.viewNode.window.getDevice());
                    hvDevice.invalidateView(selectedNode.viewNode);
                }
            });
        }
    }

    public void relayoutCurrentNode() {
        final DrawableViewNode selectedNode = TreeViewModel.getModel().getSelection();
        if (selectedNode != null) {
            this.executeInBackground("Request layout", new Runnable(){

                @Override
                public void run() {
                    IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(selectedNode.viewNode.window.getDevice());
                    hvDevice.requestLayout(selectedNode.viewNode);
                }
            });
        }
    }

    public void dumpDisplayListForCurrentNode() {
        final DrawableViewNode selectedNode = TreeViewModel.getModel().getSelection();
        if (selectedNode != null) {
            this.executeInBackground("Dump displaylist", new Runnable(){

                @Override
                public void run() {
                    IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(selectedNode.viewNode.window.getDevice());
                    hvDevice.outputDisplayList(selectedNode.viewNode);
                }
            });
        }
    }

    public void profileCurrentNode() {
        final DrawableViewNode selectedNode = TreeViewModel.getModel().getSelection();
        if (selectedNode != null) {
            this.executeInBackground("Profile Node", new Runnable(){

                @Override
                public void run() {
                    IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(selectedNode.viewNode.window.getDevice());
                    hvDevice.loadProfileData(selectedNode.viewNode.window, selectedNode.viewNode);
                    TreeViewModel.getModel().notifySelectionChanged();
                }
            });
        }
    }

    public void invokeMethodOnSelectedView(final String method, final List<Object> args) {
        final DrawableViewNode selectedNode = TreeViewModel.getModel().getSelection();
        if (selectedNode != null) {
            this.executeInBackground("Invoke View Method", new Runnable(){

                @Override
                public void run() {
                    IHvDevice hvDevice = HierarchyViewerDirector.this.getHvDevice(selectedNode.viewNode.window.getDevice());
                    hvDevice.invokeViewMethod(selectedNode.viewNode.window, selectedNode.viewNode, method, args);
                }
            });
        }
    }

    public void loadAllViews() {
        this.executeInBackground("Loading all views", new Runnable(){

            @Override
            public void run() {
                DrawableViewNode tree = TreeViewModel.getModel().getTree();
                if (tree != null) {
                    HierarchyViewerDirector.this.loadViewRecursive(tree.viewNode);
                    TreeViewModel.getModel().notifySelectionChanged();
                }
            }
        });
    }

    private void loadViewRecursive(ViewNode viewNode) {
        IHvDevice hvDevice = this.getHvDevice(viewNode.window.getDevice());
        Image image = hvDevice.loadCapture(viewNode.window, viewNode);
        if (image == null) {
            return;
        }
        viewNode.image = image;
        int N = viewNode.children.size();
        for (int i = 0; i < N; ++i) {
            this.loadViewRecursive(viewNode.children.get(i));
        }
    }

    public void filterNodes(String filterText) {
        this.mFilterText = filterText;
        DrawableViewNode tree = TreeViewModel.getModel().getTree();
        if (tree != null) {
            tree.viewNode.filter(filterText);
            TreeViewModel.getModel().notifySelectionChanged();
        }
    }

    public String getFilterText() {
        return this.mFilterText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelPerfectAutoRefresh(boolean value) {
        Timer timer = this.mPixelPerfectRefreshTimer;
        synchronized (timer) {
            if (value == this.mAutoRefresh) {
                return;
            }
            this.mAutoRefresh = value;
            if (this.mAutoRefresh) {
                this.mCurrentAutoRefreshTask = new PixelPerfectAutoRefreshTask();
                this.mPixelPerfectRefreshTimer.schedule((TimerTask)this.mCurrentAutoRefreshTask, this.mPixelPerfectAutoRefreshInterval * 1000, (long)(this.mPixelPerfectAutoRefreshInterval * 1000));
            } else {
                this.mCurrentAutoRefreshTask.cancel();
                this.mCurrentAutoRefreshTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelPerfectAutoRefreshInterval(int value) {
        Timer timer = this.mPixelPerfectRefreshTimer;
        synchronized (timer) {
            if (this.mPixelPerfectAutoRefreshInterval == value) {
                return;
            }
            this.mPixelPerfectAutoRefreshInterval = value;
            if (this.mAutoRefresh) {
                this.mCurrentAutoRefreshTask.cancel();
                long timeLeft = Math.max(0L, (long)(this.mPixelPerfectAutoRefreshInterval * 1000) - (System.currentTimeMillis() - this.mCurrentAutoRefreshTask.scheduledExecutionTime()));
                this.mCurrentAutoRefreshTask = new PixelPerfectAutoRefreshTask();
                this.mPixelPerfectRefreshTimer.schedule((TimerTask)this.mCurrentAutoRefreshTask, timeLeft, (long)(this.mPixelPerfectAutoRefreshInterval * 1000));
            }
        }
    }

    public int getPixelPerfectAutoRefreshInverval() {
        return this.mPixelPerfectAutoRefreshInterval;
    }

    static {
        String sHvProtoEnvVar = System.getenv("ANDROID_HVPROTO");
        sIsUsingDdmProtocol = "ddm".equalsIgnoreCase(sHvProtoEnvVar);
        mDevicesLock = new Object();
    }

    private static class PixelPerfectAutoRefreshTask
    extends TimerTask {
        private PixelPerfectAutoRefreshTask() {
        }

        @Override
        public void run() {
            HierarchyViewerDirector.getDirector().refreshPixelPerfect();
        }
    }
}

