/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.DdmViewDebugDevice;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.device.ViewServerDevice;

public class HvDeviceFactory {
    public static IHvDevice create(IDevice device) {
        if (!HierarchyViewerDirector.isUsingDdmProtocol()) {
            return new ViewServerDevice(device);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        boolean ddmViewHierarchy = false;
        for (Client c : device.getClients()) {
            ClientData cd = c.getClientData();
            if (cd == null || !cd.hasFeature("view-hierarchy")) continue;
            ddmViewHierarchy = true;
            break;
        }
        return ddmViewHierarchy ? new DdmViewDebugDevice(device) : new ViewServerDevice(device);
    }
}

