/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Accessible {
    static NSString[] baseAttributes = new NSString[]{OS.NSAccessibilityRoleAttribute, OS.NSAccessibilityRoleDescriptionAttribute, OS.NSAccessibilityHelpAttribute, OS.NSAccessibilityFocusedAttribute, OS.NSAccessibilityParentAttribute, OS.NSAccessibilityChildrenAttribute, OS.NSAccessibilityPositionAttribute, OS.NSAccessibilitySizeAttribute, OS.NSAccessibilityWindowAttribute, OS.NSAccessibilityTopLevelUIElementAttribute};
    static NSString[] baseTextAttributes = new NSString[]{OS.NSAccessibilityNumberOfCharactersAttribute, OS.NSAccessibilitySelectedTextAttribute, OS.NSAccessibilitySelectedTextRangeAttribute, OS.NSAccessibilityInsertionPointLineNumberAttribute, OS.NSAccessibilitySelectedTextRangesAttribute, OS.NSAccessibilityVisibleCharacterRangeAttribute, OS.NSAccessibilityValueAttribute};
    static NSString[] baseParameterizedAttributes = new NSString[]{OS.NSAccessibilityStringForRangeParameterizedAttribute, OS.NSAccessibilityRangeForLineParameterizedAttribute};
    NSMutableArray attributeNames = null;
    NSMutableArray parameterizedAttributeNames = null;
    NSMutableArray actionNames = null;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Control control;
    Map children = new HashMap();

    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.addElement(accessibleTextListener);
    }

    public id internal_accessibilityActionDescription(NSString nSString, int n) {
        return NSString.stringWith("");
    }

    public NSArray internal_accessibilityActionNames(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        if (n == -1 && this.actionNames != null) {
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(5L);
        switch (accessibleControlEvent.detail) {
            case 37: 
            case 43: 
            case 44: 
            case 45: {
                nSMutableArray.addObject(OS.NSAccessibilityPressAction);
            }
        }
        switch (accessibleControlEvent.detail) {
            case 46: {
                nSMutableArray.addObject(OS.NSAccessibilityConfirmAction);
            }
        }
        if (n == -1) {
            this.actionNames = nSMutableArray;
            this.actionNames.retain();
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        return nSMutableArray;
    }

    public NSArray internal_accessibilityAttributeNames(int n) {
        String string;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail == -1) {
            return null;
        }
        if (n == -1 && this.attributeNames != null) {
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(baseAttributes.length);
        int n3 = 0;
        while (n3 < baseAttributes.length) {
            if (!nSMutableArray.containsObject(baseAttributes[n3])) {
                nSMutableArray.addObject(baseAttributes[n3]);
            }
            ++n3;
        }
        if (this.accessibleTextListeners.size() > 0) {
            n3 = 0;
            while (n3 < baseTextAttributes.length) {
                if (!nSMutableArray.containsObject(baseTextAttributes[n3])) {
                    nSMutableArray.addObject(baseTextAttributes[n3]);
                }
                ++n3;
            }
        }
        switch (accessibleControlEvent.detail) {
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 60: {
                nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
            }
        }
        switch (accessibleControlEvent.detail) {
            case 37: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                nSMutableArray.addObject(OS.NSAccessibilityEnabledAttribute);
            }
        }
        switch (accessibleControlEvent.detail) {
            case 37: 
            case 43: 
            case 44: 
            case 45: {
                nSMutableArray.addObject(OS.NSAccessibilityTitleAttribute);
            }
        }
        if (accessibleControlEvent.detail == 46) {
            nSMutableArray.addObject(OS.NSAccessibilityExpandedAttribute);
        }
        if (accessibleControlEvent.detail == 60) {
            nSMutableArray.addObject(OS.NSAccessibilityContentsAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityTabsAttribute);
        }
        if (accessibleControlEvent.detail != -1 && (string = this.roleToOs(accessibleControlEvent.detail)).indexOf(58) == -1) {
            nSMutableArray.removeObject(OS.NSAccessibilitySubroleAttribute);
        }
        if (n != -1) {
            nSMutableArray.removeObject(OS.NSAccessibilityChildrenAttribute);
        }
        if (n == -1) {
            this.attributeNames = nSMutableArray;
            this.attributeNames.retain();
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        return nSMutableArray;
    }

    public id internal_accessibilityAttributeValue(NSString nSString, int n) {
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
            return this.getRoleAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySubroleAttribute)) {
            return this.getSubroleAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            return this.getRoleDescriptionAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityExpandedAttribute)) {
            return this.getExpandedAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
            return this.getHelpAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
            return this.getTitleAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            return this.getValueAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return this.getEnabledAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            return this.getFocusedAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityParentAttribute)) {
            return this.getParentAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            return this.getChildrenAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityContentsAttribute)) {
            return this.getChildrenAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTabsAttribute)) {
            return this.getTabsAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityWindowAttribute)) {
            return this.getWindowAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTopLevelUIElementAttribute)) {
            return this.getTopLevelUIElementAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityPositionAttribute)) {
            return this.getPositionAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySizeAttribute)) {
            return this.getSizeAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return this.getDescriptionAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityNumberOfCharactersAttribute)) {
            return this.getNumberOfCharactersAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return this.getSelectedTextAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            return this.getSelectedTextRangeAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityInsertionPointLineNumberAttribute)) {
            return this.getInsertionPointLineNumberAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySelectedTextRangesAttribute)) {
            return this.getSelectedTextRangesAttribute(n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            return this.getVisibleCharacterRangeAttribute(n);
        }
        return null;
    }

    public id internal_accessibilityAttributeValue_forParameter(NSString nSString, id id2, int n) {
        if (nSString.isEqualToString(OS.NSAccessibilityStringForRangeParameterizedAttribute)) {
            return this.getStringForRangeAttribute(id2, n);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRangeForLineParameterizedAttribute)) {
            return this.getRangeForLineParameterizedAttribute(id2, n);
        }
        return null;
    }

    public id internal_accessibilityFocusedUIElement(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        accessibleControlEvent.accessible = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getFocus(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.childID == -3) {
            return null;
        }
        if (accessibleControlEvent.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(accessibleControlEvent.accessible.control.view.id));
        }
        if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent.childID).id));
    }

    public id internal_accessibilityHitTest(NSPoint nSPoint, int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.x = (int)nSPoint.x;
        Monitor monitor = Display.getCurrent().getPrimaryMonitor();
        accessibleControlEvent.y = (int)((double)monitor.getBounds().height - nSPoint.y);
        accessibleControlEvent.childID = -3;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.childID == -3) {
            return null;
        }
        if (accessibleControlEvent.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(accessibleControlEvent.accessible.control.view.id));
        }
        if (accessibleControlEvent.childID == -1 || accessibleControlEvent.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent.childID).id));
    }

    public boolean internal_accessibilityIsIgnored(int n) {
        return false;
    }

    public NSArray internal_accessibilityParameterizedAttributeNames(int n) {
        if (n == -1 && this.parameterizedAttributeNames != null) {
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(4L);
        if (this.accessibleTextListeners.size() > 0) {
            int n2 = 0;
            while (n2 < baseParameterizedAttributes.length) {
                if (!nSMutableArray.containsObject(baseParameterizedAttributes[n2])) {
                    nSMutableArray.addObject(baseParameterizedAttributes[n2]);
                }
                ++n2;
            }
        }
        if (n == -1) {
            this.parameterizedAttributeNames = nSMutableArray;
            this.parameterizedAttributeNames.retain();
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        return nSMutableArray;
    }

    public void internal_accessibilityPerformAction(NSString nSString, int n) {
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.actionNames != null) {
            this.actionNames.release();
        }
        this.actionNames = null;
        if (this.attributeNames != null) {
            this.attributeNames.release();
        }
        this.attributeNames = null;
        if (this.parameterizedAttributeNames != null) {
            this.parameterizedAttributeNames.release();
        }
        this.parameterizedAttributeNames = null;
        Collection collection = this.children.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SWTAccessibleDelegate sWTAccessibleDelegate = (SWTAccessibleDelegate)iterator.next();
            sWTAccessibleDelegate.internal_dispose_SWTAccessibleDelegate();
        }
        this.children.clear();
    }

    id getExpandedAttribute(int n) {
        return NSNumber.numberWithBool(false);
    }

    id getHelpAttribute(int n) {
        NSString nSString = null;
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = n;
        int n2 = 0;
        while (n2 < this.accessibleListeners.size()) {
            AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n2);
            accessibleListener.getHelp(accessibleEvent);
            ++n2;
        }
        if (accessibleEvent.result != null) {
            nSString = NSString.stringWith(accessibleEvent.result);
        }
        return nSString;
    }

    NSString getRoleAttribute(int n) {
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail != -1) {
            String string = this.roleToOs(accessibleControlEvent.detail);
            int n3 = string.indexOf(58);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            nSString = NSString.stringWith(string);
        }
        return nSString;
    }

    id getSubroleAttribute(int n) {
        String string;
        int n2;
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n3;
        }
        if (accessibleControlEvent.detail != -1 && (n2 = (string = this.roleToOs(accessibleControlEvent.detail)).indexOf(58)) != -1) {
            string = string.substring(n2 + 1);
            nSString = NSString.stringWith(string);
        }
        return nSString;
    }

    id getRoleDescriptionAttribute(int n) {
        Object object;
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            object.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail != -1) {
            String string = this.roleToOs(accessibleControlEvent.detail);
            object = null;
            int n3 = string.indexOf(58);
            if (n3 != -1) {
                object = string.substring(n3 + 1);
                string = string.substring(0, n3);
            }
            NSString nSString2 = NSString.stringWith(string);
            NSString nSString3 = null;
            if (object != null) {
                nSString3 = NSString.stringWith((String)object);
            }
            nSString = new NSString(OS.NSAccessibilityRoleDescription(nSString2 != null ? nSString2.id : 0L, nSString3 != null ? nSString3.id : 0L));
        }
        return nSString;
    }

    id getTitleAttribute(int n) {
        NSString nSString = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n2;
        }
        if (accessibleControlEvent.detail != 41) {
            AccessibleEvent accessibleEvent = new AccessibleEvent(this);
            accessibleEvent.childID = n;
            accessibleEvent.result = null;
            int n3 = 0;
            while (n3 < this.accessibleListeners.size()) {
                AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n3);
                accessibleListener.getName(accessibleEvent);
                ++n3;
            }
            if (accessibleEvent.result != null) {
                nSString = NSString.stringWith(accessibleEvent.result);
            }
        }
        return nSString;
    }

    id getValueAttribute(int n) {
        Object object;
        id id2 = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.detail = -1;
        accessibleControlEvent.result = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            object.getRole(accessibleControlEvent);
            object.getValue(accessibleControlEvent);
            ++n2;
        }
        n2 = accessibleControlEvent.detail;
        object = accessibleControlEvent.result;
        switch (n2) {
            case 3: 
            case 44: 
            case 45: 
            case 48: 
            case 51: {
                if (object != null) {
                    try {
                        int n3 = Integer.parseInt((String)object);
                        id2 = NSNumber.numberWithInt(n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((String)object).equalsIgnoreCase("true")) {
                            id2 = NSNumber.numberWithBool(true);
                            break;
                        }
                        if (!((String)object).equalsIgnoreCase("false")) break;
                        id2 = NSNumber.numberWithBool(false);
                    }
                    break;
                }
                id2 = NSNumber.numberWithBool(false);
                break;
            }
            case 37: 
            case 60: {
                AccessibleControlEvent accessibleControlEvent2 = new AccessibleControlEvent(this);
                accessibleControlEvent2.childID = -4;
                int n4 = 0;
                while (n4 < this.accessibleControlListeners.size()) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
                    accessibleControlListener.getSelection(accessibleControlEvent2);
                    ++n4;
                }
                if (accessibleControlEvent2.childID >= -1) {
                    if (n2 == 37) {
                        id2 = NSNumber.numberWithBool(accessibleControlEvent2.childID == n);
                        break;
                    }
                    id2 = new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)accessibleControlEvent2.childID).id));
                    break;
                }
                id2 = NSNumber.numberWithBool(false);
                break;
            }
            case 42: 
            case 46: {
                if (object == null) break;
                id2 = NSString.stringWith((String)object);
                break;
            }
            case 41: {
                AccessibleEvent accessibleEvent = new AccessibleEvent(this);
                accessibleEvent.childID = n;
                accessibleEvent.result = null;
                int n5 = 0;
                while (n5 < this.accessibleListeners.size()) {
                    AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n5);
                    accessibleListener.getName(accessibleEvent);
                    ++n5;
                }
                if (accessibleEvent.result != null) {
                    id2 = NSString.stringWith(accessibleEvent.result);
                    break;
                }
                if (object == null) break;
                id2 = NSString.stringWith((String)object);
            }
        }
        return id2;
    }

    id getEnabledAttribute(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getState(accessibleControlEvent);
            ++n2;
        }
        return NSNumber.numberWithBool(this.control.isEnabled());
    }

    id getFocusedAttribute(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -3;
        accessibleControlEvent.accessible = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getFocus(accessibleControlEvent);
            n2 += 1;
        }
        if (accessibleControlEvent.childID == -1) {
            n2 = accessibleControlEvent.childID == n ? 1 : 0;
            return NSNumber.numberWithBool(n2 != 0);
        }
        if (accessibleControlEvent.childID == -2) {
            return NSNumber.numberWithBool(false);
        }
        if (accessibleControlEvent.childID != -3) {
            return NSNumber.numberWithBool(accessibleControlEvent.childID == n);
        }
        n2 = this.control.view.window().firstResponder() == this.control.view ? 1 : 0;
        return NSNumber.numberWithBool(n2 != 0);
    }

    id getParentAttribute(int n) {
        if (n == -1) {
            return null;
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
    }

    id getChildrenAttribute(int n) {
        id id2 = null;
        if (n == -1) {
            Object object;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.detail = -1;
            int n2 = 0;
            while (n2 < this.accessibleControlListeners.size()) {
                object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                object.getChildCount(accessibleControlEvent);
                ++n2;
            }
            if (accessibleControlEvent.detail > 0) {
                n2 = 0;
                while (n2 < this.accessibleControlListeners.size()) {
                    object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                    object.getChildren(accessibleControlEvent);
                    ++n2;
                }
                Object[] objectArray = accessibleControlEvent.children;
                if (objectArray != null && objectArray.length > 0) {
                    object = NSMutableArray.arrayWithCapacity(objectArray.length);
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        Object object2 = objectArray[n3];
                        if (object2 instanceof Integer) {
                            id id3 = this.childIDToOs((Integer)object2);
                            ((NSMutableArray)object).addObject(id3);
                        } else {
                            ((NSMutableArray)object).addObject(((Accessible)object2).control.view);
                        }
                        ++n3;
                    }
                    id2 = new id(OS.NSAccessibilityUnignoredChildren(((NSMutableArray)object).id));
                }
            }
        } else {
            id2 = NSArray.array();
        }
        return id2;
    }

    id getTabsAttribute(int n) {
        id id2 = null;
        if (n == -1) {
            Object object;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = n;
            accessibleControlEvent.detail = -1;
            int n2 = 0;
            while (n2 < this.accessibleControlListeners.size()) {
                object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                object.getChildCount(accessibleControlEvent);
                ++n2;
            }
            if (accessibleControlEvent.detail > 0) {
                n2 = 0;
                while (n2 < this.accessibleControlListeners.size()) {
                    object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                    object.getChildren(accessibleControlEvent);
                    ++n2;
                }
                Object[] objectArray = accessibleControlEvent.children;
                if (objectArray != null && objectArray.length > 0) {
                    object = NSMutableArray.arrayWithCapacity(objectArray.length);
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        Object object2 = objectArray[n3];
                        if (object2 instanceof Integer) {
                            int n4;
                            accessibleControlEvent.childID = n4 = ((Integer)object2).intValue();
                            accessibleControlEvent.detail = -1;
                            int n5 = 0;
                            while (n5 < this.accessibleControlListeners.size()) {
                                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
                                accessibleControlListener.getRole(accessibleControlEvent);
                                ++n5;
                            }
                            if (accessibleControlEvent.detail == 37) {
                                id id3 = this.childIDToOs((Integer)object2);
                                ((NSMutableArray)object).addObject(id3);
                            }
                        } else {
                            ((NSMutableArray)object).addObject(((Accessible)object2).control.view);
                        }
                        ++n3;
                    }
                    id2 = new id(OS.NSAccessibilityUnignoredChildren(((NSMutableArray)object).id));
                }
            }
        } else {
            id2 = NSArray.array();
        }
        return id2;
    }

    id getWindowAttribute(int n) {
        return this.control.view.window();
    }

    id getTopLevelUIElementAttribute(int n) {
        return this.control.view.window();
    }

    id getPositionAttribute(int n) {
        Object object;
        NSValue nSValue = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.width = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            object.getLocation(accessibleControlEvent);
            ++n2;
        }
        Monitor monitor = Display.getCurrent().getPrimaryMonitor();
        object = new NSPoint();
        if (accessibleControlEvent.width != -1) {
            ((NSPoint)object).x = accessibleControlEvent.x;
            ((NSPoint)object).y = monitor.getBounds().height - accessibleControlEvent.y - accessibleControlEvent.height;
            nSValue = NSValue.valueWithPoint((NSPoint)object);
        } else if (n != -1) {
            Point point = null;
            Rectangle rectangle = this.control.getBounds();
            point = this.control.getParent() != null ? this.control.getParent().toDisplay(rectangle.x, rectangle.y) : ((Shell)this.control).toDisplay(rectangle.x, rectangle.y);
            ((NSPoint)object).x = point.x;
            ((NSPoint)object).y = point.y;
            nSValue = NSValue.valueWithPoint((NSPoint)object);
        }
        return nSValue;
    }

    id getSizeAttribute(int n) {
        NSValue nSValue = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.width = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getLocation(accessibleControlEvent);
            ++n2;
        }
        NSSize nSSize = new NSSize();
        if (accessibleControlEvent.width != -1) {
            nSSize.width = accessibleControlEvent.width;
            nSSize.height = accessibleControlEvent.height;
            nSValue = NSValue.valueWithSize(nSSize);
        } else if (n != -1) {
            nSSize.height = 0.0;
            nSSize.width = 0.0;
            nSValue = NSValue.valueWithSize(nSSize);
        }
        return nSValue;
    }

    id getDescriptionAttribute(int n) {
        AccessibleEvent accessibleEvent = new AccessibleEvent(this);
        accessibleEvent.childID = n;
        accessibleEvent.result = null;
        NSString nSString = null;
        int n2 = 0;
        while (n2 < this.accessibleListeners.size()) {
            AccessibleListener accessibleListener = (AccessibleListener)this.accessibleListeners.elementAt(n2);
            accessibleListener.getDescription(accessibleEvent);
            ++n2;
        }
        NSString nSString2 = nSString = accessibleEvent.result != null ? NSString.stringWith(accessibleEvent.result) : null;
        if (nSString == null && this.control instanceof Composite) {
            nSString = NSString.stringWith("");
        }
        return nSString;
    }

    id getInsertionPointLineNumberAttribute(int n) {
        NSNumber nSNumber = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.result = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n2;
        }
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = n;
        accessibleTextEvent.offset = -1;
        int n3 = 0;
        while (n3 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n3);
            accessibleTextListener.getCaretOffset(accessibleTextEvent);
            ++n3;
        }
        if (accessibleControlEvent.result != null && accessibleTextEvent.offset != -1) {
            n3 = this.lineNumberForOffset(accessibleControlEvent.result, accessibleTextEvent.offset);
            nSNumber = NSNumber.numberWithInt(n3);
        }
        return nSNumber;
    }

    id getNumberOfCharactersAttribute(int n) {
        NSNumber nSNumber = null;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.result = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n2;
        }
        String string = accessibleControlEvent.result;
        if (string != null) {
            nSNumber = NSNumber.numberWithInt(string.length());
        }
        return nSNumber;
    }

    id getRangeForLineParameterizedAttribute(id id2, int n) {
        NSValue nSValue = null;
        NSNumber nSNumber = new NSNumber(id2.id);
        int n2 = nSNumber.intValue();
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.result = null;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n3;
        }
        if (accessibleControlEvent.result != null) {
            NSRange nSRange = this.rangeForLineNumber(n2, accessibleControlEvent.result);
            if (nSRange.location != -1L) {
                nSValue = NSValue.valueWithRange(nSRange);
            }
        }
        return nSValue;
    }

    id getSelectedTextAttribute(int n) {
        NSString nSString = NSString.stringWith("");
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = n;
        accessibleTextEvent.offset = -1;
        accessibleTextEvent.length = -1;
        int n2 = 0;
        while (n2 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n2);
            accessibleTextListener.getSelectionRange(accessibleTextEvent);
            ++n2;
        }
        n2 = accessibleTextEvent.offset;
        int n3 = accessibleTextEvent.length;
        if (n2 != -1 && n3 != -1 && n3 != 0) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = accessibleTextEvent.childID;
            accessibleControlEvent.result = null;
            int n4 = 0;
            while (n4 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n4;
            }
            String string = accessibleControlEvent.result;
            if (string != null) {
                nSString = NSString.stringWith(string.substring(n2, n2 + n3));
            }
        }
        return nSString;
    }

    id getSelectedTextRangeAttribute(int n) {
        NSValue nSValue = null;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = n;
        accessibleTextEvent.offset = -1;
        accessibleTextEvent.length = 0;
        int n2 = 0;
        while (n2 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n2);
            accessibleTextListener.getSelectionRange(accessibleTextEvent);
            ++n2;
        }
        if (accessibleTextEvent.offset != -1) {
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.offset;
            nSRange.length = accessibleTextEvent.length;
            nSValue = NSValue.valueWithRange(nSRange);
        }
        return nSValue;
    }

    id getStringForRangeAttribute(id id2, int n) {
        NSString nSString = null;
        NSValue nSValue = new NSValue(id2.id);
        NSRange nSRange = nSValue.rangeValue();
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.result = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n2;
        }
        String string = accessibleControlEvent.result;
        if (string != null) {
            nSString = NSString.stringWith(string.substring((int)nSRange.location, (int)(nSRange.location + nSRange.length)));
        }
        return nSString;
    }

    id getSelectedTextRangesAttribute(int n) {
        NSMutableArray nSMutableArray = null;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.childID = n;
        accessibleTextEvent.offset = -1;
        accessibleTextEvent.length = 0;
        int n2 = 0;
        while (n2 < this.accessibleTextListeners.size()) {
            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n2);
            accessibleTextListener.getSelectionRange(accessibleTextEvent);
            ++n2;
        }
        if (accessibleTextEvent.offset != -1) {
            nSMutableArray = NSMutableArray.arrayWithCapacity(1L);
            NSRange nSRange = new NSRange();
            nSRange.location = accessibleTextEvent.offset;
            nSRange.length = accessibleTextEvent.length;
            nSMutableArray.addObject(NSValue.valueWithRange(nSRange));
        }
        return nSMutableArray;
    }

    id getVisibleCharacterRangeAttribute(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        accessibleControlEvent.result = null;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getValue(accessibleControlEvent);
            ++n2;
        }
        NSRange nSRange = new NSRange();
        if (accessibleControlEvent.result == null) {
            return null;
        }
        nSRange.location = 0L;
        nSRange.length = accessibleControlEvent.result.length();
        return NSValue.valueWithRange(nSRange);
    }

    int lineNumberForOffset(String string, int n) {
        int n2 = 1;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n) {
            switch (string.charAt(n4)) {
                case '\r': {
                    if (n4 + 1 < n3 && string.charAt(n4 + 1) == '\n') {
                        ++n4;
                    }
                }
                case '\n': {
                    ++n2;
                }
            }
            ++n4;
        }
        return n2;
    }

    NSRange rangeForLineNumber(int n, String string) {
        NSRange nSRange = new NSRange();
        nSRange.location = -1L;
        int n2 = 1;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            if (n2 == n) {
                if (n3 == 0) {
                    nSRange.location = n5;
                }
                ++n3;
            }
            if (n2 > n) break;
            switch (string.charAt(n5)) {
                case '\r': {
                    if (n5 + 1 < n4 && string.charAt(n5 + 1) == '\n') {
                        ++n5;
                    }
                }
                case '\n': {
                    ++n2;
                }
            }
            ++n5;
        }
        nSRange.length = n3;
        return nSRange;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.removeElement(accessibleTextListener);
    }

    static NSArray retainedAutoreleased(NSArray nSArray) {
        id id2 = nSArray.retain();
        NSObject nSObject = new NSObject(id2.id).autorelease();
        return new NSArray(nSObject.id);
    }

    public void selectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
    }

    public void setFocus(int n) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityFocusedUIElementChangedNotification.id);
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityValueChangedNotification.id);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    id childIDToOs(int n) {
        if (n == -1) {
            return this.control.view;
        }
        SWTAccessibleDelegate sWTAccessibleDelegate = (SWTAccessibleDelegate)this.children.get(new Integer(n));
        if (sWTAccessibleDelegate == null) {
            sWTAccessibleDelegate = new SWTAccessibleDelegate(this, n);
            this.children.put(new Integer(n), sWTAccessibleDelegate);
        }
        return sWTAccessibleDelegate;
    }

    NSString concatStringsAsRole(NSString nSString, NSString nSString2) {
        NSString nSString3 = nSString;
        nSString3 = nSString3.stringByAppendingString(NSString.stringWith(":"));
        nSString3 = nSString3.stringByAppendingString(nSString2);
        return nSString3;
    }

    String roleToOs(int n) {
        NSString nSString = null;
        switch (n) {
            case 10: {
                nSString = OS.NSAccessibilityGroupRole;
                break;
            }
            case 9: {
                nSString = OS.NSAccessibilityWindowRole;
                break;
            }
            case 2: {
                nSString = OS.NSAccessibilityMenuBarRole;
                break;
            }
            case 11: {
                nSString = OS.NSAccessibilityMenuRole;
                break;
            }
            case 12: {
                nSString = OS.NSAccessibilityMenuItemRole;
                break;
            }
            case 21: {
                nSString = OS.NSAccessibilitySplitterRole;
                break;
            }
            case 13: {
                nSString = OS.NSAccessibilityHelpTagRole;
                break;
            }
            case 3: {
                nSString = OS.NSAccessibilityScrollBarRole;
                break;
            }
            case 18: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole);
                break;
            }
            case 41: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 43: {
                nSString = OS.NSAccessibilityButtonRole;
                break;
            }
            case 44: {
                nSString = OS.NSAccessibilityCheckBoxRole;
                break;
            }
            case 45: {
                nSString = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 62: {
                nSString = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 46: {
                nSString = OS.NSAccessibilityComboBoxRole;
                break;
            }
            case 42: {
                int n2 = this.control.getStyle();
                if ((n2 & 2) != 0) {
                    nSString = OS.NSAccessibilityTextAreaRole;
                    break;
                }
                nSString = OS.NSAccessibilityTextFieldRole;
                break;
            }
            case 22: {
                nSString = OS.NSAccessibilityToolbarRole;
                break;
            }
            case 33: {
                nSString = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 34: {
                nSString = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 24: {
                nSString = OS.NSAccessibilityTableRole;
                break;
            }
            case 29: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 25: {
                nSString = OS.NSAccessibilitySortButtonRole;
                break;
            }
            case 26: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 35: {
                nSString = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 36: {
                nSString = this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole);
                break;
            }
            case 60: {
                nSString = OS.NSAccessibilityTabGroupRole;
                break;
            }
            case 37: {
                nSString = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 48: {
                nSString = OS.NSAccessibilityProgressIndicatorRole;
                break;
            }
            case 51: {
                nSString = OS.NSAccessibilitySliderRole;
                break;
            }
            case 30: {
                nSString = OS.NSAccessibilityLinkRole;
            }
        }
        return nSString.getString();
    }

    int osToRole(NSString nSString) {
        if (nSString == null) {
            return 0;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityWindowRole)) {
            return 9;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMenuBarRole)) {
            return 2;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMenuRole)) {
            return 11;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMenuItemRole)) {
            return 12;
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySplitterRole)) {
            return 21;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityHelpTagRole)) {
            return 13;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityScrollBarRole)) {
            return 3;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityScrollAreaRole)) {
            return 33;
        }
        if (nSString.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole))) {
            return 18;
        }
        if (nSString.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilitySystemDialogSubrole))) {
            return 18;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityStaticTextRole)) {
            return 41;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityButtonRole)) {
            return 43;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityCheckBoxRole)) {
            return 44;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRadioButtonRole)) {
            return 45;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMenuButtonRole)) {
            return 62;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityComboBoxRole)) {
            return 46;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTextFieldRole)) {
            return 42;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTextAreaRole)) {
            return 42;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityToolbarRole)) {
            return 22;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityListRole)) {
            return 33;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTableRole)) {
            return 24;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityColumnRole)) {
            return 25;
        }
        if (nSString.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityButtonRole, OS.NSAccessibilitySortButtonRole))) {
            return 25;
        }
        if (nSString.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole))) {
            return 26;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityOutlineRole)) {
            return 35;
        }
        if (nSString.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole))) {
            return 36;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityTabGroupRole)) {
            return 60;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityProgressIndicatorRole)) {
            return 48;
        }
        if (nSString.isEqualToString(OS.NSAccessibilitySliderRole)) {
            return 51;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityLinkRole)) {
            return 30;
        }
        return 10;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

