/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTOutlineView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    NSTableHeaderView headerView;
    TreeItem[] items;
    int itemCount;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    int columnCount;
    int sortDirection;
    boolean ignoreExpand;
    boolean ignoreSelect;
    boolean ignoreRedraw;
    boolean reloadPending;
    boolean drawExpansion;
    Rectangle imageBounds;
    TreeItem insertItem;
    boolean insertBefore;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        this.clearCachedWidth(this.items);
    }

    TreeItem _getItem(TreeItem treeItem, int n, boolean bl) {
        TreeItem[] treeItemArray;
        int n2;
        if (treeItem != null) {
            n2 = treeItem.itemCount;
            treeItemArray = treeItem.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        TreeItem treeItem2 = treeItemArray[n];
        if (treeItem2 != null || (this.style & 0x10000000) == 0 || !bl) {
            return treeItem2;
        }
        treeItemArray[n] = treeItem2 = new TreeItem(this, treeItem, 0, n, false);
        return treeItem2;
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        NSString nSString;
        id id2;
        if (this.accessible != null && (id2 = this.accessible.internal_accessibilityAttributeValue(nSString = new NSString(l3), -1)) != null) {
            return id2.id;
        }
        nSString = new NSString(l3);
        if (nSString.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return NSString.stringWith((String)"").id;
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(TreeItem[] treeItemArray, int n, GC gC, boolean bl) {
        if (treeItemArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < treeItemArray.length) {
            TreeItem treeItem = treeItemArray[n3];
            if (treeItem != null) {
                int n4 = treeItem.calculateWidth(n, gC);
                n2 = Math.max(n2, n4);
                if (bl && treeItem.getExpanded()) {
                    n2 = Math.max(n2, this.calculateWidth(treeItem.items, n, gC, bl));
                }
            }
            ++n3;
        }
        return n2;
    }

    NSSize cellSize(long l, long l2) {
        NSSize nSSize = super.cellSize(l, l2);
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] lArray = new long[1];
            OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
            TreeItem treeItem = (TreeItem)this.display.getWidget(lArray[0]);
            OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
            long l3 = lArray[0];
            int n = 0;
            int n2 = 0;
            while (n2 < this.columnCount) {
                if (this.columns[n2].nsColumn.id == l3) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.sendMeasureItem(treeItem, n, nSSize);
        }
        return nSSize;
    }

    boolean canDragRowsWithIndexes_atPoint(long l, long l2, long l3, long l4) {
        boolean bl;
        NSPoint nSPoint = new NSPoint();
        OS.memmove(nSPoint, l4, (long)NSPoint.sizeof);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l5 = nSOutlineView.rowAtPoint(nSPoint);
        long l6 = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl2 = bl = (this.state & 0x40000) != 0 && this.hooks(29);
        if (bl && !nSOutlineView.isRowSelected(l5) && (l6 & 0x1E0000L) == 0L) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l5);
            nSOutlineView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        return nSOutlineView.isRowSelected(l5) && bl;
    }

    boolean checkData(TreeItem treeItem) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            Event event = new Event();
            TreeItem treeItem2 = treeItem.getParentItem();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || treeItem.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(treeItem)) {
                treeItem.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void checkItems() {
        if (!this.reloadPending) {
            return;
        }
        this.reloadPending = false;
        TreeItem[] treeItemArray = this.getSelection();
        ((NSOutlineView)this.view).reloadData();
        this.selectItems(treeItemArray, true);
        this.ignoreExpand = true;
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] != null) {
                this.items[n].updateExpanded();
            }
            ++n;
        }
        this.ignoreExpand = false;
    }

    void clear(TreeItem treeItem, int n, boolean bl) {
        TreeItem treeItem2 = this._getItem(treeItem, n, false);
        if (treeItem2 != null) {
            treeItem2.clear();
            treeItem2.redraw(-1);
            if (bl) {
                this.clearAll(treeItem2, true);
            }
        }
    }

    void clearAll(TreeItem treeItem, boolean bl) {
        int n = this.getItemCount(treeItem);
        if (n == 0) {
            return;
        }
        TreeItem[] treeItemArray = treeItem == null ? this.items : treeItem.items;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem2 = treeItemArray[n2];
            if (treeItem2 != null) {
                treeItem2.clear();
                treeItem2.redraw(-1);
                if (bl) {
                    this.clearAll(treeItem2, true);
                }
            }
            ++n2;
        }
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        this.clear(null, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(null, bl);
    }

    void clearCachedWidth(TreeItem[] treeItemArray) {
        if (treeItemArray == null) {
            return;
        }
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem = treeItemArray[n];
            if (treeItem == null) break;
            treeItem.width = -1;
            this.clearCachedWidth(treeItem.items);
            ++n;
        }
    }

    void collapseItem_collapseChildren(long l, long l2, long l3, boolean bl) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l3);
        if (!this.ignoreExpand) {
            treeItem.sendExpand(false, bl);
        }
        this.ignoreExpand = true;
        super.collapseItem_collapseChildren(l, l2, l3, bl);
        this.ignoreExpand = false;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return;
        }
        this.setScrollWidth();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                int n5 = 0;
                while (n5 < this.columnCount) {
                    n3 += this.columns[n5].getWidth();
                    ++n5;
                }
            } else {
                GC gC = new GC(this);
                n3 = this.calculateWidth(this.items, 0, gC, true) + 1;
                gC.dispose();
            }
            if ((this.style & 0x20) != 0) {
                n3 += this.getCheckColumnWidth();
            }
        } else {
            n3 = n;
        }
        n4 = n2 == -1 ? (int)((NSOutlineView)this.view).numberOfRows() * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n3 <= 0) {
            n3 = 64;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createColumn(TreeItem treeItem, int n) {
        Resource[] resourceArray;
        Color[] colorArray;
        Resource[] resourceArray2;
        Object[] objectArray;
        String[] stringArray;
        if (treeItem.items != null) {
            int n2 = 0;
            while (n2 < treeItem.items.length) {
                if (treeItem.items[n2] != null) {
                    this.createColumn(treeItem.items[n2], n);
                }
                ++n2;
            }
        }
        if ((stringArray = treeItem.strings) != null) {
            objectArray = new String[this.columnCount];
            System.arraycopy(stringArray, 0, objectArray, 0, n);
            System.arraycopy(stringArray, n, objectArray, n + 1, this.columnCount - n - 1);
            objectArray[n] = "";
            treeItem.strings = objectArray;
        }
        if (n == 0) {
            treeItem.text = "";
        }
        if ((objectArray = treeItem.images) != null) {
            resourceArray2 = new Image[this.columnCount];
            System.arraycopy(objectArray, 0, resourceArray2, 0, n);
            System.arraycopy(objectArray, n, resourceArray2, n + 1, this.columnCount - n - 1);
            treeItem.images = resourceArray2;
        }
        if (n == 0) {
            treeItem.image = null;
        }
        if ((resourceArray2 = treeItem.cellBackground) != null) {
            colorArray = new Color[this.columnCount];
            System.arraycopy(resourceArray2, 0, colorArray, 0, n);
            System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
            treeItem.cellBackground = colorArray;
        }
        if ((colorArray = treeItem.cellForeground) != null) {
            resourceArray = new Color[this.columnCount];
            System.arraycopy(colorArray, 0, resourceArray, 0, n);
            System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
            treeItem.cellForeground = resourceArray;
        }
        if ((resourceArray = treeItem.cellFont) != null) {
            Font[] fontArray = new Font[this.columnCount];
            System.arraycopy(resourceArray, 0, fontArray, 0, n);
            System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
            treeItem.cellFont = fontArray;
        }
    }

    void createHandle() {
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
        nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2 : 0);
        NSOutlineView nSOutlineView = (NSOutlineView)new SWTOutlineView().alloc();
        nSOutlineView.initWithFrame(new NSRect());
        nSOutlineView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSOutlineView.setAllowsColumnReordering(false);
        nSOutlineView.setAutoresizesOutlineColumn(false);
        nSOutlineView.setAutosaveExpandedItems(true);
        nSOutlineView.setDataSource(nSOutlineView);
        nSOutlineView.setDelegate(nSOutlineView);
        nSOutlineView.setColumnAutoresizingStyle(0L);
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSOutlineView.setIntercellSpacing(nSSize);
        nSOutlineView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSOutlineView.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        nSOutlineView.setHeaderView(null);
        NSString nSString = NSString.stringWith("");
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            this.checkColumn = this.checkColumn.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
            this.checkColumn.headerCell().setTitle(nSString);
            nSOutlineView.addTableColumn(this.checkColumn);
            nSOutlineView.setOutlineTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long l = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(l, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        this.firstColumn = this.firstColumn.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
        this.firstColumn.setMinWidth(5.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.headerCell().setTitle(nSString);
        nSOutlineView.addTableColumn(this.firstColumn);
        nSOutlineView.setOutlineTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(2L);
        this.firstColumn.setDataCell(this.dataCell);
        this.scrollView = nSScrollView;
        this.view = nSOutlineView;
    }

    void createItem(TreeColumn treeColumn, int n) {
        NSObject nSObject;
        Object object;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        if (this.columnCount == this.columns.length) {
            object = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, object, 0, this.columns.length);
            this.columns = object;
        }
        if (this.columnCount == 0) {
            object = this.firstColumn;
            ((NSTableColumn)object).setMinWidth(0.0);
            this.firstColumn = null;
        } else {
            nSObject = (NSOutlineView)this.view;
            NSString nSString = NSString.stringWith("");
            object = (NSTableColumn)new NSTableColumn().alloc();
            object = ((NSTableColumn)object).initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
            ((NSTableColumn)object).setMinWidth(0.0);
            ((NSTableColumn)object).headerCell().setTitle(nSString);
            ((NSTableView)nSObject).addTableColumn((NSTableColumn)object);
            int n2 = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)nSObject).moveColumn(this.columnCount + n2, n + n2);
            ((NSTableColumn)object).setDataCell(this.dataCell);
            if (n == 0) {
                ((NSOutlineView)nSObject).setOutlineTableColumn((NSTableColumn)object);
            }
        }
        treeColumn.createJNIRef();
        nSObject = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        ((NSTableColumn)object).setHeaderCell((NSCell)nSObject);
        this.display.addWidget(nSObject, treeColumn);
        treeColumn.nsColumn = object;
        ((NSTableColumn)object).setWidth(0.0);
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        int n3 = 0;
        while (n3 < this.itemCount) {
            TreeItem treeItem = this.items[n3];
            if (treeItem != null && this.columnCount > 1) {
                this.createColumn(treeItem, n);
            }
            ++n3;
        }
    }

    void createItem(TreeItem treeItem, TreeItem treeItem2, int n) {
        Object object;
        TreeItem[] treeItemArray;
        int n2;
        if (treeItem2 != null) {
            n2 = treeItem2.itemCount;
            treeItemArray = treeItem2.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        if (n == -1) {
            n = n2;
        }
        if (n < 0 || n > n2) {
            this.error(6);
        }
        if (n2 == treeItemArray.length) {
            object = new TreeItem[treeItemArray.length + 4];
            System.arraycopy(treeItemArray, 0, object, 0, treeItemArray.length);
            treeItemArray = object;
            if (treeItem2 != null) {
                treeItem2.items = treeItemArray;
            } else {
                this.items = treeItemArray;
            }
        }
        System.arraycopy(treeItemArray, n, treeItemArray, n + 1, n2++ - n);
        treeItemArray[n] = treeItem;
        treeItem.items = new TreeItem[4];
        treeItem.handle = object = (SWTTreeItem)new SWTTreeItem().alloc().init();
        treeItem.createJNIRef();
        treeItem.register();
        if (treeItem2 != null) {
            treeItem2.itemCount = n2;
        } else {
            this.itemCount = n2;
        }
        this.ignoreExpand = true;
        this.reloadItem(treeItem2, true);
        if (treeItem2 != null && treeItem2.itemCount == 1 && treeItem2.expanded) {
            ((NSOutlineView)this.view).expandItem(treeItem2.handle);
        }
        this.ignoreExpand = false;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        return this.display.outlineViewFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    public void deselectAll() {
        this.checkWidget();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        nSOutlineView.deselectAll(null);
        this.ignoreSelect = false;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowForItem(treeItem.handle);
        this.ignoreSelect = true;
        nSOutlineView.deselectRow(l);
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn treeColumn) {
        Object object;
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == treeColumn) break;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            object = this.items[n2];
            if (object != null) {
                if (this.columnCount <= 1) {
                    ((TreeItem)object).strings = null;
                    ((TreeItem)object).images = null;
                    ((TreeItem)object).cellBackground = null;
                    ((TreeItem)object).cellForeground = null;
                    ((TreeItem)object).cellFont = null;
                } else {
                    Object[] objectArray;
                    Object[] objectArray2;
                    if (((TreeItem)object).strings != null) {
                        objectArray2 = ((TreeItem)object).strings;
                        if (n == 0) {
                            ((TreeItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                        }
                        objectArray = new String[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object).strings = objectArray;
                    } else if (n == 0) {
                        ((TreeItem)object).text = "";
                    }
                    if (((TreeItem)object).images != null) {
                        objectArray2 = ((TreeItem)object).images;
                        if (n == 0) {
                            ((TreeItem)object).image = objectArray2[1];
                        }
                        objectArray = new Image[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object).images = objectArray;
                    } else if (n == 0) {
                        ((TreeItem)object).image = null;
                    }
                    if (((TreeItem)object).cellBackground != null) {
                        objectArray2 = ((TreeItem)object).cellBackground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object).cellBackground = objectArray;
                    }
                    if (((TreeItem)object).cellForeground != null) {
                        objectArray2 = ((TreeItem)object).cellForeground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object).cellForeground = objectArray;
                    }
                    if (((TreeItem)object).cellFont != null) {
                        objectArray2 = ((TreeItem)object).cellFont;
                        objectArray = new Font[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object).cellFont = objectArray;
                    }
                }
            }
            ++n2;
        }
        n2 = this.indexOf(treeColumn.nsColumn);
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = treeColumn.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0);
            this.setScrollWidth();
        } else {
            if (n == 0) {
                ((NSOutlineView)this.view).setOutlineTableColumn(this.columns[0].nsColumn);
            }
            ((NSOutlineView)this.view).removeTableColumn(treeColumn.nsColumn);
        }
        object = ((NSOutlineView)this.view).tableColumns();
        int n3 = (int)((NSArray)object).count();
        int n4 = n2;
        while (n4 < n3) {
            long l = ((NSArray)object).objectAtIndex((long)((long)n4)).id;
            int n5 = 0;
            while (n5 < this.columnCount) {
                if (this.columns[n5].nsColumn.id == l) {
                    this.columns[n5].sendEvent(10);
                    break;
                }
                ++n5;
            }
            ++n4;
        }
    }

    void destroyItem(TreeItem treeItem) {
        TreeItem[] treeItemArray;
        int n;
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null) {
            n = treeItem2.itemCount;
            treeItemArray = treeItem2.items;
        } else {
            n = this.itemCount;
            treeItemArray = this.items;
        }
        int n2 = 0;
        while (n2 < n) {
            if (treeItemArray[n2] == treeItem) break;
            ++n2;
        }
        System.arraycopy(treeItemArray, n2 + 1, treeItemArray, n2, --n - n2);
        treeItemArray[n] = null;
        if (treeItem2 != null) {
            treeItem2.itemCount = n;
        } else {
            this.itemCount = n;
        }
        this.reloadItem(treeItem2, true);
        this.setScrollWidth();
        if (this.itemCount == 0) {
            this.imageBounds = null;
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        return false;
    }

    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        Color color;
        boolean bl2 = this.hooks(40);
        boolean bl3 = this.hooks(42);
        boolean bl4 = this.hooks(41);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_ROW, lArray);
        TreeItem treeItem = (TreeItem)this.display.getWidget(lArray[0]);
        long l4 = nSOutlineView.rowForItem(treeItem.handle);
        OS.object_getInstanceVariable(l, Display.SWT_COLUMN, lArray);
        long l5 = lArray[0];
        long l6 = nSOutlineView.tableColumns().indexOfObjectIdenticalTo(new id(l5));
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2].nsColumn.id == l5) {
                n = n2;
                break;
            }
            ++n2;
        }
        Color color2 = color = treeItem.cellBackground != null ? treeItem.cellBackground[n] : null;
        if (color == null) {
            color = treeItem.background;
        }
        boolean bl5 = color != null;
        boolean bl6 = true;
        boolean bl7 = bl = nSTextFieldCell.isHighlighted();
        boolean bl8 = bl2 && this.hasFocus();
        Color color3 = null;
        Color color4 = null;
        if (bl && (bl2 || bl3)) {
            color4 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            color3 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize nSSize = super.cellSize(l, OS.sel_cellSize);
        NSImage nSImage = nSTextFieldCell.image();
        if (nSImage != null) {
            nSSize.width += (double)(this.imageBounds.width + 3);
        }
        int n3 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSOutlineView.intercellSpacing();
        int n4 = (int)Math.ceil(nSOutlineView.rowHeight() + nSSize2.height);
        NSRect nSRect2 = nSOutlineView.rectOfColumn(l6);
        nSRect2.y = nSRect.y;
        nSRect2.height = nSRect.height + nSSize2.height;
        if (this.columnCount == 0) {
            NSRect nSRect3 = nSOutlineView.rectOfRow(l4);
            nSRect2.width = nSRect3.width;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl3 || bl2) {
            NSRect nSRect4 = nSOutlineView.frameOfCellAtColumn(l6, l4);
            d = nSRect.x - nSRect4.x;
            d2 = nSRect.y - nSRect4.y;
            if (this.drawExpansion) {
                d -= 0.5;
                d2 -= 0.5;
            }
        }
        int n5 = (int)(nSRect.x - d);
        int n6 = (int)(nSRect.y - d2);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        if (bl4) {
            this.sendMeasureItem(treeItem, n, nSSize);
        }
        Color color5 = null;
        if (bl2) {
            nSGraphicsContext.saveGraphicsState();
            object5 = NSAffineTransform.transform();
            ((NSAffineTransform)object5).translateXBy(d, d2);
            ((NSAffineTransform)object5).concat();
            object4 = new GCData();
            ((GCData)object4).paintRect = nSRect2;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setFont(treeItem.getFont(n));
            if (bl) {
                ((GC)object3).setForeground(color4);
                ((GC)object3).setBackground(color3);
            } else {
                ((GC)object3).setForeground(treeItem.getForeground(n));
                ((GC)object3).setBackground(treeItem.getBackground(n));
            }
            if (!this.drawExpansion) {
                ((GC)object3).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object2 = new Event();
            ((Event)object2).item = treeItem;
            ((Event)object2).gc = object3;
            ((Event)object2).index = n;
            ((Event)object2).detail = 16;
            if (bl5) {
                ((Event)object2).detail |= 8;
            }
            if (bl) {
                ((Event)object2).detail |= 2;
            }
            ((Event)object2).x = (int)nSRect2.x;
            ((Event)object2).y = (int)nSRect2.y;
            ((Event)object2).width = (int)nSRect2.width;
            ((Event)object2).height = (int)nSRect2.height;
            this.sendEvent(40, (Event)object2);
            if (!((Event)object2).doit) {
                bl7 = false;
                bl5 = false;
                bl6 = false;
            } else {
                bl5 = bl5 && (((Event)object2).detail & 8) != 0;
                bl6 = (((Event)object2).detail & 0x10) != 0;
                boolean bl9 = bl7 = bl7 && (((Event)object2).detail & 2) != 0;
            }
            if (!bl7 && bl) {
                color5 = Color.cocoa_new(this.display, ((GC)object3).getForeground().handle);
            }
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (treeItem.isDisposed()) {
                return;
            }
            if (bl7 && ((this.style & 0x8000) == 0 || bl8)) {
                nSRect2.height -= nSSize2.height;
                this.callSuper(nSOutlineView.id, OS.sel_highlightSelectionInClipRect_, nSRect2);
                nSRect2.height += nSSize2.height;
            }
        }
        if (bl5 && !bl7) {
            nSGraphicsContext.saveGraphicsState();
            object5 = color.handle;
            object4 = NSColor.colorWithDeviceRed((double)object5[0], (double)object5[1], (double)object5[2], 1.0);
            ((NSColor)object4).setFill();
            NSBezierPath.fillRect(nSRect2);
            nSGraphicsContext.restoreGraphicsState();
        }
        if (this.insertItem != null && !this.insertItem.isDisposed()) {
            nSGraphicsContext.saveGraphicsState();
            object5 = nSTextFieldCell.titleRectForBounds(nSRect);
            object4 = new GCData();
            ((GCData)object4).paintRect = object5;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setClipping((int)(((NSRect)object5).x - d), (int)(((NSRect)object5).y - d2), (int)((NSRect)object5).width, (int)((NSRect)object5).height);
            object2 = this.insertItem.getImageBounds(0).union(this.insertItem.getBounds());
            object = this.getClientArea();
            int n7 = ((Rectangle)object).x + ((Rectangle)object).width;
            int n8 = this.insertBefore ? ((Rectangle)object2).y : ((Rectangle)object2).y + ((Rectangle)object2).height - 1;
            ((GC)object3).drawLine(((Rectangle)object2).x, n8, n7, n8);
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
        if (bl6) {
            if ((!this.drawExpansion || bl4) && nSImage != null) {
                object5 = new NSRect();
                ((NSRect)object5).x = nSRect.x + 3.0;
                ((NSRect)object5).y = nSRect.y + (double)((float)Math.ceil((nSRect.height - (double)this.imageBounds.height) / 2.0));
                ((NSRect)object5).width = this.imageBounds.width;
                ((NSRect)object5).height = this.imageBounds.height;
                object4 = new NSRect();
                object3 = nSImage.size();
                ((NSRect)object4).width = ((NSSize)object3).width;
                ((NSRect)object4).height = ((NSSize)object3).height;
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(nSRect).addClip();
                object2 = NSAffineTransform.transform();
                ((NSAffineTransform)object2).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object2).translateXBy(0.0, -(((NSRect)object5).height + 2.0 * ((NSRect)object5).y));
                ((NSAffineTransform)object2).concat();
                nSImage.drawInRect((NSRect)object5, (NSRect)object4, 2L, 1.0);
                nSGraphicsContext.restoreGraphicsState();
                int n9 = this.imageBounds.width + 3;
                nSRect.x += (double)n9;
                nSRect.width -= (double)n9;
            }
            nSTextFieldCell.setHighlighted(false);
            boolean bl10 = false;
            if (color5 != null) {
                object4 = color5.handle;
                if (object4[0] == 0.0 && object4[1] == 0.0 && object4[2] == 0.0 && object4[3] == 1.0) {
                    object3 = new NSMutableAttributedString(nSTextFieldCell.attributedStringValue().mutableCopy());
                    object2 = new NSRange();
                    ((NSRange)object2).length = ((NSAttributedString)object3).length();
                    ((NSMutableAttributedString)object3).removeAttribute(OS.NSForegroundColorAttributeName, (NSRange)object2);
                    object = new NSRect();
                    ((NSRect)object).x = nSRect.x + 2.0;
                    ((NSRect)object).y = nSRect.y;
                    ((NSRect)object).width = nSRect.width - 2.0;
                    ((NSRect)object).height = nSRect.height;
                    NSSize nSSize3 = ((NSAttributedString)object3).size();
                    if (((NSRect)object).height > nSSize3.height) {
                        ((NSRect)object).y += (((NSRect)object).height - nSSize3.height) / 2.0;
                        ((NSRect)object).height = nSSize3.height;
                    }
                    ((NSAttributedString)object3).drawInRect((NSRect)object);
                    ((NSObject)object3).release();
                } else {
                    object3 = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], (double)object4[3]);
                    nSTextFieldCell.setTextColor((NSColor)object3);
                    bl10 = true;
                }
            } else {
                bl10 = true;
            }
            if (bl10) {
                object4 = nSTextFieldCell.attributedStringValue();
                object3 = ((NSAttributedString)object4).size();
                if (nSRect.height > ((NSSize)object3).height) {
                    nSRect.y += (nSRect.height - ((NSSize)object3).height) / 2.0;
                    nSRect.height = ((NSSize)object3).height;
                }
                super.drawInteriorWithFrame_inView(l, l2, nSRect, l3);
            }
        }
        if (bl3) {
            nSGraphicsContext.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(d, d2);
            nSAffineTransform.concat();
            object4 = new GCData();
            ((GCData)object4).paintRect = nSRect2;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setFont(treeItem.getFont(n));
            if (bl7) {
                ((GC)object3).setForeground(color4);
                ((GC)object3).setBackground(color3);
            } else {
                ((GC)object3).setForeground(color5 != null ? color5 : treeItem.getForeground(n));
                ((GC)object3).setBackground(treeItem.getBackground(n));
            }
            if (!this.drawExpansion) {
                ((GC)object3).setClipping((int)(nSRect2.x - d), (int)(nSRect2.y - d2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object2 = new Event();
            ((Event)object2).item = treeItem;
            ((Event)object2).gc = object3;
            ((Event)object2).index = n;
            if (bl6) {
                ((Event)object2).detail |= 0x10;
            }
            if (bl5) {
                ((Event)object2).detail |= 8;
            }
            if (bl7) {
                ((Event)object2).detail |= 2;
            }
            ((Event)object2).x = n5;
            ((Event)object2).y = n6;
            ((Event)object2).width = n3;
            ((Event)object2).height = n4;
            this.sendEvent(42, (Event)object2);
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
    }

    void drawWithExpansionFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(l, l2, nSRect, l3);
        this.drawExpansion = false;
    }

    void expandItem_expandChildren(long l, long l2, long l3, boolean bl) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l3);
        if (!this.ignoreExpand) {
            treeItem.sendExpand(true, bl);
        }
        this.ignoreExpand = true;
        super.expandItem_expandChildren(l, l2, l3, bl);
        this.ignoreExpand = false;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return;
        }
        if (!bl) {
            this.ignoreExpand = true;
            TreeItem[] treeItemArray = treeItem.items;
            int n = 0;
            while (n < treeItem.itemCount) {
                if (treeItemArray[n] != null) {
                    treeItemArray[n].updateExpanded();
                }
                ++n;
            }
            this.ignoreExpand = false;
        }
        this.setScrollWidth(false, treeItem.items, true);
    }

    NSRect expansionFrameWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        if (this.toolTipText == null) {
            NSRect nSRect2 = super.expansionFrameWithFrame_inView(l, l2, nSRect, l3);
            NSCell nSCell = new NSCell(l);
            if (nSRect2.width != 0.0 && nSRect2.height != 0.0) {
                if (this.hooks(41)) {
                    NSSize nSSize = nSCell.cellSize();
                    nSRect.width = nSSize.width;
                    return nSRect;
                }
            } else {
                Object object;
                NSRect nSRect3;
                if (this.hooks(41)) {
                    nSRect3 = nSRect;
                    object = nSCell.cellSize();
                    nSRect3.width = ((NSSize)object).width;
                } else {
                    nSRect3 = nSCell.titleRectForBounds(nSRect);
                    object = super.cellSize(l, OS.sel_cellSize);
                    nSRect3.width = ((NSSize)object).width;
                }
                object = this.scrollView.contentView().bounds();
                OS.NSIntersectionRect((NSRect)object, nSRect3, (NSRect)object);
                if (!OS.NSEqualRects(nSRect3, (NSRect)object)) {
                    return nSRect3;
                }
            }
            return nSRect2;
        }
        return new NSRect();
    }

    Widget findTooltip(NSPoint nSPoint) {
        long l;
        NSTableView nSTableView = (NSTableView)this.view;
        NSTableHeaderView nSTableHeaderView = nSTableView.headerView();
        if (nSTableHeaderView != null && (l = nSTableHeaderView.columnAtPoint(nSPoint = nSTableHeaderView.convertPoint_fromView_(nSPoint, null))) != -1L) {
            NSArray nSArray = nSTableView.tableColumns();
            id id2 = nSArray.objectAtIndex(l);
            int n = 0;
            while (n < this.columnCount) {
                TreeColumn treeColumn = this.columns[n];
                if (treeColumn.nsColumn.id == id2.id) {
                    return treeColumn;
                }
                ++n;
            }
        }
        return super.findTooltip(nSPoint);
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView != null) {
            int n = (int)nSTableHeaderView.bounds().height;
            rectangle.y -= n;
            rectangle.height += n;
        }
        return rectangle;
    }

    TreeColumn getColumn(id id2) {
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n].nsColumn.id == id2.id) {
                return this.columns[n];
            }
            ++n;
        }
        return null;
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int n = 0;
        while (n < this.columnCount) {
            TreeColumn treeColumn = this.columns[n];
            int n2 = this.indexOf(treeColumn.nsColumn);
            if ((this.style & 0x20) != 0) {
                --n2;
            }
            nArray[n2] = n++;
        }
        return nArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return 0;
        }
        return (int)nSTableHeaderView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).headerView() != null;
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this._getItem(null, n, true);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        int n = (int)nSOutlineView.rowAtPoint(nSPoint);
        if (n == -1) {
            return null;
        }
        NSRect nSRect = nSOutlineView.frameOfOutlineCellAtRow(n);
        if (OS.NSPointInRect(nSPoint, nSRect)) {
            return null;
        }
        id id2 = nSOutlineView.itemAtRow(n);
        Widget widget = this.display.getWidget(id2.id);
        if (widget != null && widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    int getItemCount(TreeItem treeItem) {
        return treeItem == null ? this.itemCount : treeItem.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).rowHeight() + 1;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] treeItemArray = new TreeItem[this.itemCount];
        int n = 0;
        while (n < this.itemCount) {
            treeItemArray[n] = this._getItem(null, n, true);
            ++n;
        }
        return treeItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (nSOutlineView.numberOfSelectedRows() == 0L) {
            return new TreeItem[0];
        }
        NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        TreeItem[] treeItemArray = new TreeItem[n];
        int n2 = 0;
        while (n2 < n) {
            id id2 = nSOutlineView.itemAtRow(lArray[n2]);
            Widget widget = this.display.getWidget(id2.id);
            if (widget != null && widget instanceof TreeItem) {
                treeItemArray[n2] = (TreeItem)widget;
            }
            ++n2;
        }
        return treeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).numberOfSelectedRows();
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowAtPoint(nSPoint);
        if (l == -1L) {
            return null;
        }
        id id2 = nSOutlineView.itemAtRow(l);
        return (TreeItem)this.display.getWidget(id2.id);
    }

    void highlightSelectionInClipRect(long l, long l2, long l3) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l3, (long)NSRect.sizeof);
        this.callSuper(l, l2, nSRect);
    }

    long hitTestForEvent(long l, long l2, long l3, NSRect nSRect, long l4) {
        return this.callSuper(l, l2, l3, nSRect, l4);
    }

    long image(long l, long l2) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, Display.SWT_IMAGE, lArray);
        return lArray[0];
    }

    NSRect imageRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            nSRect.x += 3.0;
            nSRect.width = this.imageBounds.width;
            nSRect.height = this.imageBounds.height;
        }
        return nSRect;
    }

    int indexOf(NSTableColumn nSTableColumn) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(nSTableColumn);
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == treeColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != null) {
            return -1;
        }
        int n = 0;
        while (n < this.itemCount) {
            if (treeItem == this.items[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean isTrim(NSView nSView) {
        if (super.isTrim(nSView)) {
            return true;
        }
        return nSView.id == this.headerView.id;
    }

    long menuForEvent(long l, long l2, long l3) {
        if (l != this.headerView.id) {
            NSPoint nSPoint;
            long l4;
            NSEvent nSEvent = new NSEvent(l3);
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
            if (!nSIndexSet.containsIndex(l4 = nSOutlineView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(l4);
                nSOutlineView.selectRowIndexes(nSIndexSet2, false);
                nSIndexSet2.release();
            }
        }
        return super.menuForEvent(l, l2, l3);
    }

    void mouseDown(long l, long l2, long l3) {
        NSEvent nSEvent;
        if (this.headerView != null && l == this.headerView.id) {
            NSTableView nSTableView = (NSTableView)this.view;
            nSTableView.setAllowsColumnReordering(false);
            NSPoint nSPoint = this.headerView.convertPoint_fromView_(new NSEvent(l3).locationInWindow(), null);
            long l4 = this.headerView.columnAtPoint(nSPoint);
            if (l4 != -1L) {
                id id2 = nSTableView.tableColumns().objectAtIndex(l4);
                int n = 0;
                while (n < this.columnCount) {
                    if (this.columns[n].nsColumn.id == id2.id) {
                        nSTableView.setAllowsColumnReordering(this.columns[n].movable);
                        break;
                    }
                    ++n;
                }
            }
        } else if (l == this.view.id && ((nSEvent = new NSEvent(l3)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(l, l2, l3);
    }

    long nextState(long l, long l2) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = (int)nSOutlineView.selectedRow();
        TreeItem treeItem = (TreeItem)this.display.getWidget(nSOutlineView.itemAtRow((long)((long)n)).id);
        if (treeItem.grayed) {
            return treeItem.checked ? 0 : -1;
        }
        return treeItem.checked ? 0 : 1;
    }

    long outlineView_child_ofItem(long l, long l2, long l3, long l4, long l5) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l5);
        TreeItem treeItem2 = this._getItem(treeItem, (int)l4, true);
        return treeItem2.handle.id;
    }

    void outlineView_didClickTableColumn(long l, long l2, long l3, long l4) {
        TreeColumn treeColumn = this.getColumn(new id(l4));
        if (treeColumn == null) {
            return;
        }
        treeColumn.postEvent(13);
    }

    long outlineView_objectValueForTableColumn_byItem(long l, long l2, long l3, long l4, long l5) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(l5);
        this.checkData(treeItem);
        if (this.checkColumn != null && l4 == this.checkColumn.id) {
            NSNumber nSNumber = treeItem.checked && treeItem.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(treeItem.checked ? 1 : 0);
            return nSNumber.id;
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n].nsColumn.id == l4) {
                return treeItem.createString((int)n).id;
            }
            ++n;
        }
        return treeItem.createString((int)0).id;
    }

    boolean outlineView_isItemExpandable(long l, long l2, long l3, long l4) {
        if (l4 == 0L) {
            return true;
        }
        return ((TreeItem)this.display.getWidget((long)l4)).itemCount != 0;
    }

    long outlineView_numberOfChildrenOfItem(long l, long l2, long l3, long l4) {
        if (l4 == 0L) {
            return this.itemCount;
        }
        return ((TreeItem)this.display.getWidget((long)l4)).itemCount;
    }

    void outlineView_willDisplayCell_forTableColumn_item(long l, long l2, long l3, long l4, long l5, long l6) {
        Font font;
        NSColor nSColor;
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            return;
        }
        TreeItem treeItem = (TreeItem)this.display.getWidget(l6);
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2].nsColumn.id == l5) {
                n = n2;
                break;
            }
            ++n2;
        }
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(l4);
        OS.object_setInstanceVariable(l4, Display.SWT_ROW, l6);
        OS.object_setInstanceVariable(l4, Display.SWT_COLUMN, l5);
        Image image = n == 0 ? treeItem.image : (treeItem.images == null ? null : treeItem.images[n]);
        nSTextFieldCell.setImage(image != null ? image.handle : null);
        if (nSTextFieldCell.isEnabled()) {
            if (nSTextFieldCell.isHighlighted()) {
                nSColor = NSColor.selectedControlTextColor();
            } else {
                Color color;
                Color color2 = color = treeItem.cellForeground != null ? treeItem.cellForeground[n] : null;
                if (color == null) {
                    color = treeItem.foreground;
                }
                if (color == null) {
                    color = this.getForegroundColor();
                }
                nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
            }
        } else {
            nSColor = NSColor.disabledControlTextColor();
        }
        int n3 = 0;
        if (this.columnCount > 0) {
            int n4 = this.columns[n].style;
            if ((n4 & 0x1000000) != 0) {
                n3 = 2;
            } else if ((n4 & 0x20000) != 0) {
                n3 = 1;
            }
        }
        Font font2 = font = treeItem.cellFont != null ? treeItem.cellFont[n] : null;
        if (font == null) {
            font = treeItem.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            nSMutableDictionary.setObject(nSColor, OS.NSForegroundColorAttributeName);
            nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(nSMutableDictionary, font);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setLineBreakMode(2L);
            nSMutableParagraphStyle.setAlignment(n3);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSTextFieldCell.title(), nSMutableDictionary);
            nSTextFieldCell.setAttributedStringValue(nSAttributedString);
            nSAttributedString.release();
            nSMutableDictionary.release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            nSTextFieldCell.setTextColor(nSColor);
            nSTextFieldCell.setAlignment(n3);
        }
    }

    void outlineViewColumnDidMove(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        id id2 = nSDictionary.valueForKey(NSString.stringWith("NSOldColumn"));
        id id3 = nSDictionary.valueForKey(NSString.stringWith("NSNewColumn"));
        int n = new NSNumber(id2).intValue();
        int n2 = new NSNumber(id3).intValue();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSArray nSArray = nSOutlineView.tableColumns();
        int n5 = n3;
        while (n5 <= n4) {
            id id4 = nSArray.objectAtIndex(n5);
            TreeColumn treeColumn = this.getColumn(id4);
            if (treeColumn != null) {
                treeColumn.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++n5;
        }
    }

    void outlineViewColumnDidResize(long l, long l2, long l3) {
        NSNotification nSNotification = new NSNotification(l3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        id id2 = nSDictionary.valueForKey(NSString.stringWith("NSTableColumn"));
        TreeColumn treeColumn = this.getColumn(id2);
        if (treeColumn == null) {
            return;
        }
        treeColumn.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = this.indexOf(treeColumn.nsColumn);
        if (n == -1) {
            return;
        }
        NSArray nSArray = nSOutlineView.tableColumns();
        int n2 = (int)nSOutlineView.numberOfColumns();
        int n3 = n + 1;
        while (n3 < n2) {
            id2 = nSArray.objectAtIndex(n3);
            treeColumn = this.getColumn(id2);
            if (treeColumn != null) {
                treeColumn.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++n3;
        }
    }

    void outlineViewSelectionDidChange(long l, long l2, long l3) {
        if (this.ignoreSelect) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = (int)nSOutlineView.selectedRow();
        if (n == -1) {
            this.postEvent(13);
        } else {
            id id2 = nSOutlineView.itemAtRow(n);
            TreeItem treeItem = (TreeItem)this.display.getWidget(id2.id);
            Event event = new Event();
            event.item = treeItem;
            event.index = n;
            this.postEvent(13, event);
        }
    }

    void outlineView_setObjectValue_forTableColumn_byItem(long l, long l2, long l3, long l4, long l5, long l6) {
        if (this.checkColumn != null && l5 == this.checkColumn.id) {
            TreeItem treeItem = (TreeItem)this.display.getWidget(l6);
            treeItem.checked = !treeItem.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = treeItem;
            this.postEvent(13, event);
            treeItem.redraw(-1);
        }
    }

    boolean outlineView_writeItems_toPasteboard(long l, long l2, long l3, long l4, long l5) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n = 0;
        while (n < this.items.length) {
            item = this.items[n];
            if (item != null && !item.isDisposed()) {
                ((TreeItem)item).release(false);
            }
            ++n;
        }
        this.items = null;
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.sortColumn = null;
    }

    void reloadItem(TreeItem treeItem, boolean bl) {
        if (this.getDrawing()) {
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            TreeItem[] treeItemArray = this.getSelection();
            if (treeItem != null) {
                nSOutlineView.reloadItem(treeItem.handle, bl);
            } else {
                nSOutlineView.reloadData();
            }
            this.selectItems(treeItemArray, true);
        } else {
            this.reloadPending = true;
        }
    }

    public void removeAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.items.length) {
            TreeItem treeItem = this.items[n];
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.release(false);
            }
            ++n;
        }
        this.items = new TreeItem[4];
        this.itemCount = 0;
        this.imageBounds = null;
        ((NSOutlineView)this.view).reloadData();
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    void setImage(long l, long l2, long l3) {
        OS.object_setInstanceVariable(l, Display.SWT_IMAGE, l3);
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem != null && treeItem.isDisposed()) {
            this.error(5);
        }
        TreeItem treeItem2 = this.insertItem;
        this.insertItem = treeItem;
        this.insertBefore = bl;
        if (treeItem2 != null && !treeItem2.isDisposed()) {
            treeItem2.redraw(-1);
        }
        if (treeItem != null) {
            treeItem.redraw(-1);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        nSOutlineView.selectAll(null);
        this.ignoreSelect = false;
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowForItem(treeItem.handle);
        NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
        nSIndexSet = nSIndexSet.initWithIndex(l);
        this.ignoreSelect = true;
        nSOutlineView.selectRowIndexes(nSIndexSet, false);
        this.ignoreSelect = false;
        nSIndexSet.release();
    }

    void sendDoubleSelection() {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = (int)nSOutlineView.clickedRow();
        if (n != -1) {
            Object object;
            if ((this.style & 0x20) != 0) {
                object = nSOutlineView.tableColumns();
                int n2 = (int)nSOutlineView.clickedColumn();
                id id2 = ((NSArray)object).objectAtIndex(n2);
                if (id2.id == this.checkColumn.id) {
                    return;
                }
            }
            object = (TreeItem)this.display.getWidget(nSOutlineView.itemAtRow((long)((long)n)).id);
            Event event = new Event();
            event.item = object;
            this.postEvent(14, event);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.postEvent(14);
            }
        }
        return bl;
    }

    void sendMeasureItem(TreeItem treeItem, int n, NSSize nSSize) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSOutlineView.intercellSpacing();
        int n3 = (int)Math.ceil(nSOutlineView.rowHeight() + nSSize2.height);
        GCData gCData = new GCData();
        gCData.paintRect = nSOutlineView.frame();
        GC gC = GC.cocoa_new(this, gCData);
        gC.setFont(treeItem.getFont(n));
        Event event = new Event();
        event.item = treeItem;
        event.gc = gC;
        event.index = n;
        event.width = n2;
        event.height = n3;
        this.sendEvent(41, event);
        gC.dispose();
        if (!this.isDisposed() && !treeItem.isDisposed()) {
            nSSize.width = event.width;
            nSSize.height = event.height;
            if (n3 < event.height) {
                nSOutlineView.setRowHeight(event.height);
            }
            if (n2 != event.width && this.columnCount == 0 && n == 0) {
                treeItem.width = event.width;
                treeItem.width = (int)((double)treeItem.width + nSOutlineView.indentationPerLevel() * (double)(1L + nSOutlineView.levelForItem(treeItem.handle)));
                if (this.setScrollWidth(treeItem)) {
                    nSOutlineView.setNeedsDisplay(true);
                }
            }
        }
    }

    void selectItems(TreeItem[] treeItemArray, boolean bl) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                block6: {
                    if (treeItemArray[n2] == null) break block5;
                    if (!treeItemArray[n2].isDisposed()) break block6;
                    if (bl) break block5;
                    this.error(5);
                }
                TreeItem treeItem = treeItemArray[n2];
                if (!bl) {
                    this.showItem(treeItemArray[n2], false);
                }
                nSMutableIndexSet.addIndex(nSOutlineView.rowForItem(treeItem.handle));
            }
            ++n2;
        }
        this.ignoreSelect = true;
        nSOutlineView.selectRowIndexes(nSMutableIndexSet, false);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    NSRect titleRectForBounds(long l, long l2, NSRect nSRect) {
        NSImage nSImage = new NSCell(l).image();
        if (nSImage != null) {
            int n = this.imageBounds.width + 3;
            nSRect.x += (double)n;
            nSRect.width -= (double)n;
        }
        return nSRect;
    }

    void updateBackground() {
        NSColor nSColor = null;
        if (this.backgroundImage != null) {
            nSColor = NSColor.colorWithPatternImage(this.backgroundImage.handle);
        } else if (this.background != null) {
            nSColor = NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]);
        }
        ((NSOutlineView)this.view).setBackgroundColor(nSColor);
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (nArray[n] != nArray2[n]) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            TreeColumn treeColumn;
            int n3;
            int n4;
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            int[] nArray3 = new int[nArray2.length];
            int n5 = (this.style & 0x20) != 0 ? 1 : 0;
            int n6 = 0;
            while (n6 < nArray2.length) {
                n4 = nArray2[n6];
                nArray3[n4] = (int)nSOutlineView.rectOfColumn((long)((long)(n6 + n5))).x;
                ++n6;
            }
            int[] nArray4 = new int[nArray.length];
            n4 = 0;
            while (n4 < nArray.length) {
                n3 = nArray[n4];
                treeColumn = this.columns[n3];
                int n7 = this.indexOf(treeColumn.nsColumn);
                int n8 = n4 + n5;
                nSOutlineView.moveColumn(n7, n8);
                nArray4[n3] = (int)nSOutlineView.rectOfColumn((long)((long)n8)).x;
                ++n4;
            }
            TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
            n3 = 0;
            while (n3 < this.columnCount) {
                treeColumn = treeColumnArray[n3];
                if (!treeColumn.isDisposed() && nArray4[n3] != nArray3[n3]) {
                    treeColumn.sendEvent(10);
                }
                ++n3;
            }
        }
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.setItemHeight(null, nSFont, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth();
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((NSOutlineView)this.view).setHeaderView(bl ? this.headerView : null);
    }

    public void setItemCount(int n) {
        this.checkWidget();
        this.checkItems();
        n = Math.max(0, n);
        this.setItemCount(null, n);
    }

    void setItemCount(TreeItem treeItem, int n) {
        boolean bl;
        int n2 = this.getItemCount(treeItem);
        if (n == n2) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n3 = Math.max(4, (n + 3) / 4 * 4);
        TreeItem[] treeItemArray = treeItem == null ? this.items : treeItem.items;
        boolean bl2 = bl = treeItem == null || treeItem.getExpanded();
        if (n < n2) {
            if (treeItem == null) {
                this.itemCount = n;
            } else {
                treeItem.itemCount = n;
            }
            if (bl) {
                int n4 = n;
                while (n4 < n2) {
                    TreeItem treeItem2 = treeItemArray[n4];
                    if (treeItem2 != null && !treeItem2.isDisposed()) {
                        treeItem2.clearSelection();
                    }
                    ++n4;
                }
            }
            TreeItem[] treeItemArray2 = this.getSelection();
            nSOutlineView.reloadItem(treeItem != null ? treeItem.handle : null, bl);
            this.selectItems(treeItemArray2, true);
            int n5 = n;
            while (n5 < n2) {
                TreeItem treeItem3 = treeItemArray[n5];
                if (treeItem3 != null && !treeItem3.isDisposed()) {
                    treeItem3.release(false);
                }
                ++n5;
            }
            TreeItem[] treeItemArray3 = new TreeItem[n3];
            if (treeItemArray != null) {
                System.arraycopy(treeItemArray, 0, treeItemArray3, 0, n);
            }
            treeItemArray = treeItemArray3;
            if (treeItem == null) {
                this.items = treeItemArray3;
            } else {
                treeItem.items = treeItemArray3;
            }
        } else if ((this.style & 0x10000000) == 0) {
            int n6 = n2;
            while (n6 < n) {
                new TreeItem(this, treeItem, 0, n6, true);
                ++n6;
            }
        } else {
            TreeItem[] treeItemArray4 = new TreeItem[n3];
            if (treeItemArray != null) {
                System.arraycopy(treeItemArray, 0, treeItemArray4, 0, n2);
            }
            treeItemArray = treeItemArray4;
            if (treeItem == null) {
                this.items = treeItemArray4;
                this.itemCount = n;
            } else {
                treeItem.items = treeItemArray4;
                treeItem.itemCount = n;
            }
            TreeItem[] treeItemArray5 = this.getSelection();
            nSOutlineView.reloadItem(treeItem != null ? treeItem.handle : null, bl);
            this.selectItems(treeItemArray5, true);
            if (treeItem != null && n2 == 0 && treeItem.expanded) {
                this.ignoreExpand = true;
                nSOutlineView.expandItem(treeItem.handle);
                this.ignoreExpand = false;
            }
        }
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n == -1) {
            this.setItemHeight(null, null, true);
        } else {
            ((NSOutlineView)this.view).setRowHeight(n);
        }
    }

    void setItemHeight(Image image, NSFont nSFont, boolean bl) {
        Rectangle rectangle;
        if (nSFont == null) {
            nSFont = this.getFont().handle;
        }
        double d = nSFont.ascender();
        double d2 = -nSFont.descender() + nSFont.leading();
        int n = (int)Math.ceil(d + d2) + 1;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle != null) {
            this.imageBounds = rectangle;
            n = Math.max(n, rectangle.height);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (bl || nSTableView.rowHeight() < (double)n) {
            nSTableView.setRowHeight(n);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((NSOutlineView)this.view).setUsesAlternatingRowBackgroundColors(bl);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.checkItems();
            this.setScrollWidth();
        }
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(true, this.items, true);
    }

    boolean setScrollWidth(boolean bl, TreeItem[] treeItemArray, boolean bl2) {
        int n;
        if (treeItemArray == null) {
            return false;
        }
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        GC gC = new GC(this);
        int n2 = this.calculateWidth(treeItemArray, 0, gC, bl2);
        gC.dispose();
        if (!bl && (n = (int)this.firstColumn.width()) >= n2) {
            return false;
        }
        this.firstColumn.setWidth(n2);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    boolean setScrollWidth(TreeItem treeItem) {
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null && !treeItem2.getExpanded()) {
            return false;
        }
        GC gC = new GC(this);
        int n = treeItem.calculateWidth(0, gC);
        gC.dispose();
        int n2 = (int)this.firstColumn.width();
        if (n2 < n) {
            this.firstColumn.setWidth(n);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.checkItems();
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.selectItems(treeItemArray, false);
        if (treeItemArray.length > 0) {
            int n2 = 0;
            while (n2 < treeItemArray.length) {
                TreeItem treeItem = treeItemArray[n2];
                if (treeItem != null) {
                    this.showItem(treeItem, true);
                    break;
                }
                ++n2;
            }
        }
    }

    void setSmallSize() {
        if (this.checkColumn == null) {
            return;
        }
        this.checkColumn.dataCell().setControlSize(1L);
        this.checkColumn.setWidth(this.getCheckColumnWidth());
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn == this.sortColumn) {
            return;
        }
        this.sortColumn = treeColumn;
        ((NSOutlineView)this.view).setHighlightedTableColumn(treeColumn == null ? null : treeColumn.nsColumn);
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null) {
            return;
        }
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        int n2 = this.indexOf(this.sortColumn.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n2);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
    }

    public void setTopItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem, false);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        long l = nSOutlineView.rowForItem(treeItem.handle);
        if (l == -1L) {
            return;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSOutlineView.frameOfCellAtColumn((long)0L, (long)l).y;
        this.view.scrollPoint(nSPoint);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int n = this.indexOf(treeColumn.nsColumn);
        if (n < 0 || n >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSOutlineView)this.view).scrollColumnToVisible(n);
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem, true);
    }

    void showItem(TreeItem treeItem, boolean bl) {
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null) {
            this.showItem(treeItem2, false);
            treeItem2.setExpanded(true);
        }
        if (bl) {
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            nSOutlineView.scrollRowToVisible(nSOutlineView.rowForItem(treeItem.handle));
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length > 0) {
            this.checkData(treeItemArray[0]);
            this.showItem(treeItemArray[0], true);
        }
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(bl, this.headerView);
    }
}

