/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;
import org.eclipse.ui.statushandlers.StatusManager;

public class IDEResourceInfoUtils {
    private static String BYTES_LABEL = IDEWorkbenchMessages.ResourceInfo_bytes;
    public static final String EMPTY_STRING = "";
    private static String FILE_LABEL = IDEWorkbenchMessages.ResourceInfo_file;
    private static String FILE_NOT_EXIST_TEXT = IDEWorkbenchMessages.ResourceInfo_fileNotExist;
    private static String FILE_TYPE_FORMAT = IDEWorkbenchMessages.ResourceInfo_fileTypeFormat;
    private static String FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_folder;
    private static String LINKED_FILE_LABEL = IDEWorkbenchMessages.ResourceInfo_linkedFile;
    private static String LINKED_FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_linkedFolder;
    private static String VIRTUAL_FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_virtualFolder;
    private static String VIRTUAL_FOLDER_TEXT = IDEWorkbenchMessages.ResourceInfo_isVirtualFolder;
    private static String MISSING_PATH_VARIABLE_TEXT = IDEWorkbenchMessages.ResourceInfo_undefinedPathVariable;
    private static String NOT_EXIST_TEXT = IDEWorkbenchMessages.ResourceInfo_notExist;
    private static String NOT_LOCAL_TEXT = IDEWorkbenchMessages.ResourceInfo_notLocal;
    private static String PROJECT_LABEL = IDEWorkbenchMessages.ResourceInfo_project;
    private static String UNKNOWN_LABEL = IDEWorkbenchMessages.ResourceInfo_unknown;

    public static boolean exists(String pathName) {
        IFileInfo info = IDEResourceInfoUtils.getFileInfo(pathName);
        if (info == null) {
            return false;
        }
        return info.exists();
    }

    private static String getContentTypeString(IContentDescription description) {
        IContentType contentType;
        if (description != null && (contentType = description.getContentType()) != null) {
            return contentType.getName();
        }
        return null;
    }

    public static String getDateStringValue(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        if (!IDEResourceInfoUtils.isProjectAccessible(resource)) {
            return UNKNOWN_LABEL;
        }
        URI location = resource.getLocationURI();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        IFileInfo info = IDEResourceInfoUtils.getFileInfo(location);
        if (info == null) {
            return UNKNOWN_LABEL;
        }
        if (info.exists()) {
            DateFormat format = DateFormat.getDateTimeInstance((int)1, (int)2);
            return format.format(new Date(info.getLastModified()));
        }
        return NOT_EXIST_TEXT;
    }

    public static IFileInfo getFileInfo(IPath pathName) {
        IFileStore store = IDEResourceInfoUtils.getFileStore(pathName.toFile().toURI());
        if (store == null) {
            return null;
        }
        return store.fetchInfo();
    }

    public static IFileInfo getFileInfo(String pathName) {
        IFileStore store = IDEResourceInfoUtils.getFileStore(pathName);
        if (store == null) {
            return null;
        }
        return store.fetchInfo();
    }

    public static IFileInfo getFileInfo(URI location) {
        if (location.getScheme() == null) {
            return null;
        }
        IFileStore store = IDEResourceInfoUtils.getFileStore(location);
        if (store == null) {
            return null;
        }
        return store.fetchInfo();
    }

    public static IFileStore getFileStore(String string) {
        Path location = new Path(string);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        if (file != null) {
            return IDEResourceInfoUtils.getFileStore(file.getLocationURI());
        }
        return IDEResourceInfoUtils.getFileStore(location.toFile().toURI());
    }

    public static IFileStore getFileStore(URI uri) {
        try {
            return EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            IDEResourceInfoUtils.log(e);
            return null;
        }
    }

    public static String getLocationText(IResource resource) {
        URI resolvedLocation;
        if (resource.isVirtual()) {
            return VIRTUAL_FOLDER_TEXT;
        }
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        URI location = resolvedLocation = resource.getLocationURI();
        boolean isLinked = resource.isLinked();
        if (isLinked) {
            location = resource.getRawLocationURI();
        }
        if (location == null) {
            return NOT_EXIST_TEXT;
        }
        if (resolvedLocation.getScheme() == null) {
            return location.toString();
        }
        IFileStore store = IDEResourceInfoUtils.getFileStore(resolvedLocation);
        boolean isPathVariable = IDEResourceInfoUtils.isPathVariable(resource);
        if (IDEResourceInfoUtils.isProjectAccessible(resource) && resolvedLocation != null && !isPathVariable) {
            if (store == null) {
                return UNKNOWN_LABEL;
            }
            if (!store.fetchInfo().exists()) {
                return NLS.bind((String)FILE_NOT_EXIST_TEXT, (Object)store.toString());
            }
        }
        if (isLinked && isPathVariable) {
            String tmp = URIUtil.toPath((URI)resource.getRawLocationURI()).toOSString();
            return resource.getPathVariableManager().convertToUserEditableFormat(tmp, true);
        }
        if (store != null) {
            return store.toString();
        }
        return location.toString();
    }

    public static String getResolvedLocationText(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        URI location = resource.getLocationURI();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        if (location.getScheme() == null) {
            return UNKNOWN_LABEL;
        }
        IFileStore store = IDEResourceInfoUtils.getFileStore(location);
        if (store == null) {
            return UNKNOWN_LABEL;
        }
        if (IDEResourceInfoUtils.isProjectAccessible(resource) && !store.fetchInfo().exists()) {
            return NLS.bind((String)FILE_NOT_EXIST_TEXT, (Object)store.toString());
        }
        return store.toString();
    }

    public static String getSizeString(IResource resource) {
        if (resource.getType() != 1) {
            return EMPTY_STRING;
        }
        IFile file = (IFile)resource;
        if (!file.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        URI location = file.getLocationURI();
        if (location == null) {
            if (file.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        IFileInfo info = IDEResourceInfoUtils.getFileInfo(location);
        if (info == null) {
            return UNKNOWN_LABEL;
        }
        if (info.exists()) {
            return NLS.bind((String)BYTES_LABEL, (Object)NumberFormat.getInstance().format((Object)new Long(info.getLength())));
        }
        return NOT_EXIST_TEXT;
    }

    public static String getTypeString(IResource resource, IContentDescription description) {
        if (resource.getType() == 1) {
            String contentType;
            if (resource.isLinked()) {
                return LINKED_FILE_LABEL;
            }
            if (resource instanceof IFile && (contentType = IDEResourceInfoUtils.getContentTypeString(description)) != null) {
                return MessageFormat.format((String)FILE_TYPE_FORMAT, (Object[])new String[]{contentType});
            }
            return FILE_LABEL;
        }
        if (resource.getType() == 2) {
            if (resource.isVirtual()) {
                return VIRTUAL_FOLDER_LABEL;
            }
            if (resource.isLinked()) {
                return LINKED_FOLDER_LABEL;
            }
            return FOLDER_LABEL;
        }
        if (resource.getType() == 4) {
            return PROJECT_LABEL;
        }
        return UNKNOWN_LABEL;
    }

    private static boolean isPathVariable(IResource resource) {
        if (!resource.isLinked()) {
            return false;
        }
        URI resolvedLocation = resource.getLocationURI();
        if (resolvedLocation == null) {
            return true;
        }
        URI rawLocation = resource.getRawLocationURI();
        return !resolvedLocation.equals(rawLocation);
    }

    private static boolean isProjectAccessible(IResource resource) {
        IProject project = resource.getProject();
        return project != null && project.isAccessible();
    }

    public static IFileStore[] listFileStores(IFileStore store, IFileStoreFilter fileFilter, IProgressMonitor monitor) {
        IFileStore[] children;
        ArrayList<IFileStore> result = new ArrayList<IFileStore>();
        try {
            children = store.childStores(0, monitor);
        }
        catch (CoreException e) {
            IDEResourceInfoUtils.log(e);
            return new IFileStore[0];
        }
        int i = 0;
        while (i < children.length) {
            if (fileFilter.accept(children[i])) {
                result.add(children[i]);
            }
            ++i;
        }
        IFileStore[] stores = new IFileStore[result.size()];
        result.toArray(stores);
        return stores;
    }

    private static void log(CoreException e) {
        StatusManager.getManager().handle(e, "org.eclipse.ui.ide");
    }
}

