/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms;

import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.ISourceRevealer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class JavaSourceRevealer {
    private static final String SOURCE_REVEALER_EXTENSION_ID = "com.android.ide.eclipse.ddms.sourceRevealer";
    private static List<ISourceRevealer> sSourceRevealers = JavaSourceRevealer.instantiateSourceRevealers();

    private static List<ISourceRevealer> instantiateSourceRevealers() {
        IConfigurationElement[] configElements = DdmsPlugin.getDefault().findConfigElements(SOURCE_REVEALER_EXTENSION_ID);
        ArrayList<ISourceRevealer> providers = new ArrayList<ISourceRevealer>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            Object obj = null;
            try {
                obj = configElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
            if (obj instanceof ISourceRevealer) {
                providers.add((ISourceRevealer)obj);
            }
            ++n2;
        }
        return providers;
    }

    public static boolean reveal(String applicationName, String className, int line) {
        for (ISourceRevealer revealer : sSourceRevealers) {
            try {
                if (!revealer.reveal(applicationName, className, line)) continue;
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    public static boolean revealMethod(String fqmn, String fileName, int linenumber, String perspective) {
        for (ISourceRevealer revealer : sSourceRevealers) {
            try {
                if (!revealer.revealMethod(fqmn, fileName, linenumber, perspective)) continue;
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }
}

