/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int currentEffect = 0;
    TreeItem insertItem = null;
    boolean insertBefore = false;
    TreeItem scrollItem;
    long scrollBeginTime;
    TreeItem expandItem;
    long expandBeginTime;
    DataBrowserCallbacks callbacks = null;
    static Callback AcceptDragProc;
    static /* synthetic */ Class class$0;

    static {
        int n;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.TreeDropTargetEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n = (AcceptDragProc = new Callback(clazz, "AcceptDragProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    int acceptDragProc(int n, int n2, int n3, int n4, int n5) {
        return (this.currentEffect & 1) != 0 ? 1 : 0;
    }

    static int AcceptDragProc(int n, int n2, int n3, int n4, int n5) {
        DropTarget dropTarget = TreeDropTargetEffect.FindDropTarget(n, n5);
        if (dropTarget == null) {
            return 0;
        }
        return (dropTarget.feedback & 1) != 0 ? 1 : 0;
    }

    static DropTarget FindDropTarget(int n, int n2) {
        if (n == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        if (this.callbacks == null) {
            Tree tree = (Tree)this.control;
            DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks(tree.handle, dataBrowserCallbacks);
            dataBrowserCallbacks.v1_acceptDragCallback = AcceptDragProc.getAddress();
            OS.SetDataBrowserCallbacks(tree.handle, dataBrowserCallbacks);
        }
        this.insertItem = null;
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Tree tree = (Tree)this.control;
        if (this.insertItem != null) {
            this.setInsertMark(tree, null, false);
            this.insertItem = null;
        }
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Object object;
        Tree tree = (Tree)this.control;
        TreeItem treeItem = (TreeItem)this.getItem(tree, dropTargetEvent.x, dropTargetEvent.y);
        int n = this.checkEffect(dropTargetEvent.feedback);
        if ((n & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
        } else if (treeItem != null && treeItem.equals(this.expandItem) && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (treeItem.getItemCount() > 0 && !treeItem.getExpanded()) {
                    object = new Event();
                    ((Event)object).x = dropTargetEvent.x;
                    ((Event)object).y = dropTargetEvent.y;
                    ((Event)object).item = treeItem;
                    ((Event)object).time = (int)System.currentTimeMillis();
                    tree.notifyListeners(17, (Event)object);
                    if (treeItem.isDisposed()) {
                        return;
                    }
                    treeItem.setExpanded(true);
                }
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandItem = treeItem;
        }
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (treeItem != null && treeItem.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                object = tree.getClientArea();
                int n2 = tree.getHeaderHeight();
                int n3 = tree.getItemHeight();
                Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
                point = tree.getDisplay().map(null, (Control)tree, point);
                TreeItem treeItem2 = null;
                if (point.y < ((Rectangle)object).y + n2 + 2 * n3) {
                    treeItem2 = this.previousItem(tree, treeItem);
                }
                if (point.y > ((Rectangle)object).y + ((Rectangle)object).height - 2 * n3) {
                    treeItem2 = this.nextItem(tree, treeItem);
                }
                if (treeItem2 != null) {
                    tree.showItem(treeItem2);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = treeItem;
        }
        if ((n & 4) != 0 || (n & 2) != 0) {
            if (this.insertItem != treeItem || (n & 4) != (this.currentEffect & 4) || (n & 2) != (this.currentEffect & 2)) {
                this.setInsertMark(tree, treeItem, (n & 2) != 0);
                this.currentEffect = n;
                this.insertItem = treeItem;
            }
        } else {
            this.setInsertMark(tree, null, false);
        }
        ((DropTarget)dropTargetEvent.widget).feedback = n;
    }

    void setInsertMark(Tree tree, TreeItem treeItem, boolean bl) {
        if (treeItem == this.insertItem && bl == this.insertBefore) {
            return;
        }
        this.insertItem = treeItem;
        this.insertBefore = bl;
        tree.setInsertMark(treeItem, bl);
    }
}

