/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeButtonDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ButtonDrawData
extends DrawData {
    public ButtonDrawData() {
        this.state = new int[1];
    }

    HIThemeButtonDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = new HIThemeButtonDrawInfo();
        hIThemeButtonDrawInfo.version = 0;
        if ((this.style & 8) != 0) {
            hIThemeButtonDrawInfo.kind = 0;
        }
        if ((this.style & 0x20) != 0) {
            hIThemeButtonDrawInfo.kind = 1;
        }
        if ((this.style & 0x10) != 0) {
            hIThemeButtonDrawInfo.kind = 2;
        }
        hIThemeButtonDrawInfo.value = (n & 2) != 0 ? 1 : 0;
        if ((n & 8) != 0) {
            hIThemeButtonDrawInfo.state = 2;
        } else if ((n & 0x10) != 0) {
            hIThemeButtonDrawInfo.state = (n & 0x20) == 0 ? 1 : 7;
        } else {
            int n2 = hIThemeButtonDrawInfo.state = (n & 0x20) == 0 ? 0 : 8;
        }
        if ((n & 0x80) != 0) {
            hIThemeButtonDrawInfo.adornment |= 1;
        }
        if ((n & 4) != 0) {
            hIThemeButtonDrawInfo.adornment |= 4;
        }
        return hIThemeButtonDrawInfo;
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = this.getInfo();
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        CGRect cGRect2 = new CGRect();
        OS.HIThemeGetButtonBackgroundBounds(cGRect, hIThemeButtonDrawInfo, cGRect2);
        cGRect.x += cGRect.x - cGRect2.x;
        cGRect.y += cGRect.y - cGRect2.y;
        cGRect.width -= cGRect2.width - cGRect.width;
        cGRect.height -= cGRect2.height - cGRect.height;
        CGRect cGRect3 = this.clientArea != null ? new CGRect() : null;
        OS.HIThemeDrawButton(cGRect, hIThemeButtonDrawInfo, gC.handle, 0, cGRect3);
        if (this.clientArea != null) {
            this.clientArea.x = (int)cGRect3.x;
            this.clientArea.y = (int)cGRect3.y;
            this.clientArea.width = (int)cGRect3.width;
            this.clientArea.height = (int)cGRect3.height;
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = this.getInfo();
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        CGRect cGRect2 = new CGRect();
        OS.HIThemeGetButtonBackgroundBounds(cGRect, hIThemeButtonDrawInfo, cGRect2);
        cGRect.x += cGRect.x - cGRect2.x;
        cGRect.y += cGRect.y - cGRect2.y;
        cGRect.width -= cGRect2.width - cGRect.width;
        cGRect.height -= cGRect2.height - cGRect.height;
        return new Rectangle((int)cGRect.x, (int)cGRect.y, (int)cGRect.width, (int)cGRect.height).contains(point) ? 0 : -1;
    }
}

