/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.carbon.BitMap;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int GRAB = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int SAFARI_EVENTS_FIX = 524288;
    static final String SAFARI_EVENTS_FIX_KEY = "org.eclipse.swt.internal.safariEventsFix";
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final Rect EMPTY_RECT = new Rect();

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
    }

    int actionProc(int n, int n2) {
        return -9874;
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        return OS.CallNextEventHandler(n5, n4);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    void calculateVisibleRegion(int n, int n2, boolean bl) {
        int n3 = OS.NewRgn();
        if (OS.IsControlVisible(n)) {
            int n4 = OS.NewRgn();
            int n5 = OS.GetControlOwner(n);
            short[] sArray = new short[1];
            int[] nArray = new int[1];
            OS.GetRootControl(n5, nArray);
            int n6 = nArray[0];
            OS.GetControlRegion(n6, (short)-1, n2);
            int n7 = n;
            int n8 = 0;
            while (n7 != n6) {
                OS.GetControlRegion(n7, (short)-1, n3);
                OS.HIViewConvertRegion(n3, n7, n6);
                OS.SectRgn(n3, n2, n2);
                if (OS.EmptyRgn(n2)) break;
                if (bl || n7 != n) {
                    OS.CountSubControls(n7, sArray);
                    int n9 = 0;
                    while (n9 < sArray[0]) {
                        OS.GetIndexedSubControl(n7, (short)(sArray[0] - n9), nArray);
                        int n10 = nArray[0];
                        if (n10 == n8) break;
                        if (OS.IsControlVisible(n10)) {
                            OS.GetControlRegion(n10, (short)-1, n3);
                            OS.HIViewConvertRegion(n3, n10, n6);
                            OS.UnionRgn(n3, n4, n4);
                        }
                        ++n9;
                    }
                }
                n8 = n7;
                OS.GetSuperControl(n7, nArray);
                n7 = nArray[0];
            }
            OS.DiffRgn(n2, n4, n2);
            OS.DisposeRgn(n4);
        } else {
            OS.CopyRgn(n3, n2);
        }
        OS.DisposeRgn(n3);
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    int colorProc(int n, int n2, int n3, int n4) {
        return -9874;
    }

    boolean contains(int n, int n2) {
        return true;
    }

    int clockProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                return this.kEventClockDateOrTimeChanged(n, n2, n3);
            }
        }
        return -9874;
    }

    int controlProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 9: {
                return this.kEventControlActivate(n, n2, n3);
            }
            case 5: {
                return this.kEventControlApplyBackground(n, n2, n3);
            }
            case 154: {
                return this.kEventControlBoundsChanged(n, n2, n3);
            }
            case 13: {
                return this.kEventControlClick(n, n2, n3);
            }
            case 12: {
                return this.kEventControlContextualMenuClick(n, n2, n3);
            }
            case 10: {
                return this.kEventControlDeactivate(n, n2, n3);
            }
            case 4: {
                return this.kEventControlDraw(n, n2, n3);
            }
            case 101: {
                return this.kEventControlGetPartRegion(n, n2, n3);
            }
            case 1: {
                return this.kEventControlHit(n, n2, n3);
            }
            case 11: {
                return this.kEventControlSetCursor(n, n2, n3);
            }
            case 7: {
                return this.kEventControlSetFocusPart(n, n2, n3);
            }
            case 51: {
                return this.kEventControlTrack(n, n2, n3);
            }
            case 8: {
                return this.kEventControlGetFocusPart(n, n2, n3);
            }
            case 3: {
                return this.kEventControlHitTest(n, n2, n3);
            }
            case 17: {
                return this.kEventControlGetClickActivation(n, n2, n3);
            }
        }
        return -9874;
    }

    int accessibilityProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                return this.kEventAccessibleGetChildAtPoint(n, n2, n3);
            }
            case 2: {
                return this.kEventAccessibleGetFocusedChild(n, n2, n3);
            }
            case 21: {
                return this.kEventAccessibleGetAllAttributeNames(n, n2, n3);
            }
            case 22: {
                return this.kEventAccessibleGetNamedAttribute(n, n2, n3);
            }
        }
        return -9874;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyToClipboard(char[] cArray) {
        if (cArray.length == 0) {
            return;
        }
        OS.ClearCurrentScrap();
        int[] nArray = new int[1];
        OS.GetCurrentScrap(nArray);
        int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n == 0) {
            return;
        }
        byte[] byArray = null;
        try {
            block10: {
                block9: {
                    int n2;
                    int[] nArray2;
                    CFRange cFRange;
                    block8: {
                        cFRange = new CFRange();
                        cFRange.length = cArray.length;
                        nArray2 = new int[1];
                        n2 = OS.CFStringGetBytes(n, cFRange, 256, (byte)63, true, null, 0, nArray2);
                        if (n2 != 0) break block8;
                        break block9;
                    }
                    byArray = new byte[nArray2[0]];
                    n2 = OS.CFStringGetBytes(n, cFRange, 256, (byte)63, true, byArray, nArray2[0], nArray2);
                    if (n2 != 0) break block10;
                }
                Object var8_8 = null;
                OS.CFRelease(n);
                return;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OS.CFRelease(n);
            throw throwable;
        }
        OS.CFRelease(n);
        OS.PutScrapFlavor(nArray[0], 1970549046, 0, byArray.length, byArray);
    }

    int createCIcon(Image image) {
        int n = image.handle;
        int n2 = OS.CGImageGetWidth(n);
        int n3 = OS.CGImageGetHeight(n);
        int n4 = OS.CGImageGetBytesPerRow(n);
        int n5 = OS.CGImageGetBitsPerPixel(n);
        int n6 = OS.CGImageGetBitsPerComponent(n);
        int n7 = OS.CGImageGetAlphaInfo(n);
        int n8 = ((n2 + 7) / 8 + 3) / 4 * 4;
        int n9 = n3 * n8;
        int n10 = n3 * n4;
        int n11 = 82 + n9;
        int n12 = OS.NewHandle(n11);
        if (n12 == 0) {
            SWT.error(2);
        }
        OS.HLock(n12);
        int[] nArray = new int[1];
        OS.memmove(nArray, n12, 4);
        PixMap pixMap = new PixMap();
        pixMap.rowBytes = (short)(n4 | 0x8000);
        pixMap.right = (short)n2;
        pixMap.bottom = (short)n3;
        pixMap.cmpCount = (short)3;
        pixMap.cmpSize = (short)n6;
        pixMap.pmTable = OS.NewHandle(0);
        pixMap.hRes = 0x480000;
        pixMap.vRes = 0x480000;
        pixMap.pixelType = (short)16;
        pixMap.pixelSize = (short)n5;
        pixMap.pixelFormat = (short)n5;
        OS.memmove(nArray[0], pixMap, 50);
        BitMap bitMap = new BitMap();
        bitMap.rowBytes = (short)n8;
        bitMap.right = (short)n2;
        bitMap.bottom = (short)n3;
        OS.memmove(nArray[0] + 50, bitMap, 14);
        int n13 = OS.NewHandle(n10);
        OS.HLock(n13);
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, n13, 4);
        OS.memmove(nArray2[0], image.data, n10);
        OS.HUnlock(n13);
        OS.memmove(nArray[0] + 50 + 28, new int[]{n13}, 4);
        if (n7 != 4) {
            OS.memset(nArray[0] + 50 + 28 + 4, -1, n9);
        } else {
            byte[] byArray = new byte[n10];
            OS.memmove(byArray, image.data, n10);
            byte[] byArray2 = new byte[n9];
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            while (n16 < n3) {
                int n17 = 0;
                while (n17 < n2) {
                    if ((byArray[n14] & 0xFF) > 128) {
                        int n18 = n15 + (n17 >> 3);
                        byArray2[n18] = (byte)(byArray2[n18] | 1 << 7 - (n17 & 7));
                    } else {
                        int n19 = n15 + (n17 >> 3);
                        byArray2[n19] = (byte)(byArray2[n19] & ~(1 << 7 - (n17 & 7)));
                    }
                    n14 += 4;
                    ++n17;
                }
                n15 += n8;
                ++n16;
            }
            OS.memmove(nArray[0] + 50 + 28 + 4, byArray2, byArray2.length);
        }
        OS.HUnlock(n12);
        return n12;
    }

    void createHandle() {
    }

    int createIconRef(Image image) {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        int n2;
        int n3;
        int n4 = image.handle;
        int n5 = image.data;
        int n6 = OS.CGImageGetWidth(n4);
        int n7 = OS.CGImageGetHeight(n4);
        int n8 = OS.CGImageGetBytesPerRow(n4);
        int n9 = OS.CGImageGetAlphaInfo(n4);
        int n10 = 0;
        int n11 = 0;
        if (n6 == 16 && n7 == 16) {
            n10 = 1769157426;
            n11 = 1933077867;
        } else if (n6 == 32 && n7 == 32) {
            n10 = 1768698674;
            n11 = 1815637355;
        } else if (n6 == 48 && n7 == 48) {
            n10 = 1768436530;
            n11 = 1748528491;
        } else if (n6 == 128 && n7 == 128) {
            n10 = 1769222962;
            n11 = 1949855083;
        } else {
            n10 = 1769157426;
            n11 = 1933077867;
            n3 = 16;
            if (n6 > 16 || n7 > 16) {
                n10 = 1768436530;
                n11 = 1748528491;
                n3 = 32;
            }
            if (n6 > 32 || n7 > 32) {
                n10 = 1768436530;
                n11 = 1748528491;
                n3 = 48;
            }
            if (n6 > 48 || n7 > 48) {
                n10 = 1769222962;
                n11 = 1949855083;
                n3 = 128;
            }
            if ((n5 = OS.NewPtr(n2 = n7 * (n8 = (n6 = (n7 = n3)) * 4))) == 0) {
                SWT.error(2);
            }
            if ((n = OS.CGColorSpaceCreateDeviceRGB()) == 0) {
                SWT.error(2);
            }
            int n12 = OS.CGBitmapContextCreate(n5, n6, n7, 8, n8, n, 6);
            OS.CGColorSpaceRelease(n);
            if (n12 == 0) {
                SWT.error(2);
            }
            CGRect cGRect = new CGRect();
            cGRect.width = n6;
            cGRect.height = n7;
            OS.CGContextDrawImage(n12, cGRect, n4);
            OS.CGContextRelease(n12);
        }
        if (n10 == 0) {
            return 0;
        }
        n3 = OS.NewHandle(0);
        if (n3 == 0) {
            SWT.error(2);
        }
        if ((n = OS.NewHandle(n2 = n7 * n8)) == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        OS.HLock(n);
        OS.memmove(nArray, n, 4);
        OS.memmove(nArray[0], n5, n2);
        OS.HUnlock(n);
        OS.SetIconFamilyData(n3, n10, n);
        OS.DisposeHandle(n);
        int n13 = n6 * n7;
        int n14 = OS.NewHandle(n13);
        if (n14 == 0) {
            SWT.error(2);
        }
        OS.HLock(n14);
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, n14, 4);
        if (n9 != 4) {
            OS.memset(nArray2[0], 255, n13);
        } else {
            objectArray2 = new byte[n2];
            OS.memmove(objectArray2, n5, n2);
            objectArray = new byte[n13];
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            while (n17 < n7) {
                int n18 = 0;
                while (n18 < n6) {
                    objectArray[n16++] = objectArray2[n15];
                    n15 += 4;
                    ++n18;
                }
                ++n17;
            }
            OS.memmove(nArray2[0], objectArray, objectArray.length);
        }
        OS.HUnlock(n14);
        OS.SetIconFamilyData(n3, n11, n14);
        OS.DisposeHandle(n14);
        if (n5 != image.data) {
            OS.DisposePtr(n5);
        }
        objectArray2 = new int[1];
        OS.HLock(n3);
        objectArray = new int[1];
        OS.memmove((int[])objectArray, n3, 4);
        OS.GetIconRefFromIconFamilyPtr(objectArray[0], OS.GetHandleSize(n3), objectArray2);
        OS.HUnlock(n3);
        OS.DisposeHandle(n3);
        return objectArray2[0];
    }

    void createWidget() {
        this.createHandle();
        this.register();
        this.hookEvents();
    }

    int commandProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                return this.kEventProcessCommand(n, n2, n3);
            }
        }
        return -9874;
    }

    void deregister() {
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    void destroyCIcon(int n) {
        OS.HLock(n);
        int[] nArray = new int[1];
        OS.memmove(nArray, n, 4);
        PixMap pixMap = new PixMap();
        OS.memmove(pixMap, nArray[0], 50);
        if (pixMap.pmTable != 0) {
            OS.DisposeHandle(pixMap.pmTable);
        }
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, nArray[0] + 50 + 28, 4);
        if (nArray2[0] != 0) {
            OS.DisposeHandle(nArray2[0]);
        }
        OS.HUnlock(n);
        OS.DisposeHandle(n);
    }

    int drawItemProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return 0;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void drawBackground(int n, int n2) {
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    int fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            --n2;
        }
        return n2;
    }

    String getClipboardText() {
        int n;
        int n2;
        byte[] byArray;
        String string = "";
        int[] nArray = new int[1];
        OS.GetCurrentScrap(nArray);
        int[] nArray2 = new int[1];
        if (OS.GetScrapFlavorSize(nArray[0], 1970549046, nArray2) == 0) {
            int n3;
            int n4;
            byte[] byArray2;
            if (nArray2[0] != 0 && OS.GetScrapFlavorData(nArray[0], 1970549046, nArray2, byArray2 = new byte[nArray2[0]]) == 0 && (n4 = OS.CFStringCreateWithBytes(0, byArray2, byArray2.length, n3 = 256, true)) != 0) {
                int n5 = OS.CFStringGetLength(n4);
                if (n5 != 0) {
                    char[] cArray = new char[n5];
                    CFRange cFRange = new CFRange();
                    cFRange.length = n5;
                    OS.CFStringGetCharacters(n4, cFRange, cArray);
                    string = new String(cArray);
                }
                OS.CFRelease(n4);
            }
        } else if (OS.GetScrapFlavorSize(nArray[0], 0x54455854, nArray2) == 0 && nArray2[0] != 0 && OS.GetScrapFlavorData(nArray[0], 0x54455854, nArray2, byArray = new byte[nArray2[0]]) == 0 && (n2 = OS.CFStringCreateWithBytes(0, byArray, byArray.length, n = OS.CFStringGetSystemEncoding(), true)) != 0) {
            int n6 = OS.CFStringGetLength(n2);
            if (n6 != 0) {
                char[] cArray = new char[n6];
                CFRange cFRange = new CFRange();
                cFRange.length = n6;
                OS.CFStringGetCharacters(n2, cFRange, cArray);
                string = new String(cArray);
            }
            OS.CFRelease(n2);
        }
        return string;
    }

    Rectangle getControlBounds(int n) {
        CGRect cGRect = new CGRect();
        OS.HIViewGetFrame(n, cGRect);
        Rect rect = this.getInset();
        cGRect.x -= (float)rect.left;
        cGRect.y -= (float)rect.top;
        cGRect.width += (float)(rect.right + rect.left);
        cGRect.height += (float)(rect.bottom + rect.top);
        return new Rectangle((int)cGRect.x, (int)cGRect.y, (int)cGRect.width, (int)cGRect.height);
    }

    Point getControlSize(int n) {
        CGRect cGRect = new CGRect();
        OS.HIViewGetFrame(n, cGRect);
        Rect rect = this.getInset();
        int n2 = (int)cGRect.width + rect.left + rect.right;
        int n3 = (int)cGRect.height + rect.top + rect.bottom;
        return new Point(n2, n3);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            int n = 1;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    Rect getInset() {
        return EMPTY_RECT;
    }

    public Listener[] getListeners(int n) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(n);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    int getVisibleRegion(int n, boolean bl) {
        int n2 = OS.NewRgn();
        this.calculateVisibleRegion(n, n2, bl);
        return n2;
    }

    int helpProc(int n, int n2, int n3, int n4, int n5) {
        return -9874;
    }

    int hitTestProc(int n, int n2, int n3, int n4, int n5) {
        return 1;
    }

    void hookEvents() {
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    void invalidateVisibleRegion(int n) {
    }

    void invalWindowRgn(int n, int n2) {
        OS.InvalWindowRgn(n, n2);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isEnabled() {
        return true;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isTrimHandle(int n) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    int itemCompareProc(int n, int n2, int n3, int n4) {
        return 0;
    }

    int itemDataProc(int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    int itemNotificationProc(int n, int n2, int n3) {
        return 0;
    }

    int kEventAccessibleGetChildAtPoint(int n, int n2, int n3) {
        return -9874;
    }

    int kEventAccessibleGetFocusedChild(int n, int n2, int n3) {
        return -9874;
    }

    int kEventAccessibleGetAllAttributeNames(int n, int n2, int n3) {
        return -9874;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        return -9874;
    }

    int kEventProcessCommand(int n, int n2, int n3) {
        return -9874;
    }

    int kEventClockDateOrTimeChanged(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlApplyBackground(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlActivate(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlBoundsChanged(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlClick(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlContextualMenuClick(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlDeactivate(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlDraw(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 0x2D2D2D2D, 1668575852, null, 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(n2, 1919381096, 1919381096, null, 4, null, nArray2);
        Display display = this.display;
        boolean bl = display.inPaint;
        display.inPaint = true;
        int[] nArray3 = new int[1];
        OS.GetEventParameter(n2, 1668183160, 1668183160, null, 4, null, nArray3);
        int n4 = nArray2[0];
        this.drawBackground(nArray[0], nArray3[0]);
        this.callPaintEventHandler(nArray[0], nArray2[0], n4, n2, n);
        this.drawWidget(nArray[0], nArray3[0], nArray2[0], n4, n2);
        display.inPaint = bl;
        return 0;
    }

    int kEventControlGetClickActivation(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlGetFocusPart(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlGetPartRegion(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlHit(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlHitTest(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlSetCursor(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        return -9874;
    }

    int kEventControlTrack(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 0x2D2D2D2D, 1668575852, null, 4, null, nArray);
        OS.CFRetain(nArray[0]);
        int n4 = OS.CallNextEventHandler(n, n2);
        OS.CFRelease(nArray[0]);
        return n4;
    }

    int kEventMenuCalculateSize(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuClosed(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuCreateFrameView(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuDrawItem(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuDrawItemContent(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuGetFrameBounds(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuMatchKey(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuMeasureItemWidth(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuOpening(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMenuTargetItem(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMouseDragged(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMouseMoved(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMouseUp(int n, int n2, int n3) {
        return -9874;
    }

    int kEventMouseWheelMoved(int n, int n2, int n3) {
        return -9874;
    }

    int kEventSearchFieldCancelClicked(int n, int n2, int n3) {
        return -9874;
    }

    int kEventSearchFieldSearchClicked(int n, int n2, int n3) {
        return -9874;
    }

    int kEventRawKeyDown(int n, int n2, int n3) {
        return this.kEventRawKeyPressed(n, n2, n3);
    }

    int kEventRawKeyModifiersChanged(int n, int n2, int n3) {
        Event event;
        Display display = this.display;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1802334052, 1835100014, null, nArray.length * 4, null, nArray);
        int n4 = display.lastModifiers;
        int n5 = OS.GetCurrentEventButtonState();
        int n6 = 2;
        if ((nArray[0] & 0x400) != 0 && (n4 & 0x400) == 0) {
            n6 = 1;
        }
        if ((nArray[0] & 0x200) != 0 && (n4 & 0x200) == 0) {
            n6 = 1;
        }
        if ((nArray[0] & 0x1000) != 0 && (n4 & 0x1000) == 0) {
            n6 = 1;
        }
        if ((nArray[0] & 0x100) != 0 && (n4 & 0x100) == 0) {
            n6 = 1;
        }
        if ((nArray[0] & 0x800) != 0 && (n4 & 0x800) == 0) {
            n6 = 1;
        }
        if (n6 == 2 && (nArray[0] & 0x400) == 0 && (n4 & 0x400) != 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 1, n5, nArray[0]);
            this.sendKeyEvent(1, event);
        }
        event = new Event();
        this.setInputState(event, n6, n5, nArray[0]);
        if (event.keyCode == 0 && event.character == '\u0000') {
            return -9874;
        }
        boolean bl = this.sendKeyEvent(n6, event);
        if (n6 == 1 && (nArray[0] & 0x400) != 0 && (n4 & 0x400) == 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 2, n5, nArray[0]);
            this.sendKeyEvent(2, event);
        }
        display.lastModifiers = nArray[0];
        return bl ? -9874 : 0;
    }

    int kEventRawKeyPressed(int n, int n2, int n3) {
        return -9874;
    }

    int kEventRawKeyRepeat(int n, int n2, int n3) {
        return this.kEventRawKeyPressed(n, n2, n3);
    }

    int kEventRawKeyUp(int n, int n2, int n3) {
        if (!this.sendKeyEvent(2, n2)) {
            return 0;
        }
        return -9874;
    }

    int kEventTextInputUnicodeForKeyEvent(int n, int n2, int n3) {
        return -9874;
    }

    int kEventTextInputUpdateActiveInputArea(int n, int n2, int n3) {
        return -9874;
    }

    int kEventTextInputOffsetToPos(int n, int n2, int n3) {
        return -9874;
    }

    int kEventTextInputPosToOffset(int n, int n2, int n3) {
        return -9874;
    }

    int kEventTextInputGetSelectedText(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowActivated(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowBoundsChanged(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowClose(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowCollapsed(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowCollapsing(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowDeactivated(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowDrawContent(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowExpanded(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowGetClickModality(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowGetRegion(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowHidden(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowHitTest(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowShown(int n, int n2, int n3) {
        return -9874;
    }

    int kEventWindowUpdate(int n, int n2, int n3) {
        return -9874;
    }

    int keyboardProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                return this.kEventRawKeyDown(n, n2, n3);
            }
            case 4: {
                return this.kEventRawKeyModifiersChanged(n, n2, n3);
            }
            case 2: {
                return this.kEventRawKeyRepeat(n, n2, n3);
            }
            case 3: {
                return this.kEventRawKeyUp(n, n2, n3);
            }
        }
        return -9874;
    }

    int menuProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1004: {
                return this.kEventMenuCalculateSize(n, n2, n3);
            }
            case 5: {
                return this.kEventMenuClosed(n, n2, n3);
            }
            case 1005: {
                return this.kEventMenuCreateFrameView(n, n2, n3);
            }
            case 102: {
                return this.kEventMenuDrawItem(n, n2, n3);
            }
            case 103: {
                return this.kEventMenuDrawItemContent(n, n2, n3);
            }
            case 1006: {
                return this.kEventMenuGetFrameBounds(n, n2, n3);
            }
            case 7: {
                return this.kEventMenuMatchKey(n, n2, n3);
            }
            case 100: {
                return this.kEventMenuMeasureItemWidth(n, n2, n3);
            }
            case 4: {
                return this.kEventMenuOpening(n, n2, n3);
            }
            case 6: {
                return this.kEventMenuTargetItem(n, n2, n3);
            }
        }
        return -9874;
    }

    int mouseProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                return this.kEventMouseDown(n, n2, n3);
            }
            case 2: {
                return this.kEventMouseUp(n, n2, n3);
            }
            case 6: {
                return this.kEventMouseDragged(n, n2, n3);
            }
            case 5: {
                return this.kEventMouseMoved(n, n2, n3);
            }
            case 10: {
                return this.kEventMouseWheelMoved(n, n2, n3);
            }
        }
        return -9874;
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void redrawChildren(int n) {
        int n2 = OS.HIViewGetFirstSubview(n);
        while (n2 != 0) {
            OS.HIViewSetNeedsDisplay(n2, true);
            this.redrawChildren(n2);
            n2 = OS.HIViewGetNextView(n2);
        }
    }

    void redrawChildren(int n, int n2) {
        int n3 = OS.HIViewGetFirstSubview(n);
        while (n3 != 0) {
            OS.HIViewConvertRegion(n2, n, n3);
            OS.HIViewSetNeedsDisplayInRegion(n3, n2, true);
            this.redrawChildren(n3, n2);
            OS.HIViewConvertRegion(n2, n3, n);
            n3 = OS.HIViewGetNextView(n3);
        }
    }

    void redrawWidget(int n, boolean bl) {
        if (this.display.inPaint) {
            int n2 = OS.NewRgn();
            Rect rect = new Rect();
            OS.GetControlBounds(n, rect);
            rect.right = (short)(rect.right + rect.left);
            rect.bottom = (short)(rect.bottom + rect.top);
            rect.left = 0;
            rect.top = 0;
            OS.RectRgn(n2, rect);
            OS.HIViewConvertRegion(n2, n, 0);
            this.invalWindowRgn(0, n2);
            OS.DisposeRgn(n2);
        } else {
            OS.HIViewSetNeedsDisplay(n, true);
            if (bl) {
                this.redrawChildren(n);
            }
        }
    }

    void redrawWidget(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = OS.NewRgn();
        Rect rect = new Rect();
        OS.SetRect(rect, (short)n2, (short)n3, (short)(n2 + n4), (short)(n3 + n5));
        OS.RectRgn(n6, rect);
        if (this.display.inPaint) {
            OS.HIViewConvertRegion(n6, n, 0);
            this.invalWindowRgn(0, n6);
        } else {
            OS.HIViewSetNeedsDisplayInRegion(n, n6, true);
            if (bl) {
                this.redrawChildren(n, n6);
            }
        }
        OS.DisposeRgn(n6);
    }

    void register() {
    }

    void release(boolean bl) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    int searchProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 1: {
                return this.kEventSearchFieldCancelClicked(n, n2, n3);
            }
            case 2: {
                return this.kEventSearchFieldSearchClicked(n, n2, n3);
            }
        }
        return -9874;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n, int n2) {
        if ((this.state & 0x80000) != 0) {
            return true;
        }
        int[] nArray = new int[1];
        int n3 = OS.GetEventParameter(n2, 1802858089, 1970567284, null, 4, nArray, null);
        if (n3 == 0 && nArray[0] > 2) {
            int n4 = 0;
            int[] nArray2 = new int[1];
            OS.GetEventParameter(n2, 1667788658, 1835100014, null, 4, null, nArray2);
            int[] nArray3 = new int[1];
            OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray3);
            char[] cArray = new char[nArray[0] / 2];
            OS.GetEventParameter(n2, 1802858089, 1970567284, null, cArray.length * 2, null, cArray);
            int n5 = 0;
            while (n5 < cArray.length) {
                Event event = new Event();
                event.character = cArray[n5];
                this.setInputState(event, n, nArray2[0], nArray3[0]);
                if (this.sendKeyEvent(n, event)) {
                    cArray[n4++] = cArray[n5];
                }
                ++n5;
            }
            if (n4 == 0) {
                return false;
            }
            if (n4 != cArray.length - 1) {
                OS.SetEventParameter(n2, 1802858089, 1970567284, n4 * 2, cArray);
            }
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, n, n2)) {
            return true;
        }
        return this.sendKeyEvent(n, event);
    }

    boolean sendKeyEvent(int n, Event event) {
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    int setBounds(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        int n6;
        boolean bl4 = true;
        boolean bl5 = true;
        CGRect cGRect = new CGRect();
        OS.HIViewGetFrame(n, cGRect);
        Rect rect = this.getInset();
        cGRect.x -= (float)rect.left;
        cGRect.y -= (float)rect.top;
        cGRect.width += (float)(rect.left + rect.right);
        cGRect.height += (float)(rect.top + rect.bottom);
        if (!bl) {
            n2 = (int)cGRect.x;
            n3 = (int)cGRect.y;
        }
        if (!bl2) {
            n4 = (int)cGRect.width;
            n5 = (int)cGRect.height;
        }
        CGRect cGRect2 = new CGRect();
        cGRect2.x = n2 + rect.left;
        cGRect2.y = n3 + rect.top;
        cGRect2.width = n4 - rect.right - rect.left;
        cGRect2.height = n5 - rect.bottom - rect.top;
        bl4 = cGRect2.x == cGRect.x && cGRect2.y == cGRect.y;
        boolean bl6 = bl5 = cGRect2.width == cGRect.width && cGRect2.height == cGRect.height;
        if (bl4 && bl5) {
            return 0;
        }
        OS.HIViewSetFrame(n, cGRect2);
        this.invalidateVisibleRegion(n);
        if (!OS.HIViewIsDrawingEnabled(n) && (n6 = OS.HIViewGetSuperview(n)) != 0 && OS.HIViewIsDrawingEnabled(n6)) {
            int n7 = OS.NewRgn();
            Rect rect2 = new Rect();
            OS.SetRect(rect2, (short)cGRect.x, (short)cGRect.y, (short)(cGRect.x + cGRect.width), (short)(cGRect.y + cGRect.height));
            OS.RectRgn(n7, rect2);
            if (this.display.inPaint) {
                OS.HIViewConvertRegion(n7, n6, 0);
                this.invalWindowRgn(0, n7);
            } else {
                OS.HIViewSetNeedsDisplayInRegion(n6, n7, true);
            }
            OS.DisposeRgn(n7);
        }
        n6 = 0;
        if (bl && !bl4) {
            if (bl3) {
                this.sendEvent(10);
            }
            n6 |= 0x40;
        }
        if (bl2 && !bl5) {
            if (bl3) {
                this.sendEvent(11);
            }
            n6 |= 0x80;
        }
        return n6;
    }

    public void setData(Object object) {
        this.checkWidget();
        if (SAFARI_EVENTS_FIX_KEY.equals(object)) {
            this.state |= 0x80000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n = 1;
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) break;
                n += 2;
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
    }

    boolean setInputState(Event event, int n, int n2, int n3) {
        if ((n2 & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n2 & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((n2 & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n2 & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((n2 & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        if ((n3 & 0x800) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((n3 & 0x200) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((n3 & 0x1000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((n3 & 0x100) != 0) {
            event.stateMask |= 0x400000;
        }
        switch (n) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode != 0 || event.character != '\u0000') {
                    return true;
                }
                int n4 = this.display.lastModifiers;
                if ((n3 & 0x400) != 0 && (n4 & 0x400) == 0) {
                    event.keyCode = 16777298;
                    return true;
                }
                if ((n3 & 0x200) != 0 && (n4 & 0x200) == 0) {
                    event.stateMask &= 0xFFFDFFFF;
                    event.keyCode = 131072;
                    return true;
                }
                if ((n3 & 0x1000) != 0 && (n4 & 0x1000) == 0) {
                    event.stateMask &= 0xFFFBFFFF;
                    event.keyCode = 262144;
                    return true;
                }
                if ((n3 & 0x100) != 0 && (n4 & 0x100) == 0) {
                    event.stateMask &= 0xFFBFFFFF;
                    event.keyCode = 0x400000;
                    return true;
                }
                if ((n3 & 0x800) == 0 || (n4 & 0x800) != 0) break;
                event.stateMask &= 0xFFFEFFFF;
                event.keyCode = 65536;
                return true;
            }
            case 2: {
                if (event.keyCode != 0 || event.character != '\u0000') {
                    return true;
                }
                int n5 = this.display.lastModifiers;
                if ((n3 & 0x400) == 0 && (n5 & 0x400) != 0) {
                    event.keyCode = 16777298;
                    return true;
                }
                if ((n3 & 0x200) == 0 && (n5 & 0x200) != 0) {
                    event.stateMask |= 0x20000;
                    event.keyCode = 131072;
                    return true;
                }
                if ((n3 & 0x1000) == 0 && (n5 & 0x1000) != 0) {
                    event.stateMask |= 0x40000;
                    event.keyCode = 262144;
                    return true;
                }
                if ((n3 & 0x100) == 0 && (n5 & 0x100) != 0) {
                    event.stateMask |= 0x400000;
                    event.keyCode = 0x400000;
                    return true;
                }
                if ((n3 & 0x800) != 0 || (n5 & 0x800) == 0) break;
                event.stateMask |= 0x10000;
                event.keyCode = 65536;
                return true;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n, int n2) {
        int[] nArray;
        boolean bl = false;
        int[] nArray2 = new int[1];
        OS.GetEventParameter(n2, 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        event.keyCode = Display.translateKey(nArray2[0]);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                short s;
                int[] nArray3;
                int n3;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (n3 = OS.GetEventParameter(n2, 1802858089, 1970567284, null, 4, nArray = new int[1], null)) == 0 && nArray[0] != 0) {
                    char[] cArray = new char[1];
                    OS.GetEventParameter(n2, 1802858089, 1970567284, null, 2, null, cArray);
                    event.character = cArray[0];
                }
                if (event.keyCode != 0) break;
                int n4 = OS.GetScriptManagerVariable((short)38);
                if (this.display.kchrPtr != n4) {
                    this.display.kchrPtr = n4;
                    this.display.kchrState[0] = 0;
                }
                int[] nArray4 = new int[1];
                int n5 = 1;
                if (OS.KLGetCurrentKeyboardLayout(nArray4) == 0) {
                    nArray3 = new int[1];
                    OS.KLGetKeyboardLayoutProperty(nArray4[0], 7, nArray3);
                    n5 = nArray3[0];
                }
                if (n5 == 2) {
                    nArray3 = new int[1];
                    OS.KLGetKeyboardLayoutProperty(nArray4[0], 1, nArray3);
                    int n6 = 256;
                    char[] cArray = new char[n6];
                    int[] nArray5 = new int[1];
                    OS.UCKeyTranslate(nArray3[0], (short)nArray2[0], (short)0, 0, OS.LMGetKbdType(), 0, this.display.kchrState, n6, nArray5, cArray);
                    if (nArray5[0] < 1) {
                        event.keyCode = 0;
                        break;
                    }
                    event.keyCode = cArray[0];
                    break;
                }
                int n7 = OS.KeyTranslate(this.display.kchrPtr, (short)nArray2[0], this.display.kchrState);
                if (n7 <= 127) {
                    event.keyCode = n7 & 0x7F;
                    break;
                }
                int[] nArray6 = new int[1];
                short s2 = (short)OS.GetScriptManagerVariable((short)22);
                if (OS.UpgradeScriptInfoToTextEncoding(s2, (short)-128, s = (short)OS.GetScriptManagerVariable((short)40), null, nArray6) == -50 && OS.UpgradeScriptInfoToTextEncoding(s2, (short)-128, (short)-128, null, nArray6) == -50) {
                    nArray6[0] = 0;
                }
                int[] nArray7 = new int[1];
                OS.CreateTextToUnicodeInfoByEncoding(nArray6[0], nArray7);
                if (nArray7[0] == 0) break;
                char[] cArray = new char[1];
                int[] nArray8 = new int[1];
                byte[] byArray = new byte[]{1, (byte)(n7 & 0xFF)};
                OS.ConvertFromPStringToUnicode(nArray7[0], byArray, cArray.length * 2, nArray8, cArray);
                OS.DisposeTextToUnicodeInfo(nArray7);
                event.keyCode = cArray[0];
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        nArray = new int[1];
        OS.GetEventParameter(n2, 1667788658, 1835100014, null, 4, null, nArray);
        int[] nArray9 = new int[1];
        OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray9);
        return this.setInputState(event, n, nArray[0], nArray9[0]);
    }

    void setVisible(int n, boolean bl) {
        OS.HIViewSetVisible(n, bl);
        this.invalidateVisibleRegion(n);
    }

    void setZOrder(int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 2;
        OS.HIViewSetZOrder(n, n3, n2);
        this.invalidateVisibleRegion(n);
    }

    int textInputProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 2: {
                return this.kEventTextInputUnicodeForKeyEvent(n, n2, n3);
            }
            case 1: {
                return this.kEventTextInputUpdateActiveInputArea(n, n2, n3);
            }
            case 3: {
                return this.kEventTextInputOffsetToPos(n, n2, n3);
            }
            case 4: {
                return this.kEventTextInputPosToOffset(n, n2, n3);
            }
            case 6: {
                return this.kEventTextInputGetSelectedText(n, n2, n3);
            }
        }
        return -9874;
    }

    RGBColor toRGBColor(float[] fArray) {
        RGBColor rGBColor = new RGBColor();
        rGBColor.red = (short)(fArray[0] * 65535.0f);
        rGBColor.green = (short)(fArray[1] * 65535.0f);
        rGBColor.blue = (short)(fArray[2] * 65535.0f);
        return rGBColor;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int trackingProc(int n, int n2, int n3, int n4, int n5, int n6) {
        return 1;
    }

    int windowProc(int n, int n2, int n3) {
        int n4 = OS.GetEventKind(n2);
        switch (n4) {
            case 5: {
                return this.kEventWindowActivated(n, n2, n3);
            }
            case 27: {
                return this.kEventWindowBoundsChanged(n, n2, n3);
            }
            case 72: {
                return this.kEventWindowClose(n, n2, n3);
            }
            case 67: {
                return this.kEventWindowCollapsed(n, n2, n3);
            }
            case 86: {
                return this.kEventWindowCollapsing(n, n2, n3);
            }
            case 6: {
                return this.kEventWindowDeactivated(n, n2, n3);
            }
            case 2: {
                return this.kEventWindowDrawContent(n, n2, n3);
            }
            case 70: {
                return this.kEventWindowExpanded(n, n2, n3);
            }
            case 1002: {
                return this.kEventWindowGetRegion(n, n2, n3);
            }
            case 25: {
                return this.kEventWindowHidden(n, n2, n3);
            }
            case 1003: {
                return this.kEventWindowHitTest(n, n2, n3);
            }
            case 24: {
                return this.kEventWindowShown(n, n2, n3);
            }
            case 1: {
                return this.kEventWindowUpdate(n, n2, n3);
            }
            case 8: {
                return this.kEventWindowGetClickModality(n, n2, n3);
            }
        }
        return -9874;
    }
}

